/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.message.type.TdsDataType;
import io.r2dbc.mssql.util.ReferenceCountUtil;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import reactor.core.Disposable;

public class Encoded
implements Disposable {
    private final TdsDataType dataType;
    private final Supplier<ByteBuf> encoder;

    Encoded(TdsDataType dataType, Supplier<ByteBuf> encoder) {
        this.dataType = dataType;
        this.encoder = encoder;
    }

    public static Encoded of(TdsDataType dataType, ByteBuf value) {
        return new Encoded(dataType, new DisposableSupplier(value));
    }

    public static Encoded of(TdsDataType dataType, Supplier<ByteBuf> value) {
        return new Encoded(dataType, value);
    }

    public TdsDataType getDataType() {
        return this.dataType;
    }

    public ByteBuf getValue() {
        return this.encoder.get();
    }

    public String getFormalType() {
        for (SqlServerType serverType : SqlServerType.values()) {
            for (TdsDataType tdsType : serverType.getFixedTypes()) {
                if (tdsType != this.dataType) continue;
                return serverType.toString();
            }
        }
        throw new IllegalStateException(String.format("Cannot determine a formal type for %s", new Object[]{this.dataType}));
    }

    public int estimateLength() {
        if (this.encoder instanceof DisposableSupplier) {
            return ((DisposableSupplier)this.encoder).get().readableBytes();
        }
        if (this.encoder instanceof LengthAwareSupplier) {
            return ((LengthAwareSupplier)this.encoder).getLength();
        }
        return 0;
    }

    public static Supplier<ByteBuf> ofLengthAware(int length, IntFunction<ByteBuf> supplier) {
        return new LengthAwareSupplier(length, supplier);
    }

    public void dispose() {
        if (this.encoder instanceof DisposableSupplier) {
            ((DisposableSupplier)this.encoder).dispose();
        }
    }

    static class DisposableSupplier
    implements Supplier<ByteBuf>,
    Disposable {
        private final ByteBuf buf;

        DisposableSupplier(ByteBuf buf) {
            this.buf = buf;
        }

        @Override
        public ByteBuf get() {
            return this.buf.asReadOnly();
        }

        public void dispose() {
            ReferenceCountUtil.maybeSafeRelease(this.buf);
        }

        public boolean isDisposed() {
            return this.buf.refCnt() == 0;
        }
    }

    static class LengthAwareSupplier
    implements Supplier<ByteBuf> {
        private final int length;
        private final IntFunction<ByteBuf> delegate;

        public LengthAwareSupplier(int length, IntFunction<ByteBuf> delegate) {
            this.length = length;
            this.delegate = delegate;
        }

        @Override
        public ByteBuf get() {
            return this.delegate.apply(this.length);
        }

        public int getLength() {
            return this.length;
        }
    }
}

