/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.r2dbc.mssql.codec.Encoded;
import io.r2dbc.mssql.message.tds.Encode;
import io.r2dbc.mssql.message.type.Length;
import io.r2dbc.mssql.message.type.LengthStrategy;
import io.r2dbc.mssql.message.type.PlpLength;
import io.r2dbc.mssql.message.type.SqlServerType;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.IntSupplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

public class PlpEncoded
extends Encoded {
    private final SqlServerType serverType;
    private final ByteBufAllocator allocator;
    private final Publisher<ByteBuf> dataStream;
    private final Disposable disposable;

    public PlpEncoded(SqlServerType dataType, ByteBufAllocator allocator, Publisher<ByteBuf> dataStream, Disposable disposable) {
        super(dataType.getNullableType(), () -> Unpooled.EMPTY_BUFFER);
        this.serverType = dataType;
        this.allocator = allocator;
        this.dataStream = dataStream;
        this.disposable = disposable;
    }

    public void encodeHeader(ByteBuf byteBuf) {
        Encode.uShort(byteBuf, 65535);
    }

    public boolean isDisposed() {
        return this.disposable.isDisposed();
    }

    @Override
    public void dispose() {
        this.disposable.dispose();
    }

    public Flux<ByteBuf> chunked(IntSupplier chunkSize) {
        return this.chunked(chunkSize, false);
    }

    public Flux<ByteBuf> chunked(IntSupplier chunkSize, boolean withSizeHeaders) {
        return new ChunkOperator((Flux<ByteBuf>)Flux.from(this.dataStream), this.allocator, chunkSize, withSizeHeaders);
    }

    @Override
    public String getFormalType() {
        switch (this.serverType) {
            case VARBINARYMAX: {
                return "VARBINARY(MAX)";
            }
            case VARCHARMAX: {
                return "VARCHAR(MAX)";
            }
            case NVARCHARMAX: {
                return "NVARCHAR(MAX)";
            }
        }
        throw new UnsupportedOperationException("Type " + (Object)((Object)this.serverType) + " not supported");
    }

    static class ChunkOperator
    extends FluxOperator<ByteBuf, ByteBuf> {
        private final ByteBufAllocator allocator;
        private final IntSupplier chunkSizeSupplier;
        private final boolean withSizeHeaders;

        ChunkOperator(Flux<ByteBuf> source, ByteBufAllocator allocator, IntSupplier chunkSizeSupplier, boolean withSizeHeaders) {
            super(source);
            this.allocator = allocator;
            this.chunkSizeSupplier = chunkSizeSupplier;
            this.withSizeHeaders = withSizeHeaders;
        }

        public void subscribe(CoreSubscriber<? super ByteBuf> actual) {
            this.source.subscribe((CoreSubscriber)new ChunkSubscriber(actual, this.allocator, this.chunkSizeSupplier, this.withSizeHeaders));
        }
    }

    static class ChunkSubscriber
    extends AtomicLong
    implements CoreSubscriber<ByteBuf>,
    Subscription {
        private static final int STATUS_WIP = 0;
        private static final int STATUS_DONE = 1;
        private final CoreSubscriber<? super ByteBuf> actual;
        private final ByteBufAllocator allocator;
        private final IntSupplier chunkSizeSupplier;
        private final boolean withSizeHeaders;
        private boolean first = true;
        private volatile int nextChunkSize;
        @Nullable
        private volatile CompositeByteBuf aggregator;
        volatile long requested;
        static final AtomicLongFieldUpdater<ChunkSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(ChunkSubscriber.class, "requested");
        volatile int status;
        static final AtomicIntegerFieldUpdater<ChunkSubscriber> STATUS = AtomicIntegerFieldUpdater.newUpdater(ChunkSubscriber.class, "status");
        private boolean doneUpstream;
        private Subscription s;

        ChunkSubscriber(CoreSubscriber<? super ByteBuf> actual, ByteBufAllocator allocator, IntSupplier chunkSizeSupplier, boolean withSizeHeaders) {
            this.actual = actual;
            this.allocator = allocator;
            this.chunkSizeSupplier = chunkSizeSupplier;
            this.withSizeHeaders = withSizeHeaders;
        }

        public Context currentContext() {
            return this.actual.currentContext();
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(ByteBuf byteBuf) {
            byteBuf.touch((Object)"PlpEncoded.onNext(\u2026)");
            if (STATUS.get(this) == 1) {
                byteBuf.release();
                Operators.onNextDropped((Object)byteBuf, (Context)this.actual.currentContext());
                return;
            }
            CompositeByteBuf aggregator = this.aggregator;
            if (aggregator == null) {
                this.aggregator = aggregator = this.allocator.compositeBuffer();
            }
            aggregator.addComponent(true, byteBuf);
            this.drain();
            if (!this.doneUpstream && REQUESTED.get(this) > 0L) {
                this.s.request(1L);
            }
        }

        private void drain() {
            long demand;
            CompositeByteBuf aggregator = this.aggregator;
            if (aggregator == null) {
                if (this.doneUpstream && STATUS.compareAndSet(this, 0, 1)) {
                    this.actual.onComplete();
                }
                return;
            }
            while (STATUS.get(this) == 0 && aggregator.readableBytes() >= this.nextChunkSize && REQUESTED.get(this) > 0L) {
                demand = REQUESTED.get(this);
                if (demand <= 0L || !REQUESTED.compareAndSet(this, demand, demand - 1L)) continue;
                this.emitNext(aggregator, this.nextChunkSize);
                this.nextChunkSize = this.chunkSizeSupplier.getAsInt();
            }
            if (STATUS.get(this) == 0 && this.doneUpstream && aggregator.isReadable() && REQUESTED.get(this) > 0L && (demand = REQUESTED.get(this)) > 0L && REQUESTED.compareAndSet(this, demand, demand - 1L)) {
                this.emitNext(aggregator, aggregator.readableBytes());
            }
            if (this.doneUpstream && !aggregator.isReadable() && STATUS.compareAndSet(this, 0, 1)) {
                aggregator.release();
                this.aggregator = null;
                this.actual.onComplete();
            } else {
                aggregator.discardReadComponents();
            }
        }

        private void emitNext(CompositeByteBuf aggregator, int bytesToRead) {
            ByteBuf buffer = aggregator.alloc().buffer(bytesToRead);
            buffer.writeBytes((ByteBuf)aggregator, bytesToRead);
            if (this.withSizeHeaders) {
                CompositeByteBuf composite = this.allocator.compositeBuffer();
                ByteBuf header = this.allocator.buffer();
                if (this.first) {
                    this.first = false;
                    PlpLength.unknown().encode(header);
                }
                Length chunkLength = Length.of(bytesToRead);
                chunkLength.encode(header, LengthStrategy.PARTLENTYPE);
                composite.addComponent(true, header);
                composite.addComponent(true, buffer);
                buffer = composite;
            }
            this.actual.onNext((Object)buffer);
        }

        public void onError(Throwable t) {
            CompositeByteBuf aggregator = this.aggregator;
            if (STATUS.compareAndSet(this, 0, 1)) {
                this.doneUpstream = true;
                this.actual.onError(t);
                if (aggregator != null) {
                    aggregator.release();
                }
                return;
            }
            Operators.onErrorDropped((Throwable)t, (Context)this.actual.currentContext());
        }

        public void onComplete() {
            this.doneUpstream = true;
            this.drain();
        }

        public void request(long n) {
            if (Operators.validate((long)n)) {
                Operators.addCap(REQUESTED, (Object)this, (long)n);
                this.drain();
                this.nextChunkSize = this.chunkSizeSupplier.getAsInt();
                if (!this.doneUpstream && REQUESTED.get(this) > 0L) {
                    this.s.request(1L);
                }
            }
        }

        public void cancel() {
            CompositeByteBuf aggregator;
            if (!this.doneUpstream) {
                this.doneUpstream = true;
                this.s.cancel();
            }
            if (STATUS.compareAndSet(this, 0, 1) && (aggregator = this.aggregator) != null) {
                aggregator.release();
            }
        }
    }
}

