/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.codec;

import io.r2dbc.mssql.codec.RpcDirection;
import io.r2dbc.mssql.message.type.Collation;
import io.r2dbc.mssql.message.type.SqlServerType;
import io.r2dbc.mssql.util.Assert;
import reactor.util.annotation.Nullable;

public final class RpcParameterContext {
    private static final RpcParameterContext IN = new RpcParameterContext(RpcDirection.IN, null, null);
    private static final RpcParameterContext OUT = new RpcParameterContext(RpcDirection.OUT, null, null);
    private final RpcDirection direction;
    @Nullable
    private final ValueContext valueContext;
    @Nullable
    private final SqlServerType serverType;

    private RpcParameterContext(RpcDirection direction, @Nullable ValueContext valueContext, @Nullable SqlServerType serverType) {
        this.direction = direction;
        this.serverType = serverType;
        this.valueContext = valueContext;
    }

    public static RpcParameterContext in() {
        return IN;
    }

    public static RpcParameterContext in(ValueContext valueContext) {
        return new RpcParameterContext(RpcDirection.IN, Assert.requireNonNull(valueContext, "ValueContext must not be null"), null);
    }

    public static RpcParameterContext out() {
        return OUT;
    }

    public static RpcParameterContext out(ValueContext valueContext) {
        return new RpcParameterContext(RpcDirection.OUT, Assert.requireNonNull(valueContext, "ValueContext must not be null"), null);
    }

    public RpcDirection getDirection() {
        return this.direction;
    }

    public boolean isIn() {
        return this.direction == RpcDirection.IN;
    }

    public boolean isOut() {
        return this.direction == RpcDirection.OUT;
    }

    @Nullable
    public ValueContext getValueContext() {
        return this.valueContext;
    }

    @Nullable
    public SqlServerType getServerType() {
        return this.serverType;
    }

    public ValueContext getRequiredValueContext() {
        ValueContext valueContext = this.getValueContext();
        if (valueContext == null) {
            throw new IllegalStateException("No ValueContext set");
        }
        return valueContext;
    }

    public <T extends ValueContext> T getRequiredValueContext(Class<? extends T> contextType) {
        ValueContext valueContext = this.getRequiredValueContext();
        return (T)((ValueContext)contextType.cast(valueContext));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [direction=").append((Object)this.direction);
        sb.append(", valueContext=").append(this.valueContext);
        sb.append(']');
        return sb.toString();
    }

    public RpcParameterContext withServerType(SqlServerType serverType) {
        Assert.requireNonNull(serverType, "SqlServerType must not be null");
        return new RpcParameterContext(this.direction, this.valueContext, serverType);
    }

    public static interface ValueContext {
        public static ValueContext character(Collation collation, boolean sendStringParametersAsUnicode) {
            return new CharacterValueContext(collation, sendStringParametersAsUnicode);
        }
    }

    public static class CharacterValueContext
    implements ValueContext {
        private final Collation collation;
        private final boolean sendStringParametersAsUnicode;

        public CharacterValueContext(Collation collation, boolean sendStringParametersAsUnicode) {
            this.collation = collation;
            this.sendStringParametersAsUnicode = sendStringParametersAsUnicode;
        }

        public Collation getCollation() {
            return this.collation;
        }

        public boolean isSendStringParametersAsUnicode() {
            return this.sendStringParametersAsUnicode;
        }
    }
}

