/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.mssql.message.ClientMessage;
import io.r2dbc.mssql.message.TDSVersion;
import io.r2dbc.mssql.message.header.HeaderOptions;
import io.r2dbc.mssql.message.header.Status;
import io.r2dbc.mssql.message.header.Type;
import io.r2dbc.mssql.message.tds.TdsFragment;
import io.r2dbc.mssql.message.tds.TdsPackets;
import io.r2dbc.mssql.message.token.TokenStream;
import io.r2dbc.mssql.util.Assert;
import io.r2dbc.mssql.util.DriverVersion;
import io.r2dbc.mssql.util.Version;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.function.Function;
import reactor.util.annotation.Nullable;

public final class Login7
implements TokenStream,
ClientMessage {
    private static final short TDS_LOGIN_REQUEST_BASE_LEN = 94;
    private static final HeaderOptions header = HeaderOptions.create(Type.TDS7_LOGIN, Status.empty());
    private final int estimatedPacketLength;
    private final int baseLength;
    private final TDSVersion tdsVersion;
    private final int packetSize;
    private final byte[] clientProgVer;
    private final int clientPid;
    private final int connectionId;
    private final OptionFlags1 optionFlags1;
    private final OptionFlags2 optionFlags2;
    private final TypeFlags typeFlags;
    private final OptionFlags3 optionFlags3;
    private final Collection<LoginRequestToken> tokens;
    private final byte[] clientId;
    private final ConditionalProtocolSegment passwordChange;

    private Login7(TDSVersion tdsVersion, int packetSize, byte[] clientProgVer, int clientPid, int connectionId, OptionFlags1 optionFlags1, OptionFlags2 optionFlags2, TypeFlags typeFlags, OptionFlags3 optionFlags3, Collection<LoginRequestToken> tokens, byte[] clientId) {
        this.tdsVersion = tdsVersion;
        this.packetSize = packetSize;
        this.clientProgVer = clientProgVer;
        this.clientPid = clientPid;
        this.connectionId = connectionId;
        this.optionFlags1 = optionFlags1;
        this.optionFlags2 = optionFlags2;
        this.typeFlags = typeFlags;
        this.optionFlags3 = optionFlags3;
        this.tokens = tokens;
        this.clientId = clientId;
        int baseLength = 94;
        EnumSet<TokenType[]> lengthRelevant = EnumSet.of(TokenType.Hostname, new TokenType[]{TokenType.AppName, TokenType.Servername, TokenType.IntName, TokenType.Database, TokenType.Username});
        for (LoginRequestToken token : tokens) {
            if (!lengthRelevant.contains((Object)token.getTokenType())) continue;
            baseLength += token.getValue().length;
        }
        baseLength += this.getToken(TokenType.Password).getEncrypted().length;
        Conditionals passwordChange = Conditionals.DISABLED;
        if (tdsVersion.isGreateOrEqualsTo(TDSVersion.VER_YUKON)) {
            passwordChange = Conditionals.PASSWORD_CHANGE;
        }
        this.passwordChange = passwordChange;
        this.baseLength = baseLength + 4;
        this.estimatedPacketLength = this.baseLength + 8 + 2 + passwordChange.length() + 1;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getName() {
        return "LOGIN7";
    }

    @Override
    public TdsFragment encode(ByteBufAllocator allocator, int packetSize) {
        ByteBuf buffer = allocator.buffer(this.estimatedPacketLength);
        this.encode(buffer);
        return TdsPackets.create(header, buffer);
    }

    void encode(ByteBuf buffer) {
        int len;
        int aeoffset = len = this.baseLength;
        buffer.writeIntLE(this.baseLength + 6 + 1);
        buffer.writeIntLE(this.tdsVersion.getVersion());
        buffer.writeIntLE(this.packetSize);
        buffer.writeBytes(this.clientProgVer);
        buffer.writeIntLE(this.clientPid);
        buffer.writeInt(0);
        buffer.writeByte((int)this.optionFlags1.getValue());
        buffer.writeByte((int)this.optionFlags2.getValue());
        buffer.writeByte((int)this.typeFlags.getValue());
        buffer.writeByte((int)this.optionFlags3.getValue());
        buffer.writeIntLE(0);
        buffer.writeIntLE(0);
        int dataLen = 0;
        LoginRequestToken hostname = this.getToken(TokenType.Hostname);
        LoginRequestToken username = this.getToken(TokenType.Username);
        LoginRequestToken password = this.getToken(TokenType.Password);
        LoginRequestToken appName = this.getToken(TokenType.AppName);
        LoginRequestToken serverName = this.getToken(TokenType.Servername);
        LoginRequestToken intName = this.getToken(TokenType.IntName);
        LoginRequestToken database = this.getToken(TokenType.Database);
        dataLen = this.writeToken(dataLen, buffer, hostname, LoginRequestToken::getValue);
        dataLen = this.writeToken(dataLen, buffer, username, LoginRequestToken::getValue);
        dataLen = this.writeToken(dataLen, buffer, password, LoginRequestToken::getEncrypted);
        dataLen = this.writeToken(dataLen, buffer, appName, LoginRequestToken::getValue);
        dataLen = this.writeToken(dataLen, buffer, serverName, LoginRequestToken::getValue);
        buffer.writeShortLE(94 + dataLen);
        buffer.writeShortLE(4);
        dataLen += 4;
        dataLen = this.writeToken(dataLen, buffer, intName, LoginRequestToken::getValue);
        buffer.writeShort(0);
        buffer.writeShort(0);
        dataLen = this.writeToken(dataLen, buffer, database, LoginRequestToken::getValue);
        buffer.writeBytes(this.clientId);
        buffer.writeShort(0);
        buffer.writeShort(0);
        buffer.writeShort(0);
        buffer.writeShort(0);
        this.passwordChange.encode(buffer);
        buffer.writeBytes(hostname.getValue());
        buffer.writeBytes(username.getValue());
        buffer.writeBytes(password.getEncrypted());
        buffer.writeBytes(appName.getValue());
        buffer.writeBytes(serverName.getValue());
        buffer.writeIntLE(aeoffset);
        buffer.writeBytes(intName.getValue());
        buffer.writeBytes(database.getValue());
        buffer.writeByte(4);
        buffer.writeIntLE(1);
        buffer.writeByte(1);
        buffer.writeByte(-1);
    }

    private int writeToken(int dataLength, ByteBuf buffer, LoginRequestToken token, Function<LoginRequestToken, byte[]> valueFunction) {
        buffer.writeShortLE(94 + dataLength);
        buffer.writeShortLE(token.getLength());
        return dataLength + valueFunction.apply(token).length;
    }

    private LoginRequestToken getToken(TokenType tokenType) {
        for (LoginRequestToken token : this.tokens) {
            if (token.getTokenType() != tokenType) continue;
            return token;
        }
        return new LoginRequestToken(TokenType.Unknown, "");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [header=").append(header);
        sb.append(", tdsVersion=").append((Object)this.tdsVersion);
        sb.append(", packetSize=").append(this.packetSize);
        sb.append(", clientPid=").append(this.clientPid);
        sb.append(", connectionId=").append(this.connectionId);
        sb.append(", tokens=").append(this.tokens);
        sb.append(']');
        return sb.toString();
    }

    public static final class OptionFlags1 {
        public static final byte LOGIN_OPTION1_ORDER_X86 = 0;
        public static final byte LOGIN_OPTION1_ORDER_68000 = 1;
        public static final byte LOGIN_OPTION1_CHARSET_ASCII = 0;
        public static final byte LOGIN_OPTION1_CHARSET_EBCDIC = 2;
        public static final byte LOGIN_OPTION1_FLOAT_IEEE_754 = 0;
        public static final byte LOGIN_OPTION1_FLOAT_VAX = 4;
        public static final byte LOGIN_OPTION1_FLOAT_ND5000 = 8;
        public static final byte LOGIN_OPTION1_DUMPLOAD_ON = 0;
        public static final byte LOGIN_OPTION1_DUMPLOAD_OFF = 16;
        public static final byte LOGIN_OPTION1_USE_DB_ON = 0;
        public static final byte LOGIN_OPTION1_USE_DB_OFF = 32;
        public static final byte LOGIN_OPTION1_INIT_DB_WARN = 0;
        public static final byte LOGIN_OPTION1_INIT_DB_FATAL = 64;
        public static final byte LOGIN_OPTION1_SET_LANG_OFF = 0;
        public static final byte LOGIN_OPTION1_SET_LANG_ON = -128;
        private final int optionByte;

        private OptionFlags1(int optionByte) {
            this.optionByte = optionByte;
        }

        public static OptionFlags1 empty() {
            return new OptionFlags1(0);
        }

        public OptionFlags1 byteOrderX86() {
            return new OptionFlags1(this.optionByte | 0);
        }

        public OptionFlags1 byteOrder6800() {
            return new OptionFlags1(this.optionByte | 1);
        }

        public OptionFlags1 charSetAscii() {
            return new OptionFlags1(this.optionByte | 0);
        }

        public OptionFlags1 charSetEbcdic() {
            return new OptionFlags1(this.optionByte | 2);
        }

        public OptionFlags1 floatIeee754() {
            return new OptionFlags1(this.optionByte | 0);
        }

        public OptionFlags1 floatVax() {
            return new OptionFlags1(this.optionByte | 4);
        }

        public OptionFlags1 floatNd500() {
            return new OptionFlags1(this.optionByte | 8);
        }

        public OptionFlags1 dumpLoadOn() {
            return new OptionFlags1(this.optionByte | 0);
        }

        public OptionFlags1 dumpLoadOff() {
            return new OptionFlags1(this.optionByte | 0x10);
        }

        public OptionFlags1 useDbOff() {
            return new OptionFlags1(this.optionByte | 0x20);
        }

        public OptionFlags1 useDbOn() {
            return new OptionFlags1(this.optionByte | 0);
        }

        public OptionFlags1 initDatabaseFailWarn() {
            return new OptionFlags1(this.optionByte | 0);
        }

        public OptionFlags1 initDatabaseFailFatal() {
            return new OptionFlags1(this.optionByte | 0x40);
        }

        public OptionFlags1 disableLang() {
            return new OptionFlags1(this.optionByte | 0);
        }

        public OptionFlags1 enableLang() {
            return new OptionFlags1(this.optionByte | 0xFFFFFF80);
        }

        public byte getValue() {
            return (byte)this.optionByte;
        }
    }

    public static final class OptionFlags2 {
        public static final byte LOGIN_OPTION2_INIT_LANG_WARN = 0;
        public static final byte LOGIN_OPTION2_INIT_LANG_FATAL = 1;
        public static final byte LOGIN_OPTION2_ODBC_OFF = 0;
        public static final byte LOGIN_OPTION2_ODBC_ON = 2;
        public static final byte LOGIN_OPTION2_TRAN_BOUNDARY_OFF = 0;
        public static final byte LOGIN_OPTION2_TRAN_BOUNDARY_ON = 4;
        public static final byte LOGIN_OPTION2_CACHE_CONNECTION_OFF = 0;
        public static final byte LOGIN_OPTION2_CACHE_CONNECTION_ON = 8;
        public static final byte LOGIN_OPTION2_USER_NORMAL = 0;
        public static final byte LOGIN_OPTION2_USER_SERVER = 16;
        public static final byte LOGIN_OPTION2_USER_REMUSER = 32;
        public static final byte LOGIN_OPTION2_USER_SQLREPL = 48;
        public static final byte LOGIN_OPTION2_INTEGRATED_SECURITY_OFF = 0;
        public static final byte LOGIN_OPTION2_INTEGRATED_SECURITY_ON = -128;
        private final int optionByte;

        private OptionFlags2(int optionByte) {
            this.optionByte = optionByte;
        }

        public static OptionFlags2 empty() {
            return new OptionFlags2(0);
        }

        public OptionFlags2 setInitLangFailWarn() {
            return new OptionFlags2(this.optionByte | 0);
        }

        public OptionFlags2 setInitLangFailFatal() {
            return new OptionFlags2(this.optionByte | 1);
        }

        public OptionFlags2 disableOdbc() {
            return new OptionFlags2(this.optionByte | 0);
        }

        public OptionFlags2 enableOdbc() {
            return new OptionFlags2(this.optionByte | 2);
        }

        public OptionFlags2 normalUserType() {
            return new OptionFlags2(this.optionByte | 0);
        }

        public OptionFlags2 serverUserType() {
            return new OptionFlags2(this.optionByte | 0x10);
        }

        public OptionFlags2 remoteUserType() {
            return new OptionFlags2(this.optionByte | 0x20);
        }

        public OptionFlags2 sqlreplUserType() {
            return new OptionFlags2(this.optionByte | 0x30);
        }

        public OptionFlags2 disableIntegratedSecurity() {
            return new OptionFlags2(this.optionByte | 0);
        }

        public OptionFlags2 enableIntegratedSecurity() {
            return new OptionFlags2(this.optionByte | 0xFFFFFF80);
        }

        public byte getValue() {
            return (byte)this.optionByte;
        }
    }

    public static final class TypeFlags {
        static final byte LOGIN_SQLTYPE_DEFAULT = 0;
        static final byte LOGIN_SQLTYPE_TSQL = 1;
        static final byte LOGIN_OLEDB_OFF = 0;
        static final byte LOGIN_OLEDB_ON = 16;
        static final byte LOGIN_READ_ONLY_INTENT = 32;
        static final byte LOGIN_READ_WRITE_INTENT = 0;
        private final int optionByte;

        private TypeFlags(int optionByte) {
            this.optionByte = optionByte;
        }

        public static TypeFlags empty() {
            return new TypeFlags(0);
        }

        public TypeFlags defaultSqlType() {
            return new TypeFlags(this.optionByte | 0);
        }

        public TypeFlags tsqlType() {
            return new TypeFlags(this.optionByte | 1);
        }

        public TypeFlags disableOledb() {
            return new TypeFlags(this.optionByte | 0);
        }

        public TypeFlags enableOledb() {
            return new TypeFlags(this.optionByte | 0x10);
        }

        public byte getValue() {
            return (byte)this.optionByte;
        }
    }

    public static final class OptionFlags3 {
        static final byte LOGIN_OPTION3_DEFAULT = 0;
        static final byte LOGIN_OPTION3_CHANGE_PASSWORD = 1;
        static final byte LOGIN_OPTION3_SEND_YUKON_BINARY_XML = 2;
        static final byte LOGIN_OPTION3_USER_INSTANCE = 4;
        static final byte LOGIN_OPTION3_UNKNOWN_COLLATION_HANDLING = 8;
        static final byte LOGIN_OPTION3_FEATURE_EXTENSION = 16;
        private final int optionByte;

        private OptionFlags3(int optionByte) {
            this.optionByte = optionByte;
        }

        public static OptionFlags3 empty() {
            return new OptionFlags3(0);
        }

        public OptionFlags3 changePassword() {
            return new OptionFlags3(this.optionByte | 1);
        }

        public OptionFlags3 enableUserInstance() {
            return new OptionFlags3(this.optionByte | 4);
        }

        public OptionFlags3 enableUnknownCollationHandling() {
            return new OptionFlags3(this.optionByte | 8);
        }

        public OptionFlags3 enableExtensions() {
            return new OptionFlags3(this.optionByte | 0x10);
        }

        public byte getValue() {
            return (byte)this.optionByte;
        }
    }

    static enum TokenType {
        Hostname,
        Username,
        Password,
        AppName,
        Servername,
        IntName,
        Language,
        Database,
        Unknown;

    }

    public static final class LoginRequestToken {
        private final TokenType tokenType;
        private final int length;
        private final byte[] value;
        private final byte[] encrypted;

        LoginRequestToken(TokenType tokenType, @Nullable CharSequence value) {
            this.tokenType = tokenType;
            this.length = value != null ? value.length() : 0;
            this.value = LoginRequestToken.toUCS16(value);
            this.encrypted = this.encryptPassword(value);
        }

        public TokenType getTokenType() {
            return this.tokenType;
        }

        public byte[] getValue() {
            return this.value;
        }

        public byte[] getEncrypted() {
            return this.encrypted;
        }

        public int getLength() {
            return this.length;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getSimpleName());
            sb.append(" [tokenType=").append((Object)this.tokenType);
            sb.append(']');
            return sb.toString();
        }

        private static byte[] toUCS16(@Nullable CharSequence s) {
            if (s == null) {
                return new byte[0];
            }
            int l = s.length();
            byte[] data = new byte[l * 2];
            int offset = 0;
            for (int i = 0; i < l; ++i) {
                char c = s.charAt(i);
                byte b1 = (byte)(c & 0xFF);
                data[offset++] = b1;
                data[offset++] = (byte)(c >> 8 & 0xFF);
            }
            return data;
        }

        private byte[] encryptPassword(@Nullable CharSequence pwd) {
            if (pwd == null) {
                pwd = "";
            }
            int len = pwd.length();
            byte[] data = new byte[len * 2];
            for (int i1 = 0; i1 < len; ++i1) {
                byte b2;
                byte b1;
                int j1 = pwd.charAt(i1) ^ 0x5A5A;
                j1 = (j1 & 0xF) << 4 | (j1 & 0xF0) >> 4 | (j1 & 0xF00) << 4 | (j1 & 0xF000) >> 4;
                data[i1 * 2 + 1] = b1 = (byte)((j1 & 0xFF00) >> 8);
                data[i1 * 2 + 0] = b2 = (byte)(j1 & 0xFF);
            }
            return data;
        }
    }

    static enum Conditionals implements ConditionalProtocolSegment
    {
        DISABLED,
        PASSWORD_CHANGE{

            @Override
            public int length() {
                return 8;
            }

            @Override
            public void encode(ByteBuf buffer) {
                buffer.writeShort(0);
                buffer.writeShort(0);
                buffer.writeInt(0);
            }
        };


        @Override
        public int length() {
            return 0;
        }

        @Override
        public void encode(ByteBuf buffer) {
        }
    }

    static interface ConditionalProtocolSegment {
        public int length();

        public void encode(ByteBuf var1);
    }

    public static class Builder {
        private TDSVersion tdsVersion;
        private int packetSize = 8000;
        private Version clientLibraryVersion = DriverVersion.getVersion();
        private int clientPid;
        private byte[] clientId = new byte[6];
        private int connectionId;
        private OptionFlags1 optionFlags1 = OptionFlags1.empty().byteOrderX86().charSetAscii().floatIeee754().dumpLoadOn().useDbOff().initDatabaseFailFatal().enableLang();
        private OptionFlags2 optionFlags2 = OptionFlags2.empty().setInitLangFailFatal().enableOdbc().disableIntegratedSecurity();
        private TypeFlags typeFlags = TypeFlags.empty().defaultSqlType();
        private OptionFlags3 optionFlags3 = OptionFlags3.empty().enableUnknownCollationHandling().enableExtensions();
        @Nullable
        private CharSequence username;
        @Nullable
        private CharSequence password;
        @Nullable
        private CharSequence applicationName;
        @Nullable
        private CharSequence hostname;
        private CharSequence clientLibraryName;
        @Nullable
        private CharSequence databaseName;
        @Nullable
        private CharSequence serverName;

        private Builder() {
            String clientLibraryName = "R2DBC Driver for Microsoft SQL Server v";
            if (this.clientLibraryVersion != null) {
                clientLibraryName = clientLibraryName + this.clientLibraryVersion.toString();
            }
            this.clientLibraryName = clientLibraryName;
            this.applicationName = clientLibraryName;
        }

        public Builder tdsVersion(TDSVersion tdsVersion) {
            this.tdsVersion = Assert.requireNonNull(tdsVersion, "TDS version must not be null");
            return this;
        }

        public Builder packetSize(int packetSize) {
            this.packetSize = packetSize;
            return this;
        }

        public Builder optionFlags1(OptionFlags1 optionFlags1) {
            this.optionFlags1 = Assert.requireNonNull(optionFlags1, "Option flags 1 must not be null");
            return this;
        }

        public Builder optionFlags2(OptionFlags2 optionFlags2) {
            this.optionFlags2 = Assert.requireNonNull(optionFlags2, "Option flags 2 must not be null");
            return this;
        }

        public Builder optionFlags3(OptionFlags3 optionFlags3) {
            this.optionFlags3 = Assert.requireNonNull(optionFlags3, "Option flags 3 must not be null");
            return this;
        }

        public Builder typeFlags(TypeFlags typeFlags) {
            this.typeFlags = Assert.requireNonNull(typeFlags, "Type flags must not be null");
            return this;
        }

        public Builder username(CharSequence username) {
            this.username = Assert.requireNonNull(username, "Username must not be null");
            return this;
        }

        public Builder password(CharSequence password) {
            Assert.requireNonNull(password, "Password must not be null");
            Assert.isTrue(password.length() < 128, "Password name must be shorter than 128 chars");
            this.password = password;
            return this;
        }

        public Builder applicationName(CharSequence applicationName) {
            Assert.requireNonNull(applicationName, "App name must not be null");
            Assert.isTrue(applicationName.length() < 128, "Application name must be shorter than 128 chars");
            this.applicationName = applicationName;
            return this;
        }

        public Builder clientLibraryName(CharSequence clientLibraryName) {
            Assert.requireNonNull(clientLibraryName, "Client library name must not be null");
            Assert.isTrue(clientLibraryName.length() < 128, "Client library name must be shorter than 128 chars");
            this.clientLibraryName = clientLibraryName;
            return this;
        }

        public Builder clientLibraryVersion(Version clientLibraryVersion) {
            this.clientLibraryVersion = Assert.requireNonNull(clientLibraryVersion, "Client library version must not be null");
            return this;
        }

        public Builder hostName(CharSequence hostname) {
            Assert.requireNonNull(hostname, "Hostname must not be null");
            Assert.isTrue(hostname.length() < 128, "Hostname name must be shorter than 128 chars");
            this.hostname = hostname;
            return this;
        }

        public Builder database(CharSequence databaseName) {
            Assert.requireNonNull(databaseName, "Database name must not be null");
            Assert.isTrue(databaseName.length() < 128, "Database name must be shorter than 128 chars");
            this.databaseName = databaseName;
            return this;
        }

        public Builder serverName(CharSequence serverName) {
            Assert.requireNonNull(serverName, "Server name must not be null");
            Assert.isTrue(serverName.length() < 128, "Server name must be shorter than 128 chars");
            this.serverName = serverName;
            return this;
        }

        public Builder clientId(byte[] clientId) {
            Assert.requireNonNull(clientId, "Client name must not be null");
            Assert.isTrue(clientId.length == 6, "Client Id must be exactly 6 chars");
            this.clientId = Arrays.copyOf(clientId, 6);
            return this;
        }

        public Builder clientProcessId(int processId) {
            this.clientPid = processId;
            return this;
        }

        public Login7 build() {
            Assert.state(this.username != null, "Username must not be null");
            Assert.state(this.password != null, "Password must not be null");
            Assert.state(this.databaseName != null, "Database must not be null");
            ArrayList<LoginRequestToken> requestTokens = new ArrayList<LoginRequestToken>();
            requestTokens.add(new LoginRequestToken(TokenType.Hostname, this.hostname));
            requestTokens.add(new LoginRequestToken(TokenType.Username, this.username));
            requestTokens.add(new LoginRequestToken(TokenType.Password, this.password));
            requestTokens.add(new LoginRequestToken(TokenType.AppName, this.applicationName));
            requestTokens.add(new LoginRequestToken(TokenType.Servername, this.serverName));
            requestTokens.add(new LoginRequestToken(TokenType.IntName, this.clientLibraryName));
            requestTokens.add(new LoginRequestToken(TokenType.Database, this.databaseName));
            byte[] interfaceLibVersion = new byte[4];
            if (this.clientLibraryVersion != null) {
                interfaceLibVersion = new byte[]{0, (byte)this.clientLibraryVersion.getBugfix(), (byte)this.clientLibraryVersion.getMinor(), (byte)this.clientLibraryVersion.getMajor()};
            }
            return new Login7(this.tdsVersion, this.packetSize, interfaceLibVersion, this.clientPid, this.connectionId, this.optionFlags1, this.optionFlags2, this.typeFlags, this.optionFlags3, requestTokens, this.clientId);
        }
    }
}

