/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.token.AbstractDataToken;
import io.r2dbc.mssql.util.Assert;
import java.util.ArrayList;
import java.util.List;

class OrderToken
extends AbstractDataToken {
    public static final byte TYPE = -87;
    private final List<Integer> orderByColumns;

    private OrderToken(List<Integer> orderByColumns) {
        super((byte)-87);
        this.orderByColumns = orderByColumns;
    }

    public static OrderToken decode(ByteBuf buffer) {
        Assert.requireNonNull(buffer, "Data buffer must not be null");
        int length = Decode.uShort(buffer);
        int readerIndex = buffer.readerIndex();
        ArrayList<Integer> columns = new ArrayList<Integer>();
        while (buffer.readerIndex() - readerIndex < length) {
            int column = Decode.uShort(buffer);
            columns.add(column);
        }
        return new OrderToken(columns);
    }

    public static boolean canDecode(ByteBuf buffer) {
        Assert.requireNonNull(buffer, "Data buffer must not be null");
        Integer length = Decode.peekUShort(buffer);
        return length != null && buffer.readableBytes() >= length + 2;
    }

    public List<Integer> getOrderByColumns() {
        return this.orderByColumns;
    }

    @Override
    public String getName() {
        return "ORDER";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [orderByColumns=").append(this.orderByColumns);
        sb.append(']');
        return sb.toString();
    }
}

