/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.mssql.message.token;

import io.netty.buffer.ByteBuf;
import io.r2dbc.mssql.message.tds.Decode;
import io.r2dbc.mssql.message.token.AbstractDataToken;
import io.r2dbc.mssql.message.token.Identifier;
import io.r2dbc.mssql.util.Assert;
import java.util.ArrayList;
import java.util.List;

public class TabnameToken
extends AbstractDataToken {
    public static final byte TYPE = -92;
    private final List<Identifier> tableNames;

    private TabnameToken(List<Identifier> tableNames) {
        super((byte)-92);
        this.tableNames = tableNames;
    }

    public static TabnameToken decode(ByteBuf buffer) {
        Assert.requireNonNull(buffer, "Data buffer must not be null");
        int length = Decode.uShort(buffer);
        int readerIndex = buffer.readerIndex();
        ArrayList<Identifier> tableNames = new ArrayList<Identifier>();
        while (buffer.readerIndex() - readerIndex < length) {
            tableNames.add(Identifier.decode(buffer));
        }
        return new TabnameToken(tableNames);
    }

    public static boolean canDecode(ByteBuf buffer) {
        Assert.requireNonNull(buffer, "Data buffer must not be null");
        if (buffer.readableBytes() >= 5) {
            Integer requiredLength = Decode.peekUShort(buffer);
            return requiredLength != null && buffer.readableBytes() >= requiredLength + 2;
        }
        return false;
    }

    public List<Identifier> getTableNames() {
        return this.tableNames;
    }

    @Override
    public String getName() {
        return "TABNAME";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(" [names=").append(this.tableNames);
        sb.append(']');
        return sb.toString();
    }
}

