/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.pool;

import io.r2dbc.pool.Assert;
import io.r2dbc.pool.ConnectionPool;
import io.r2dbc.pool.ConnectionPoolConfiguration;
import io.r2dbc.spi.ConnectionFactories;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.ConnectionFactoryProvider;
import io.r2dbc.spi.Option;
import io.r2dbc.spi.ValidationDepth;
import java.util.Locale;

public class PoolingConnectionFactoryProvider
implements ConnectionFactoryProvider {
    public static final String POOLING_DRIVER = "pool";
    public static final Option<Integer> ACQUIRE_RETRY = Option.valueOf((String)"acquireRetry");
    public static final Option<Integer> INITIAL_SIZE = Option.valueOf((String)"initialSize");
    public static final Option<Integer> MAX_SIZE = Option.valueOf((String)"maxSize");
    public static final Option<String> VALIDATION_QUERY = Option.valueOf((String)"validationQuery");
    public static final Option<ValidationDepth> VALIDATION_DEPTH = Option.valueOf((String)"validationDepth");
    private static final String COLON = ":";

    public ConnectionPool create(ConnectionFactoryOptions connectionFactoryOptions) {
        return new ConnectionPool(PoolingConnectionFactoryProvider.buildConfiguration(connectionFactoryOptions));
    }

    static ConnectionPoolConfiguration buildConfiguration(ConnectionFactoryOptions connectionFactoryOptions) {
        String protocol = (String)connectionFactoryOptions.getRequiredValue(ConnectionFactoryOptions.PROTOCOL);
        if (protocol.trim().length() == 0) {
            throw new IllegalArgumentException(String.format("Protocol %s is not valid.", protocol));
        }
        String[] protocols = protocol.split(COLON, 2);
        String driverDelegate = protocols[0];
        String protocolDelegate = protocols.length == 2 ? protocols[1] : "";
        ConnectionFactoryOptions newOptions = ConnectionFactoryOptions.builder().from(connectionFactoryOptions).option(ConnectionFactoryOptions.DRIVER, (Object)driverDelegate).option(ConnectionFactoryOptions.PROTOCOL, (Object)protocolDelegate).build();
        ConnectionFactory connectionFactory = ConnectionFactories.find((ConnectionFactoryOptions)newOptions);
        if (connectionFactory == null) {
            throw new IllegalArgumentException(String.format("Could not find delegating driver %s", driverDelegate));
        }
        ConnectionPoolConfiguration.Builder builder = ConnectionPoolConfiguration.builder(connectionFactory);
        if (connectionFactoryOptions.hasOption(INITIAL_SIZE)) {
            builder.initialSize(PoolingConnectionFactoryProvider.parseIntOption(connectionFactoryOptions, INITIAL_SIZE));
        }
        if (connectionFactoryOptions.hasOption(MAX_SIZE)) {
            builder.maxSize(PoolingConnectionFactoryProvider.parseIntOption(connectionFactoryOptions, MAX_SIZE));
        }
        if (connectionFactoryOptions.hasOption(ACQUIRE_RETRY)) {
            builder.acquireRetry(PoolingConnectionFactoryProvider.parseIntOption(connectionFactoryOptions, ACQUIRE_RETRY));
        }
        if (connectionFactoryOptions.hasOption(VALIDATION_QUERY)) {
            String validationQuery = (String)connectionFactoryOptions.getRequiredValue(VALIDATION_QUERY);
            builder.validationQuery(validationQuery);
        }
        if (connectionFactoryOptions.hasOption(VALIDATION_DEPTH)) {
            Object validationDepth = connectionFactoryOptions.getRequiredValue(VALIDATION_DEPTH);
            if (validationDepth instanceof String) {
                validationDepth = ValidationDepth.valueOf((String)((String)validationDepth).toUpperCase(Locale.ENGLISH));
            }
            builder.validationDepth((ValidationDepth)validationDepth);
        }
        return builder.build();
    }

    private static int parseIntOption(ConnectionFactoryOptions options, Option<?> option) {
        Object value = options.getRequiredValue(option);
        if (value instanceof Number) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return Integer.parseInt(value.toString());
        }
        throw new IllegalArgumentException(String.format("Invalid %s option: %s", option.name(), value));
    }

    public boolean supports(ConnectionFactoryOptions connectionFactoryOptions) {
        Assert.requireNonNull(connectionFactoryOptions, "connectionFactoryOptions must not be null");
        String driver = (String)connectionFactoryOptions.getValue(ConnectionFactoryOptions.DRIVER);
        return driver != null && driver.equals(POOLING_DRIVER);
    }

    public String getDriver() {
        return POOLING_DRIVER;
    }
}

