/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.r2dbc.postgresql.ExceptionFactory;
import io.r2dbc.postgresql.StatementCache;
import io.r2dbc.postgresql.client.Binding;
import io.r2dbc.postgresql.client.Client;
import io.r2dbc.postgresql.client.ExtendedQueryMessageFlow;
import io.r2dbc.postgresql.util.Assert;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

final class IndefiniteStatementCache
implements StatementCache {
    private final Map<Tuple2<String, List<Integer>>, Mono<String>> cache = new HashMap<Tuple2<String, List<Integer>>, Mono<String>>();
    private final Client client;
    private final AtomicInteger counter = new AtomicInteger();

    IndefiniteStatementCache(Client client) {
        this.client = Assert.requireNonNull(client, "client must not be null");
    }

    @Override
    public Mono<String> getName(Binding binding, String sql) {
        Assert.requireNonNull(binding, "binding must not be null");
        Assert.requireNonNull(sql, "sql must not be null");
        return this.cache.computeIfAbsent((Tuple2<String, List<Integer>>)Tuples.of((Object)sql, binding.getParameterTypes()), tuple -> this.parse((String)tuple.getT1(), (List)tuple.getT2()));
    }

    public String toString() {
        return "IndefiniteStatementCache{cache=" + this.cache + ", client=" + this.client + ", counter=" + this.counter + '}';
    }

    private Mono<String> parse(String sql, List<Integer> types) {
        String name = String.format("S_%d", this.counter.getAndIncrement());
        ExceptionFactory factory = ExceptionFactory.withSql(name);
        return ExtendedQueryMessageFlow.parse(this.client, name, sql, types).handle(factory::handleErrorResponse).then(Mono.just((Object)name)).cache();
    }
}

