/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.r2dbc.postgresql.SimpleQueryPostgresqlStatement;
import io.r2dbc.postgresql.api.PostgresqlResult;
import io.r2dbc.postgresql.client.Client;
import io.r2dbc.postgresql.codec.Codecs;
import io.r2dbc.postgresql.util.Assert;
import java.util.ArrayList;
import java.util.List;
import reactor.core.publisher.Flux;

final class PostgresqlBatch
implements io.r2dbc.postgresql.api.PostgresqlBatch {
    private final Client client;
    private final Codecs codecs;
    private final List<String> statements = new ArrayList<String>();

    PostgresqlBatch(Client client, Codecs codecs) {
        this.client = Assert.requireNonNull(client, "client must not be null");
        this.codecs = Assert.requireNonNull(codecs, "codecs must not be null");
    }

    @Override
    public PostgresqlBatch add(String sql) {
        Assert.requireNonNull(sql, "sql must not be null");
        if (!SimpleQueryPostgresqlStatement.supports(sql)) {
            throw new IllegalArgumentException(String.format("Statement '%s' is not supported.  This is often due to the presence of parameters.", sql));
        }
        this.statements.add(sql);
        return this;
    }

    @Override
    public Flux<PostgresqlResult> execute() {
        return new SimpleQueryPostgresqlStatement(this.client, this.codecs, String.join((CharSequence)"; ", this.statements)).execute();
    }

    public String toString() {
        return "PostgresqlBatch{client=" + this.client + ", codecs=" + this.codecs + ", statements=" + this.statements + '}';
    }
}

