/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.r2dbc.postgresql.codec.Codecs;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.message.backend.RowDescription;
import io.r2dbc.postgresql.util.Assert;
import java.util.Objects;

final class PostgresqlColumnMetadata
implements io.r2dbc.postgresql.api.PostgresqlColumnMetadata {
    private final Codecs codecs;
    private final Format format;
    private final String name;
    private final int nativeType;
    private final short precision;

    PostgresqlColumnMetadata(Codecs codecs, String name, int nativeType, short precision) {
        this.codecs = codecs;
        this.format = Format.FORMAT_TEXT;
        this.name = name;
        this.nativeType = nativeType;
        this.precision = precision;
    }

    PostgresqlColumnMetadata(Codecs codecs, RowDescription.Field field) {
        this.codecs = Assert.requireNonNull(codecs, "codecs must not be null");
        Assert.requireNonNull(field, "field must not be null");
        this.format = field.getFormat();
        this.name = field.getName();
        this.nativeType = field.getDataType();
        this.precision = field.getDataTypeSize();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PostgresqlColumnMetadata)) {
            return false;
        }
        PostgresqlColumnMetadata that = (PostgresqlColumnMetadata)o;
        return this.name.equals(that.name) && this.nativeType == that.nativeType && this.precision == that.precision;
    }

    public Class<?> getJavaType() {
        return this.codecs.preferredType(this.nativeType, this.format);
    }

    public String getName() {
        return this.name;
    }

    public Integer getNativeTypeMetadata() {
        return this.nativeType;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.nativeType, this.precision);
    }

    public String toString() {
        return "PostgresqlColumnMetadata{, name='" + this.name + '\'' + ", nativeType=" + this.nativeType + ", precision=" + this.precision + '}';
    }

    static PostgresqlColumnMetadata toColumnMetadata(Codecs codecs, RowDescription.Field field) {
        Assert.requireNonNull(codecs, "codecs must not be null");
        Assert.requireNonNull(field, "field must not be null");
        return new PostgresqlColumnMetadata(codecs, field);
    }
}

