/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.netty.util.ReferenceCountUtil;
import io.r2dbc.postgresql.ExceptionFactory;
import io.r2dbc.postgresql.PostgresqlRow;
import io.r2dbc.postgresql.PostgresqlRowMetadata;
import io.r2dbc.postgresql.codec.Codecs;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.message.backend.CommandComplete;
import io.r2dbc.postgresql.message.backend.DataRow;
import io.r2dbc.postgresql.message.backend.EmptyQueryResponse;
import io.r2dbc.postgresql.message.backend.PortalSuspended;
import io.r2dbc.postgresql.message.backend.RowDescription;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.PredicateUtils;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class PostgresqlResult
implements io.r2dbc.postgresql.api.PostgresqlResult {
    private static final Predicate<BackendMessage> TAKE_UNTIL;
    private final Codecs codecs;
    private final Flux<BackendMessage> messages;
    private final ExceptionFactory factory;
    private volatile PostgresqlRowMetadata metadata;
    private volatile RowDescription rowDescription;

    PostgresqlResult(Codecs codecs, Flux<BackendMessage> messages, ExceptionFactory factory) {
        this.codecs = Assert.requireNonNull(codecs, "codecs must not be null");
        this.messages = Assert.requireNonNull(messages, "messages must not be null");
        this.factory = Assert.requireNonNull(factory, "factory must not be null");
    }

    @Override
    public Mono<Integer> getRowsUpdated() {
        return this.messages.handle(this.factory::handleErrorResponse).doOnNext(ReferenceCountUtil::release).ofType(CommandComplete.class).singleOrEmpty().handle((commandComplete, sink) -> {
            Integer rowCount = commandComplete.getRows();
            if (rowCount != null) {
                sink.next((Object)rowCount);
            } else {
                sink.complete();
            }
        });
    }

    @Override
    public <T> Flux<T> map(BiFunction<Row, RowMetadata, ? extends T> f) {
        Assert.requireNonNull(f, "f must not be null");
        return this.messages.takeUntil(TAKE_UNTIL).handle(this.factory::handleErrorResponse).handle((message, sink) -> {
            try {
                if (message instanceof RowDescription) {
                    this.rowDescription = (RowDescription)message;
                    this.metadata = PostgresqlRowMetadata.toRowMetadata(this.codecs, (RowDescription)message);
                    return;
                }
                if (message instanceof DataRow) {
                    PostgresqlRow row = PostgresqlRow.toRow(this.codecs, (DataRow)message, this.rowDescription);
                    sink.next(f.apply(row, this.metadata));
                }
            }
            finally {
                ReferenceCountUtil.release((Object)message);
            }
        });
    }

    public String toString() {
        return "PostgresqlResult{codecs=" + this.codecs + ", messages=" + this.messages + '}';
    }

    static PostgresqlResult toResult(Codecs codecs, Flux<BackendMessage> messages, ExceptionFactory factory) {
        Assert.requireNonNull(codecs, "codecs must not be null");
        Assert.requireNonNull(messages, "messages must not be null");
        Assert.requireNonNull(factory, "factory must not be null");
        return new PostgresqlResult(codecs, messages, factory);
    }

    static {
        Predicate[] predicateArray = new Predicate[3];
        predicateArray[0] = CommandComplete.class::isInstance;
        predicateArray[1] = EmptyQueryResponse.class::isInstance;
        predicateArray[2] = PortalSuspended.class::isInstance;
        TAKE_UNTIL = PredicateUtils.or(predicateArray);
    }
}

