/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.client;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class Binding {
    private static final Parameter UNSPECIFIED = new Parameter(Format.FORMAT_BINARY, -1, (Publisher<? extends ByteBuf>)Mono.never());
    private final int expectedSize;
    private final List<Parameter> parameters;

    public Binding(int expectedSize) {
        this.expectedSize = expectedSize;
        this.parameters = new ArrayList<Parameter>(Collections.nCopies(expectedSize, UNSPECIFIED));
    }

    public Binding add(Integer index, Parameter parameter) {
        Assert.requireNonNull(index, "index must not be null");
        Assert.requireNonNull(parameter, "parameter must not be null");
        if (index >= this.expectedSize) {
            throw new IndexOutOfBoundsException(String.format("Binding index %d when only %d parameters are expected", index, this.expectedSize));
        }
        this.parameters.set(index, parameter);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Binding that = (Binding)o;
        return Objects.equals(this.parameters, that.parameters);
    }

    public List<Format> getParameterFormats() {
        return this.getTransformedParameters(Parameter::getFormat);
    }

    public List<Integer> getParameterTypes() {
        return this.getTransformedParameters(Parameter::getType);
    }

    public List<Publisher<? extends ByteBuf>> getParameterValues() {
        return this.getTransformedParameters(Parameter::getValue);
    }

    public int hashCode() {
        return Objects.hash(this.parameters);
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public String toString() {
        return "Binding{parameters=" + this.parameters + '}';
    }

    public void validate() {
        for (Parameter parameter : this.parameters) {
            if (UNSPECIFIED != parameter) continue;
            throw new IllegalStateException("Bound parameter count does not match parameters in SQL statement");
        }
    }

    private <T> List<T> getTransformedParameters(Function<Parameter, T> transformer) {
        ArrayList<T> transformed = new ArrayList<T>(this.parameters.size());
        for (int i = 0; i < this.parameters.size(); ++i) {
            Parameter parameter = this.parameters.get(i);
            if (parameter == UNSPECIFIED) {
                throw new IllegalStateException(String.format("No parameter specified for index %d", i));
            }
            transformed.add(transformer.apply(parameter));
        }
        return transformed;
    }
}

