/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.r2dbc.postgresql.client.Binding;
import io.r2dbc.postgresql.client.Client;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.client.PortalNameSupplier;
import io.r2dbc.postgresql.client.QueryLogger;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.message.backend.NoData;
import io.r2dbc.postgresql.message.backend.RowDescription;
import io.r2dbc.postgresql.message.frontend.Bind;
import io.r2dbc.postgresql.message.frontend.Close;
import io.r2dbc.postgresql.message.frontend.Describe;
import io.r2dbc.postgresql.message.frontend.Execute;
import io.r2dbc.postgresql.message.frontend.ExecutionType;
import io.r2dbc.postgresql.message.frontend.FrontendMessage;
import io.r2dbc.postgresql.message.frontend.Parse;
import io.r2dbc.postgresql.message.frontend.Sync;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.PredicateUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ExtendedQueryMessageFlow {
    public static final Pattern PARAMETER_SYMBOL = Pattern.compile("\\$([\\d]+)", 32);
    private static final Predicate<BackendMessage> TAKE_UNTIL;

    private ExtendedQueryMessageFlow() {
    }

    public static Flux<BackendMessage> execute(Publisher<Binding> bindings, Client client, PortalNameSupplier portalNameSupplier, String statementName, String query, boolean forceBinary) {
        Assert.requireNonNull(bindings, "bindings must not be null");
        Assert.requireNonNull(client, "client must not be null");
        Assert.requireNonNull(portalNameSupplier, "portalNameSupplier must not be null");
        Assert.requireNonNull(statementName, "statementName must not be null");
        return client.exchange((Publisher<FrontendMessage>)Flux.from(bindings).flatMap(binding -> ExtendedQueryMessageFlow.toBindFlow(binding, portalNameSupplier, statementName, query, forceBinary)).concatWith((Publisher)Mono.just((Object)Sync.INSTANCE)));
    }

    public static Flux<BackendMessage> parse(Client client, String name, String query, List<Integer> types) {
        Assert.requireNonNull(client, "client must not be null");
        Assert.requireNonNull(name, "name must not be null");
        Assert.requireNonNull(query, "query must not be null");
        Assert.requireNonNull(types, "types must not be null");
        return client.exchange((Publisher<FrontendMessage>)Flux.just((Object[])new FrontendMessage[]{new Parse(name, types, query), new Describe(name, ExecutionType.STATEMENT), Sync.INSTANCE})).takeUntil(TAKE_UNTIL);
    }

    private static Collection<Format> resultFormat(boolean forceBinary) {
        if (forceBinary) {
            return Format.binary();
        }
        return Collections.emptyList();
    }

    private static Flux<FrontendMessage> toBindFlow(Binding binding, PortalNameSupplier portalNameSupplier, String statementName, String query, boolean forceBinary) {
        String portal = portalNameSupplier.get();
        return Flux.fromIterable(binding.getParameterValues()).flatMap(f -> {
            if (f == Parameter.NULL_VALUE) {
                return Flux.just((Object)Bind.NULL_VALUE);
            }
            return Flux.from((Publisher)f).reduce((Object)Unpooled.compositeBuffer(), (c, b) -> c.addComponent(true, b));
        }).collectList().flatMapMany(values -> {
            Bind bind = new Bind(portal, binding.getParameterFormats(), (List<ByteBuf>)values, ExtendedQueryMessageFlow.resultFormat(forceBinary), statementName);
            return Flux.just((Object[])new FrontendMessage[]{bind, new Describe(portal, ExecutionType.PORTAL), new Execute(portal, 0), new Close(portal, ExecutionType.PORTAL)});
        }).doOnSubscribe(ignore -> QueryLogger.logQuery(query));
    }

    static {
        Predicate[] predicateArray = new Predicate[2];
        predicateArray[0] = RowDescription.class::isInstance;
        predicateArray[1] = NoData.class::isInstance;
        TAKE_UNTIL = PredicateUtils.or(predicateArray);
    }
}

