/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class AbstractBinaryCodec<T>
extends AbstractCodec<T> {
    private static final Pattern BLOB_PATTERN = Pattern.compile("\\\\x([\\p{XDigit}]+)");
    private final ByteBufAllocator byteBufAllocator;

    AbstractBinaryCodec(Class<T> type, ByteBufAllocator byteBufAllocator) {
        super(type);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    public Parameter encodeNull() {
        return AbstractBinaryCodec.createNull(PostgresqlObjectId.BYTEA, Format.FORMAT_TEXT);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(type, "type must not be null");
        Assert.requireNonNull(format, "format must not be null");
        return PostgresqlObjectId.BYTEA == type;
    }

    byte[] decode(Format format, ByteBuf byteBuf) {
        byte[] decoded;
        if (format == Format.FORMAT_TEXT) {
            Matcher matcher = BLOB_PATTERN.matcher(ByteBufUtils.decode(byteBuf));
            if (!matcher.find()) {
                throw new IllegalStateException("ByteBuf does not contain BYTEA hex format");
            }
            decoded = ByteBufUtil.decodeHexDump((CharSequence)matcher.group(1));
        } else {
            decoded = new byte[byteBuf.readableBytes()];
            byteBuf.readBytes(decoded);
        }
        return decoded;
    }

    ByteBuf toHexFormat(ByteBuf b) {
        int blobSize = b.readableBytes();
        ByteBuf buf = this.byteBufAllocator.buffer(2 + blobSize * 2);
        buf.writeByte(92).writeByte(120);
        int chunkSize = 1024;
        while (b.isReadable()) {
            chunkSize = Math.min(chunkSize, b.readableBytes());
            buf.writeCharSequence((CharSequence)ByteBufUtil.hexDump((ByteBuf)b, (int)b.readerIndex(), (int)chunkSize), StandardCharsets.US_ASCII);
            b.skipBytes(chunkSize);
        }
        return buf;
    }
}

