/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.EpochTime;
import io.r2dbc.postgresql.codec.PostgresqlDateTimeFormatter;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import reactor.util.annotation.Nullable;

abstract class AbstractTemporalCodec<T extends Temporal>
extends AbstractCodec<T> {
    private static final Set<PostgresqlObjectId> SUPPORTED_TYPES = EnumSet.of(PostgresqlObjectId.DATE, PostgresqlObjectId.TIMESTAMP, PostgresqlObjectId.TIMESTAMPTZ, PostgresqlObjectId.TIME);

    AbstractTemporalCodec(Class<T> type) {
        super(type);
    }

    @Override
    public boolean canDecode(int dataType, Format format, Class<?> type) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        if (type == Object.class && PostgresqlObjectId.valueOf(dataType) != this.getDefaultType()) {
            return false;
        }
        return super.canDecode(dataType, format, type);
    }

    @Override
    final boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return SUPPORTED_TYPES.contains((Object)type);
    }

    T decodeTemporal(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, Class<T> expectedType, Function<Temporal, T> converter) {
        Temporal number = this.decodeTemporal(buffer, dataType, format);
        return (T)((Temporal)AbstractTemporalCodec.potentiallyConvert(number, expectedType, converter));
    }

    private Temporal decodeTemporal(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        switch (dataType) {
            case TIMESTAMP: {
                if (Format.FORMAT_BINARY == format) {
                    return EpochTime.fromLong(buffer.readLong()).toLocalDateTime();
                }
                return PostgresqlDateTimeFormatter.INSTANCE.parse((CharSequence)ByteBufUtils.decode(buffer), LocalDateTime::from);
            }
            case DATE: {
                if (Format.FORMAT_BINARY == format) {
                    return LocalDate.ofEpochDay(EpochTime.fromInt(buffer.readInt()).getJavaDays());
                }
                return LocalDate.parse(ByteBufUtils.decode(buffer));
            }
            case TIME: {
                if (Format.FORMAT_BINARY == format) {
                    return LocalTime.ofNanoOfDay(buffer.readLong() * 1000L);
                }
                return LocalTime.parse(ByteBufUtils.decode(buffer));
            }
            case TIMESTAMPTZ: {
                if (Format.FORMAT_BINARY == format) {
                    return EpochTime.fromLong(buffer.readLong()).toInstant().atOffset(OffsetDateTime.now().getOffset());
                }
                return PostgresqlDateTimeFormatter.INSTANCE.parse((CharSequence)ByteBufUtils.decode(buffer), ZonedDateTime::from);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot decode value for type %s, format %s", new Object[]{dataType, format}));
    }

    @Nullable
    abstract PostgresqlObjectId getDefaultType();

    static <T> T potentiallyConvert(Temporal temporal, Class<T> expectedType, Function<Temporal, T> converter) {
        return expectedType.isInstance(temporal) ? expectedType.cast(temporal) : converter.apply(temporal);
    }
}

