/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractBinaryCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import java.nio.ByteBuffer;

final class BinaryByteBufferCodec
extends AbstractBinaryCodec<ByteBuffer> {
    BinaryByteBufferCodec(ByteBufAllocator byteBufAllocator) {
        super(ByteBuffer.class, byteBufAllocator);
    }

    @Override
    ByteBuffer doDecode(ByteBuf buffer, PostgresqlObjectId dataType, Format format, Class<? extends ByteBuffer> type) {
        return ByteBuffer.wrap(this.decode(format, buffer));
    }

    @Override
    Parameter doEncode(ByteBuffer value) {
        Assert.requireNonNull(value, "value must not be null");
        return BinaryByteBufferCodec.create(PostgresqlObjectId.BYTEA, Format.FORMAT_TEXT, () -> this.toHexFormat(Unpooled.wrappedBuffer((ByteBuffer)value)));
    }
}

