/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.frontend;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.message.frontend.FrontendMessage;
import io.r2dbc.postgresql.message.frontend.FrontendMessageUtils;
import io.r2dbc.postgresql.util.Assert;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class Bind
implements FrontendMessage {
    public static final ByteBuf NULL_VALUE = Unpooled.EMPTY_BUFFER;
    public static final String UNNAMED_PORTAL = "";
    public static final String UNNAMED_STATEMENT = "";
    private static final int NULL = -1;
    private final String name;
    private final Collection<Format> parameterFormats;
    private final Collection<ByteBuf> parameters;
    private final Collection<Format> resultFormats;
    private final String source;

    public Bind(String name, List<Format> parameterFormats, List<ByteBuf> parameters, Collection<Format> resultFormats, String source) {
        this.name = Assert.requireNonNull(name, "name must not be null");
        this.parameterFormats = Assert.requireNonNull(parameterFormats, "parameterFormats must not be null");
        this.parameters = Assert.requireNonNull(parameters, "parameters must not be null");
        this.resultFormats = Assert.requireNonNull(resultFormats, "resultFormats must not be null");
        this.source = Assert.requireNonNull(source, "source must not be null");
    }

    @Override
    public Publisher<ByteBuf> encode(ByteBufAllocator byteBufAllocator) {
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        return Mono.fromSupplier(() -> {
            ByteBuf out = byteBufAllocator.ioBuffer();
            FrontendMessageUtils.writeByte(out, 66);
            FrontendMessageUtils.writeLengthPlaceholder(out);
            FrontendMessageUtils.writeCStringUTF8(out, this.name);
            FrontendMessageUtils.writeCStringUTF8(out, this.source);
            FrontendMessageUtils.writeShort(out, this.parameterFormats.size());
            this.parameterFormats.forEach(format -> FrontendMessageUtils.writeShort(out, (int)format.getDiscriminator()));
            FrontendMessageUtils.writeShort(out, this.parameters.size());
            this.parameters.forEach(parameters -> {
                if (parameters == NULL_VALUE) {
                    FrontendMessageUtils.writeInt(out, -1);
                } else {
                    FrontendMessageUtils.writeInt(out, parameters.readableBytes());
                    FrontendMessageUtils.writeBytes(out, parameters);
                    parameters.release();
                }
            });
            FrontendMessageUtils.writeShort(out, this.resultFormats.size());
            this.resultFormats.forEach(format -> FrontendMessageUtils.writeShort(out, (int)format.getDiscriminator()));
            return FrontendMessageUtils.writeSize(out);
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bind that = (Bind)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.parameterFormats, that.parameterFormats) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.resultFormats, that.resultFormats) && Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parameterFormats, this.parameters, this.resultFormats, this.source);
    }

    public String toString() {
        return "Bind{name='" + this.name + '\'' + ", parameterFormats=" + this.parameterFormats + ", parameters=" + this.parameters + ", resultFormats=" + this.resultFormats + ", source='" + this.source + '\'' + '}';
    }
}

