/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.frontend;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.message.frontend.ExecutionType;
import io.r2dbc.postgresql.message.frontend.FrontendMessage;
import io.r2dbc.postgresql.message.frontend.FrontendMessageUtils;
import io.r2dbc.postgresql.util.Assert;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class Describe
implements FrontendMessage {
    public static final String UNNAMED = "";
    private final String name;
    private final ExecutionType type;

    public Describe(String name, ExecutionType type) {
        this.name = Assert.requireNonNull(name, "name must not be null");
        this.type = Assert.requireNonNull(type, "type must not be null");
    }

    @Override
    public Publisher<ByteBuf> encode(ByteBufAllocator byteBufAllocator) {
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        return Mono.fromSupplier(() -> {
            ByteBuf out = byteBufAllocator.ioBuffer();
            FrontendMessageUtils.writeByte(out, 68);
            FrontendMessageUtils.writeLengthPlaceholder(out);
            FrontendMessageUtils.writeByte(out, (int)this.type.getDiscriminator());
            FrontendMessageUtils.writeCStringUTF8(out, this.name);
            return FrontendMessageUtils.writeSize(out);
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Describe that = (Describe)o;
        return Objects.equals(this.name, that.name) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type});
    }

    public String toString() {
        return "Describe{name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }
}

