/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.frontend;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.message.frontend.FrontendMessage;
import io.r2dbc.postgresql.message.frontend.FrontendMessageUtils;
import io.r2dbc.postgresql.util.Assert;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class GSSResponse
implements FrontendMessage {
    private final ByteBuffer data;

    public GSSResponse(ByteBuffer data) {
        Assert.requireNonNull(data, "data must not be null");
        this.data = (ByteBuffer)data.flip();
    }

    @Override
    public Publisher<ByteBuf> encode(ByteBufAllocator byteBufAllocator) {
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        return Mono.fromSupplier(() -> {
            ByteBuf out = byteBufAllocator.ioBuffer(5 + this.data.remaining());
            FrontendMessageUtils.writeByte(out, 112);
            FrontendMessageUtils.writeLengthPlaceholder(out);
            FrontendMessageUtils.writeBytes(out, this.data);
            return FrontendMessageUtils.writeSize(out);
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GSSResponse that = (GSSResponse)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public String toString() {
        return "GSSResponse{data=" + this.data + '}';
    }
}

