/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.frontend;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import io.r2dbc.postgresql.message.frontend.FrontendMessage;
import io.r2dbc.postgresql.message.frontend.FrontendMessageUtils;
import io.r2dbc.postgresql.util.Assert;
import java.nio.charset.Charset;
import java.time.ZoneId;
import java.util.Map;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public final class StartupMessage
implements FrontendMessage {
    private static final ByteBuf APPLICATION_NAME = Unpooled.copiedBuffer((CharSequence)"application_name", (Charset)CharsetUtil.UTF_8).asReadOnly();
    private static final ByteBuf CLIENT_ENCODING = Unpooled.copiedBuffer((CharSequence)"client_encoding", (Charset)CharsetUtil.UTF_8).asReadOnly();
    private static final ByteBuf DATABASE = Unpooled.copiedBuffer((CharSequence)"database", (Charset)CharsetUtil.UTF_8).asReadOnly();
    private static final ByteBuf DATE_STYLE = Unpooled.copiedBuffer((CharSequence)"DateStyle", (Charset)CharsetUtil.UTF_8).asReadOnly();
    private static final ByteBuf EXTRA_FLOAT_DIGITS = Unpooled.copiedBuffer((CharSequence)"extra_float_digits", (Charset)CharsetUtil.UTF_8).asReadOnly();
    private static final ByteBuf ISO = Unpooled.copiedBuffer((CharSequence)"ISO", (Charset)CharsetUtil.UTF_8).asReadOnly();
    private static final ByteBuf NUMERAL_2 = Unpooled.copiedBuffer((CharSequence)"2", (Charset)CharsetUtil.UTF_8).asReadOnly();
    private static final ByteBuf SYSTEM_TIME_ZONE = Unpooled.copiedBuffer((CharSequence)ZoneId.systemDefault().toString(), (Charset)CharsetUtil.UTF_8).asReadOnly();
    private static final ByteBuf TIMEZONE = Unpooled.copiedBuffer((CharSequence)"TimeZone", (Charset)CharsetUtil.UTF_8).asReadOnly();
    private static final ByteBuf USER = Unpooled.copiedBuffer((CharSequence)"user", (Charset)CharsetUtil.UTF_8).asReadOnly();
    private static final ByteBuf UTF8 = Unpooled.copiedBuffer((CharSequence)"utf8", (Charset)CharsetUtil.UTF_8).asReadOnly();
    private final String applicationName;
    private final String database;
    private final Map<String, String> options;
    private final String username;

    public StartupMessage(String applicationName, @Nullable String database, String username, @Nullable Map<String, String> options) {
        this.applicationName = Assert.requireNonNull(applicationName, "applicationName must not be null");
        this.database = database;
        this.username = Assert.requireNonNull(username, "username must not be null");
        this.options = options;
    }

    @Override
    public Publisher<ByteBuf> encode(ByteBufAllocator byteBufAllocator) {
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        return Mono.fromSupplier(() -> {
            ByteBuf out = byteBufAllocator.ioBuffer();
            FrontendMessageUtils.writeLengthPlaceholder(out);
            FrontendMessageUtils.writeShort(out, 3, 0);
            this.writeParameter(out, USER, this.username);
            if (this.database != null) {
                this.writeParameter(out, DATABASE, this.database);
            }
            this.writeParameter(out, APPLICATION_NAME, this.applicationName);
            this.writeParameter(out, CLIENT_ENCODING, UTF8);
            this.writeParameter(out, DATE_STYLE, ISO);
            this.writeParameter(out, EXTRA_FLOAT_DIGITS, NUMERAL_2);
            this.writeParameter(out, TIMEZONE, SYSTEM_TIME_ZONE);
            if (this.options != null) {
                for (Map.Entry<String, String> option : this.options.entrySet()) {
                    ByteBuf key = Unpooled.copiedBuffer((CharSequence)option.getKey(), (Charset)CharsetUtil.UTF_8);
                    this.writeParameter(out, key, option.getValue());
                    key.release();
                }
            }
            FrontendMessageUtils.writeByte(out, 0);
            return FrontendMessageUtils.writeSize(out, 0);
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartupMessage that = (StartupMessage)o;
        return Objects.equals(this.applicationName, that.applicationName) && Objects.equals(this.database, that.database) && Objects.equals(this.username, that.username) && Objects.equals(this.options, that.options);
    }

    public int hashCode() {
        return Objects.hash(this.applicationName, this.database, this.username, this.options);
    }

    public String toString() {
        return "StartupMessage{applicationName='" + this.applicationName + '\'' + ", database='" + this.database + '\'' + ", username='" + this.username + '\'' + ", options='" + this.options + '\'' + '}';
    }

    private void writeParameter(ByteBuf out, ByteBuf key, String value) {
        FrontendMessageUtils.writeCString(out, key);
        FrontendMessageUtils.writeCStringUTF8(out, value);
    }

    private void writeParameter(ByteBuf out, ByteBuf key, ByteBuf value) {
        FrontendMessageUtils.writeCString(out, key);
        FrontendMessageUtils.writeCString(out, value);
    }
}

