/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.netty.handler.ssl.SslContextBuilder;
import io.r2dbc.postgresql.PostgresqlConnectionConfiguration;
import io.r2dbc.postgresql.PostgresqlConnectionFactory;
import io.r2dbc.postgresql.client.SSLMode;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.ConnectionFactoryProvider;
import io.r2dbc.spi.Option;
import java.time.Duration;
import java.util.Map;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;

public final class PostgresqlConnectionFactoryProvider
implements ConnectionFactoryProvider {
    public static final Option<String> APPLICATION_NAME = Option.valueOf((String)"applicationName");
    public static final Option<Boolean> AUTODETECT_EXTENSIONS = Option.valueOf((String)"autodetectExtensions");
    public static final Option<Integer> FETCH_SIZE = Option.valueOf((String)"fetchSize");
    public static final Option<Boolean> FORCE_BINARY = Option.valueOf((String)"forceBinary");
    public static final String POSTGRESQL_DRIVER = "postgresql";
    public static final String LEGACY_POSTGRESQL_DRIVER = "postgres";
    public static final Option<String> SCHEMA = Option.valueOf((String)"schema");
    public static final Option<String> SOCKET = Option.valueOf((String)"socket");
    public static final Option<Function<SslContextBuilder, SslContextBuilder>> SSL_CONTEXT_BUILDER_CUSTOMIZER = Option.valueOf((String)"sslContextBuilderCustomizer");
    public static final Option<String> SSL_CERT = Option.valueOf((String)"sslCert");
    public static final Option<HostnameVerifier> SSL_HOSTNAME_VERIFIER = Option.valueOf((String)"sslHostnameVerifier");
    public static final Option<String> SSL_KEY = Option.valueOf((String)"sslKey");
    public static final Option<SSLMode> SSL_MODE = Option.valueOf((String)"sslMode");
    public static final Option<String> SSL_PASSWORD = Option.valueOf((String)"sslPassword");
    public static final Option<String> SSL_ROOT_CERT = Option.valueOf((String)"sslRootCert");
    public static final Option<Map<String, String>> OPTIONS = Option.valueOf((String)"options");

    public PostgresqlConnectionFactory create(ConnectionFactoryOptions connectionFactoryOptions) {
        return new PostgresqlConnectionFactory(PostgresqlConnectionFactoryProvider.createConfiguration(connectionFactoryOptions));
    }

    private static PostgresqlConnectionConfiguration createConfiguration(ConnectionFactoryOptions connectionFactoryOptions) {
        Map options;
        Object forceBinary;
        Object fetchSize;
        boolean tcp;
        Object autodetectExtensions;
        Assert.requireNonNull(connectionFactoryOptions, "connectionFactoryOptions must not be null");
        PostgresqlConnectionConfiguration.Builder builder = PostgresqlConnectionConfiguration.builder();
        String applicationName = (String)connectionFactoryOptions.getValue(APPLICATION_NAME);
        if (applicationName != null) {
            builder.applicationName(applicationName);
        }
        if ((autodetectExtensions = connectionFactoryOptions.getValue(AUTODETECT_EXTENSIONS)) != null) {
            builder.autodetectExtensions(PostgresqlConnectionFactoryProvider.convertToBoolean(autodetectExtensions));
        }
        builder.connectTimeout((Duration)connectionFactoryOptions.getValue(ConnectionFactoryOptions.CONNECT_TIMEOUT));
        builder.database((String)connectionFactoryOptions.getValue(ConnectionFactoryOptions.DATABASE));
        if (connectionFactoryOptions.hasOption(SOCKET)) {
            tcp = false;
            builder.socket((String)connectionFactoryOptions.getRequiredValue(SOCKET));
        } else {
            tcp = true;
            builder.host((String)connectionFactoryOptions.getRequiredValue(ConnectionFactoryOptions.HOST));
        }
        builder.password((CharSequence)connectionFactoryOptions.getValue(ConnectionFactoryOptions.PASSWORD));
        builder.schema((String)connectionFactoryOptions.getValue(SCHEMA));
        builder.username((String)connectionFactoryOptions.getRequiredValue(ConnectionFactoryOptions.USER));
        Integer port = (Integer)connectionFactoryOptions.getValue(ConnectionFactoryOptions.PORT);
        if (port != null) {
            builder.port(port);
        }
        if ((fetchSize = connectionFactoryOptions.getValue(FETCH_SIZE)) != null) {
            builder.fetchSize(PostgresqlConnectionFactoryProvider.convertToInt(fetchSize));
        }
        if ((forceBinary = connectionFactoryOptions.getValue(FORCE_BINARY)) != null) {
            builder.forceBinary(PostgresqlConnectionFactoryProvider.convertToBoolean(forceBinary));
        }
        if ((options = (Map)connectionFactoryOptions.getValue(OPTIONS)) != null) {
            builder.options(options);
        }
        if (tcp) {
            Object sslHostnameVerifier;
            String sslPassword;
            String sslKey;
            String sslCert;
            String sslRootCert;
            Object sslMode;
            Boolean ssl = (Boolean)connectionFactoryOptions.getValue(ConnectionFactoryOptions.SSL);
            if (ssl != null && ssl.booleanValue()) {
                builder.enableSsl();
            }
            if ((sslMode = connectionFactoryOptions.getValue(SSL_MODE)) != null) {
                if (sslMode instanceof String) {
                    builder.sslMode(SSLMode.fromValue(sslMode.toString()));
                } else {
                    builder.sslMode((SSLMode)((Object)sslMode));
                }
            }
            if ((sslRootCert = (String)connectionFactoryOptions.getValue(SSL_ROOT_CERT)) != null) {
                builder.sslRootCert(sslRootCert);
            }
            if ((sslCert = (String)connectionFactoryOptions.getValue(SSL_CERT)) != null) {
                builder.sslCert(sslCert);
            }
            if ((sslKey = (String)connectionFactoryOptions.getValue(SSL_KEY)) != null) {
                builder.sslKey(sslKey);
            }
            if ((sslPassword = (String)connectionFactoryOptions.getValue(SSL_PASSWORD)) != null) {
                builder.sslPassword(sslPassword);
            }
            if ((sslHostnameVerifier = connectionFactoryOptions.getValue(SSL_HOSTNAME_VERIFIER)) != null) {
                if (sslHostnameVerifier instanceof String) {
                    try {
                        Class<?> verifierClass = Class.forName((String)sslHostnameVerifier);
                        Object verifier = verifierClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        builder.sslHostnameVerifier((HostnameVerifier)verifier);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new IllegalStateException("Cannot instantiate " + sslHostnameVerifier, e);
                    }
                } else {
                    builder.sslHostnameVerifier((HostnameVerifier)sslHostnameVerifier);
                }
            }
            if (connectionFactoryOptions.hasOption(SSL_CONTEXT_BUILDER_CUSTOMIZER)) {
                builder.sslContextBuilderCustomizer((Function)connectionFactoryOptions.getRequiredValue(SSL_CONTEXT_BUILDER_CUSTOMIZER));
            }
        }
        return builder.build();
    }

    public String getDriver() {
        return POSTGRESQL_DRIVER;
    }

    public boolean supports(ConnectionFactoryOptions connectionFactoryOptions) {
        Assert.requireNonNull(connectionFactoryOptions, "connectionFactoryOptions must not be null");
        String driver = (String)connectionFactoryOptions.getValue(ConnectionFactoryOptions.DRIVER);
        return driver != null && (driver.equals(POSTGRESQL_DRIVER) || driver.equals(LEGACY_POSTGRESQL_DRIVER));
    }

    private static boolean convertToBoolean(Object value) {
        return value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean(value.toString());
    }

    private static int convertToInt(Object value) {
        return value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString());
    }
}

