/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.client;

public enum SSLMode {
    DISABLE("disable"),
    ALLOW("allow"),
    PREFER("prefer"),
    REQUIRE("require"),
    VERIFY_CA("verify-ca"),
    VERIFY_FULL("verify-full");

    private final String value;

    private SSLMode(String value) {
        this.value = value;
    }

    public boolean requireSsl() {
        return this == REQUIRE || this == VERIFY_CA || this == VERIFY_FULL;
    }

    public boolean startSsl() {
        return this != DISABLE && this != ALLOW;
    }

    public String toString() {
        return this.value;
    }

    public boolean verifyCertificate() {
        return this == VERIFY_CA || this == VERIFY_FULL;
    }

    public boolean verifyPeerName() {
        return this == VERIFY_FULL;
    }

    public static SSLMode fromValue(String sslModeString) {
        for (SSLMode sslMode : SSLMode.values()) {
            if (!sslMode.value.equalsIgnoreCase(sslModeString) && !sslMode.name().equalsIgnoreCase(sslModeString)) continue;
            return sslMode;
        }
        throw new IllegalArgumentException("Invalid ssl mode value: " + sslModeString);
    }
}

