/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.frontend;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.message.frontend.FrontendMessage;
import io.r2dbc.postgresql.message.frontend.FrontendMessageUtils;
import io.r2dbc.postgresql.util.Assert;
import java.util.Arrays;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class Parse
implements FrontendMessage {
    public static final String UNNAMED_STATEMENT = "";
    public static final int UNSPECIFIED = 0;
    private final String name;
    private final int[] parameters;
    private final String query;

    public Parse(String name, int[] parameters, String query) {
        this.name = Assert.requireNonNull(name, "name must not be null");
        this.parameters = Assert.requireNonNull(parameters, "parameters must not be null");
        this.query = Assert.requireNonNull(query, "query must not be null");
    }

    @Override
    public Publisher<ByteBuf> encode(ByteBufAllocator byteBufAllocator) {
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        return Mono.fromSupplier(() -> {
            ByteBuf out = byteBufAllocator.ioBuffer();
            FrontendMessageUtils.writeByte(out, 80);
            FrontendMessageUtils.writeLengthPlaceholder(out);
            FrontendMessageUtils.writeCStringUTF8(out, this.name);
            FrontendMessageUtils.writeCStringUTF8(out, this.query);
            FrontendMessageUtils.writeShort(out, this.parameters.length);
            for (int parameter : this.parameters) {
                FrontendMessageUtils.writeInt(out, parameter);
            }
            return FrontendMessageUtils.writeSize(out);
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parse that = (Parse)o;
        return Objects.equals(this.name, that.name) && Arrays.equals(this.parameters, that.parameters) && Objects.equals(this.query, that.query);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parameters, this.query);
    }

    public String toString() {
        return "Parse{name='" + this.name + '\'' + ", parameters=" + Arrays.toString(this.parameters) + ", query='" + this.query + '\'' + '}';
    }
}

