/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.r2dbc.postgresql.PostgresqlColumnMetadata;
import io.r2dbc.postgresql.codec.Codecs;
import io.r2dbc.postgresql.message.backend.RowDescription;
import io.r2dbc.postgresql.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;

final class PostgresqlRowMetadata
implements io.r2dbc.postgresql.api.PostgresqlRowMetadata {
    private static final Comparator<String> IGNORE_CASE_COMPARATOR = (o1, o2) -> o2.compareToIgnoreCase((String)o1);
    private final List<PostgresqlColumnMetadata> columnMetadatas;
    private volatile Collection<String> columnNames;

    PostgresqlRowMetadata(List<PostgresqlColumnMetadata> columnMetadatas) {
        this.columnMetadatas = Assert.requireNonNull(columnMetadatas, "columnMetadatas must not be null");
    }

    public PostgresqlColumnMetadata getColumnMetadata(int index) {
        if (index >= this.columnMetadatas.size()) {
            throw new IllegalArgumentException(String.format("Column index %d is larger than the number of columns %d", index, this.columnMetadatas.size()));
        }
        return this.columnMetadatas.get(index);
    }

    public PostgresqlColumnMetadata getColumnMetadata(String name) {
        Assert.requireNonNull(name, "name must not be null");
        for (PostgresqlColumnMetadata metadata : this.columnMetadatas) {
            if (!metadata.getName().equalsIgnoreCase(name)) continue;
            return metadata;
        }
        throw new IllegalArgumentException(String.format("Column name '%s' does not exist in column names %s", name, this.getColumnNames()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostgresqlRowMetadata that = (PostgresqlRowMetadata)o;
        return Objects.equals(this.columnMetadatas, that.columnMetadatas);
    }

    public List<PostgresqlColumnMetadata> getColumnMetadatas() {
        return Collections.unmodifiableList(this.columnMetadatas);
    }

    public Collection<String> getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = this.getColumnNames(this.columnMetadatas);
        }
        return Collections.unmodifiableCollection(this.columnNames);
    }

    public int hashCode() {
        return Objects.hash(this.columnMetadatas);
    }

    public String toString() {
        return "PostgresqlRowMetadata{columnMetadatas=" + this.columnMetadatas + ", columnNames=" + this.columnNames + '}';
    }

    static PostgresqlRowMetadata toRowMetadata(Codecs codecs, RowDescription rowDescription) {
        Assert.requireNonNull(codecs, "codecs must not be null");
        Assert.requireNonNull(rowDescription, "rowDescription must not be null");
        return new PostgresqlRowMetadata(PostgresqlRowMetadata.getColumnMetadatas(codecs, rowDescription));
    }

    private static List<PostgresqlColumnMetadata> getColumnMetadatas(Codecs codecs, RowDescription rowDescription) {
        ArrayList<PostgresqlColumnMetadata> columnMetadatas = new ArrayList<PostgresqlColumnMetadata>(rowDescription.getFields().size());
        for (RowDescription.Field field : rowDescription.getFields()) {
            columnMetadatas.add(PostgresqlColumnMetadata.toColumnMetadata(codecs, field));
        }
        return columnMetadatas;
    }

    private Collection<String> getColumnNames(List<PostgresqlColumnMetadata> columnMetadatas) {
        TreeSet<String> columnNames = new TreeSet<String>(IGNORE_CASE_COMPARATOR);
        for (PostgresqlColumnMetadata columnMetadata : columnMetadatas) {
            columnNames.add(columnMetadata.getName());
        }
        return columnNames;
    }
}

