/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.r2dbc.postgresql.client.SSLConfig;
import io.r2dbc.postgresql.client.SSLMode;
import io.r2dbc.postgresql.message.frontend.SSLRequest;
import io.r2dbc.spi.R2dbcPermissionDeniedException;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLEngine;
import reactor.core.publisher.Mono;

final class SSLSessionHandlerAdapter
extends ChannelInboundHandlerAdapter
implements GenericFutureListener<Future<Channel>> {
    private final ByteBufAllocator alloc;
    private final SSLConfig sslConfig;
    private final SSLEngine sslEngine;
    private final SslHandler sslHandler;
    private final CompletableFuture<Void> handshakeFuture;

    SSLSessionHandlerAdapter(ByteBufAllocator alloc, SSLConfig sslConfig) {
        this.alloc = alloc;
        this.sslConfig = sslConfig;
        this.sslEngine = sslConfig.getSslProvider().get().getSslContext().newEngine(alloc);
        this.handshakeFuture = new CompletableFuture();
        this.sslHandler = new SslHandler(this.sslEngine);
        this.sslHandler.handshakeFuture().addListener((GenericFutureListener)this);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ByteBuf buf = (ByteBuf)msg;
        char response = (char)buf.readByte();
        switch (response) {
            case 'S': {
                this.processSslEnabled(ctx, msg);
                break;
            }
            case 'N': {
                this.processSslDisabled(ctx, msg);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown SSLResponse from server: '" + response + "'");
            }
        }
    }

    public void operationComplete(Future<Channel> future) throws Exception {
        if (!future.isSuccess()) {
            this.handshakeFuture.completeExceptionally(future.cause());
            return;
        }
        if (this.sslConfig.getSslMode() != SSLMode.VERIFY_FULL) {
            this.handshakeFuture.complete(null);
            return;
        }
        Channel channel = (Channel)future.get();
        InetSocketAddress socketAddress = (InetSocketAddress)channel.remoteAddress();
        String hostName = socketAddress.getHostName();
        if (this.sslConfig.getHostnameVerifier().verify(hostName, this.sslEngine.getSession())) {
            this.handshakeFuture.complete(null);
        } else {
            this.handshakeFuture.completeExceptionally((Throwable)((Object)new PostgresqlSslException(String.format("The hostname '%s' could not be verified.", socketAddress.getAddress().toString()))));
        }
    }

    private void processSslDisabled(ChannelHandlerContext ctx, Object msg) {
        if (this.sslConfig.getSslMode().requireSsl()) {
            PostgresqlSslException e = new PostgresqlSslException("Server support for SSL connection is disabled, but client was configured with SSL mode " + (Object)((Object)this.sslConfig.getSslMode()));
            this.handshakeFuture.completeExceptionally((Throwable)((Object)e));
        } else {
            this.handshakeFuture.complete(null);
        }
    }

    private void processSslEnabled(ChannelHandlerContext ctx, Object msg) {
        if (this.sslConfig.getSslMode() == SSLMode.DISABLE) {
            PostgresqlSslException e = new PostgresqlSslException("Server requires SSL handshake, but client was configured with SSL mode DISABLE");
            this.handshakeFuture.completeExceptionally((Throwable)((Object)e));
            return;
        }
        ctx.channel().pipeline().addFirst(new ChannelHandler[]{this.sslHandler}).remove((ChannelHandler)this);
        ctx.fireChannelRead(msg);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        Mono.from(SSLRequest.INSTANCE.encode(this.alloc)).subscribe(arg_0 -> ((ChannelHandlerContext)ctx).writeAndFlush(arg_0));
    }

    Mono<Void> getHandshake() {
        return Mono.fromFuture(this.handshakeFuture);
    }

    static final class PostgresqlSslException
    extends R2dbcPermissionDeniedException {
        PostgresqlSslException(String msg) {
            super(msg);
        }
    }
}

