/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractArrayCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import java.util.function.Supplier;

final class IntegerArrayCodec
extends AbstractArrayCodec<Integer> {
    IntegerArrayCodec(ByteBufAllocator byteBufAllocator) {
        super(byteBufAllocator, Integer.class);
    }

    @Override
    public Parameter encodeNull() {
        return IntegerArrayCodec.createNull(PostgresqlObjectId.INT4_ARRAY, Format.FORMAT_TEXT);
    }

    @Override
    Integer decodeItem(ByteBuf byteBuf) {
        return byteBuf.readInt();
    }

    @Override
    Integer decodeItem(String strValue) {
        return Integer.parseInt(strValue);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.INT4_ARRAY == type;
    }

    @Override
    Parameter encodeArray(Supplier<ByteBuf> encodedSupplier) {
        return IntegerArrayCodec.create(PostgresqlObjectId.INT4_ARRAY, Format.FORMAT_TEXT, encodedSupplier);
    }

    @Override
    String encodeItem(Integer value) {
        Assert.requireNonNull(value, "value must not be null");
        return value.toString();
    }
}

