/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.type;

public enum PostgresqlObjectId {
    BIT(1560),
    BIT_ARRAY(1561),
    BOOL(16),
    BOOL_ARRAY(1000),
    BOX(603),
    BPCHAR(1042),
    BPCHAR_ARRAY(1014),
    BYTEA(17),
    BYTEA_ARRAY(1001),
    CHAR(18),
    CHAR_ARRAY(1002),
    DATE(1082),
    DATE_ARRAY(1182),
    FLOAT4(700),
    FLOAT4_ARRAY(1021),
    FLOAT8(701),
    FLOAT8_ARRAY(1022),
    INET(869),
    INET_ARRAY(1041),
    INT2(21),
    INT2_ARRAY(1005),
    INT4(23),
    INT4_ARRAY(1007),
    INT8(20),
    INT8_ARRAY(1016),
    INTERVAL(1186),
    INTERVAL_ARRAY(1187),
    JSON(114),
    JSON_ARRAY(199),
    JSONB(3802),
    JSONB_ARRAY(3807),
    MONEY(790),
    MONEY_ARRAY(791),
    NAME(19),
    NAME_ARRAY(1003),
    NUMERIC(1700),
    NUMERIC_ARRAY(1231),
    OID(26),
    OID_ARRAY(1028),
    POINT(600),
    POINT_ARRAY(1017),
    REF_CURSOR(1790),
    REF_CURSOR_ARRAY(2201),
    TEXT(25),
    TEXT_ARRAY(1009),
    TIME(1083),
    TIME_ARRAY(1183),
    TIMESTAMP(1114),
    TIMESTAMP_ARRAY(1115),
    TIMESTAMPTZ(1184),
    TIMESTAMPTZ_ARRAY(1185),
    TIMETZ(1266),
    TIMETZ_ARRAY(1270),
    UNKNOWN(705),
    UNSPECIFIED(0),
    UUID(2950),
    UUID_ARRAY(2951),
    VARBIT(1562),
    VARBIT_ARRAY(1563),
    VARCHAR(1043),
    VARCHAR_ARRAY(1015),
    VOID(2278),
    XML(142),
    XML_ARRAY(143);

    public static final int OID_CACHE_SIZE = 4096;
    private static final PostgresqlObjectId[] CACHE;
    private final int objectId;

    private PostgresqlObjectId(int objectId) {
        this.objectId = objectId;
    }

    public static boolean isValid(int objectId) {
        if (objectId >= 0 && objectId < 4096) {
            PostgresqlObjectId oid = CACHE[objectId];
            return oid != null;
        }
        try {
            PostgresqlObjectId.valueOf(objectId);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static PostgresqlObjectId valueOf(int objectId) {
        if (objectId >= 0 && objectId < 4096) {
            PostgresqlObjectId oid = CACHE[objectId];
            if (oid == null) {
                throw new IllegalArgumentException(String.format("%d is not a valid object id", objectId));
            }
            return oid;
        }
        for (PostgresqlObjectId type : PostgresqlObjectId.values()) {
            if (type.objectId != objectId) continue;
            return type;
        }
        throw new IllegalArgumentException(String.format("%d is not a valid object id", objectId));
    }

    public int getObjectId() {
        return this.objectId;
    }

    static {
        CACHE = new PostgresqlObjectId[4096];
        PostgresqlObjectId[] postgresqlObjectIdArray = PostgresqlObjectId.values();
        int n = postgresqlObjectIdArray.length;
        for (int i = 0; i < n; ++i) {
            PostgresqlObjectId oid;
            PostgresqlObjectId.CACHE[oid.getObjectId()] = oid = postgresqlObjectIdArray[i];
        }
    }
}

