/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.BigDecimalCodec;
import io.r2dbc.postgresql.codec.BigIntegerCodec;
import io.r2dbc.postgresql.codec.BinaryByteArrayCodec;
import io.r2dbc.postgresql.codec.BinaryByteBufferCodec;
import io.r2dbc.postgresql.codec.BlobCodec;
import io.r2dbc.postgresql.codec.BooleanCodec;
import io.r2dbc.postgresql.codec.ByteCodec;
import io.r2dbc.postgresql.codec.CharacterCodec;
import io.r2dbc.postgresql.codec.ClobCodec;
import io.r2dbc.postgresql.codec.Codec;
import io.r2dbc.postgresql.codec.CodecRegistry;
import io.r2dbc.postgresql.codec.Codecs;
import io.r2dbc.postgresql.codec.DateCodec;
import io.r2dbc.postgresql.codec.DoubleCodec;
import io.r2dbc.postgresql.codec.FloatCodec;
import io.r2dbc.postgresql.codec.InetAddressCodec;
import io.r2dbc.postgresql.codec.InstantCodec;
import io.r2dbc.postgresql.codec.IntegerArrayCodec;
import io.r2dbc.postgresql.codec.IntegerCodec;
import io.r2dbc.postgresql.codec.JsonByteArrayCodec;
import io.r2dbc.postgresql.codec.JsonByteBufCodec;
import io.r2dbc.postgresql.codec.JsonByteBufferCodec;
import io.r2dbc.postgresql.codec.JsonCodec;
import io.r2dbc.postgresql.codec.JsonInputStreamCodec;
import io.r2dbc.postgresql.codec.JsonStringCodec;
import io.r2dbc.postgresql.codec.LocalDateCodec;
import io.r2dbc.postgresql.codec.LocalDateTimeCodec;
import io.r2dbc.postgresql.codec.LocalTimeCodec;
import io.r2dbc.postgresql.codec.LongArrayCodec;
import io.r2dbc.postgresql.codec.LongCodec;
import io.r2dbc.postgresql.codec.OffsetDateTimeCodec;
import io.r2dbc.postgresql.codec.OffsetTimeCodec;
import io.r2dbc.postgresql.codec.PointCodec;
import io.r2dbc.postgresql.codec.ShortArrayCodec;
import io.r2dbc.postgresql.codec.ShortCodec;
import io.r2dbc.postgresql.codec.StringArrayCodec;
import io.r2dbc.postgresql.codec.StringCodec;
import io.r2dbc.postgresql.codec.UriCodec;
import io.r2dbc.postgresql.codec.UrlCodec;
import io.r2dbc.postgresql.codec.UuidCodec;
import io.r2dbc.postgresql.codec.ZoneIdCodec;
import io.r2dbc.postgresql.codec.ZonedDateTimeCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import reactor.util.annotation.Nullable;

public final class DefaultCodecs
implements Codecs,
CodecRegistry {
    private final List<Codec<?>> codecs;

    public DefaultCodecs(ByteBufAllocator byteBufAllocator) {
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        this.codecs = new ArrayList<AbstractCodec>(Arrays.asList(new StringCodec(byteBufAllocator), new InstantCodec(byteBufAllocator), new ZonedDateTimeCodec(byteBufAllocator), new BinaryByteBufferCodec(byteBufAllocator), new BinaryByteArrayCodec(byteBufAllocator), new BigDecimalCodec(byteBufAllocator), new BigIntegerCodec(byteBufAllocator), new BooleanCodec(byteBufAllocator), new CharacterCodec(byteBufAllocator), new DoubleCodec(byteBufAllocator), new FloatCodec(byteBufAllocator), new InetAddressCodec(byteBufAllocator), new IntegerCodec(byteBufAllocator), new LocalDateCodec(byteBufAllocator), new LocalDateTimeCodec(byteBufAllocator), new LocalTimeCodec(byteBufAllocator), new LongCodec(byteBufAllocator), new OffsetDateTimeCodec(byteBufAllocator), new OffsetTimeCodec(byteBufAllocator), new ShortCodec(byteBufAllocator), new UriCodec(byteBufAllocator), new UrlCodec(byteBufAllocator), new UuidCodec(byteBufAllocator), new ZoneIdCodec(byteBufAllocator), new JsonCodec(byteBufAllocator), new JsonByteArrayCodec(byteBufAllocator), new JsonByteBufCodec(byteBufAllocator), new JsonByteBufferCodec(byteBufAllocator), new JsonInputStreamCodec(byteBufAllocator), new JsonStringCodec(byteBufAllocator), new ByteCodec(byteBufAllocator), new DateCodec(byteBufAllocator), new BlobCodec(byteBufAllocator), new ClobCodec(byteBufAllocator), new ShortArrayCodec(byteBufAllocator), new StringArrayCodec(byteBufAllocator), new IntegerArrayCodec(byteBufAllocator), new LongArrayCodec(byteBufAllocator), new PointCodec(byteBufAllocator)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFirst(Codec<?> codec) {
        Assert.requireNonNull(codec, "codec must not be null");
        List<Codec<?>> list = this.codecs;
        synchronized (list) {
            this.codecs.add(0, codec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLast(Codec<?> codec) {
        Assert.requireNonNull(codec, "codec must not be null");
        List<Codec<?>> list = this.codecs;
        synchronized (list) {
            this.codecs.add(codec);
        }
    }

    @Override
    @Nullable
    public <T> T decode(@Nullable ByteBuf buffer, int dataType, Format format, Class<? extends T> type) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        if (buffer == null) {
            return null;
        }
        for (Codec<T> codec : this.codecs) {
            if (!codec.canDecode(dataType, format, type)) continue;
            return (T)codec.decode(buffer, dataType, format, type);
        }
        throw new IllegalArgumentException(String.format("Cannot decode value of type %s", type.getName()));
    }

    @Override
    public Parameter encode(Object value) {
        Assert.requireNonNull(value, "value must not be null");
        for (Codec<?> codec : this.codecs) {
            if (!codec.canEncode(value)) continue;
            return codec.encode(value);
        }
        throw new IllegalArgumentException(String.format("Cannot encode parameter of type %s", value.getClass().getName()));
    }

    @Override
    public Parameter encodeNull(Class<?> type) {
        Assert.requireNonNull(type, "type must not be null");
        for (Codec<?> codec : this.codecs) {
            if (!codec.canEncodeNull(type)) continue;
            return codec.encodeNull();
        }
        throw new IllegalArgumentException(String.format("Cannot encode null parameter of type %s", type.getName()));
    }

    @Override
    public Class<?> preferredType(int dataType, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        for (Codec<Object> codec : this.codecs) {
            if (!codec.canDecode(dataType, format, Object.class)) continue;
            return codec.type();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Codec<?>> iterator() {
        List<Codec<?>> list = this.codecs;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList(this.codecs)).iterator();
        }
    }
}

