/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.Codec;
import io.r2dbc.postgresql.codec.PostgresTypes;
import io.r2dbc.postgresql.extension.CodecRegistrar;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public final class EnumCodec<T extends Enum<T>>
implements Codec<T> {
    private static final Logger logger = Loggers.getLogger(EnumCodec.class);
    private final ByteBufAllocator byteBufAllocator;
    private final Class<T> type;
    private final int oid;

    public EnumCodec(ByteBufAllocator byteBufAllocator, Class<T> type, int oid) {
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        this.type = Assert.requireNonNull(type, "type must not be null");
        this.oid = oid;
    }

    @Override
    public boolean canDecode(int dataType, Format format, Class<?> type) {
        Assert.requireNonNull(type, "type must not be null");
        return this.type.equals(type) && dataType == this.oid;
    }

    @Override
    public boolean canEncode(Object value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.type.isInstance(value);
    }

    @Override
    public boolean canEncodeNull(Class<?> type) {
        Assert.requireNonNull(type, "type must not be null");
        return this.type.equals(type);
    }

    @Override
    public T decode(@Nullable ByteBuf buffer, int dataType, Format format, Class<? extends T> type) {
        if (buffer == null) {
            return null;
        }
        return Enum.valueOf(this.type, ByteBufUtils.decode(buffer));
    }

    @Override
    public Parameter encode(Object value) {
        Assert.requireNonNull(value, "value must not be null");
        return new Parameter(Format.FORMAT_TEXT, this.oid, (Publisher<? extends ByteBuf>)Mono.fromSupplier(() -> ByteBufUtils.encode(this.byteBufAllocator, ((Enum)this.type.cast(value)).name())));
    }

    @Override
    public Parameter encodeNull() {
        return new Parameter(Format.FORMAT_BINARY, this.oid, (Publisher<? extends ByteBuf>)Parameter.NULL_VALUE);
    }

    @Override
    public Class<?> type() {
        return this.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Class<? extends Enum<?>>> mapping = new LinkedHashMap();

        public Builder withEnum(String name, Class<? extends Enum<?>> enumClass) {
            Assert.requireNonNull(enumClass, "Enum class must not be null");
            Assert.isTrue(enumClass.isEnum(), String.format("Enum class %s must be an enum type", enumClass.getName()));
            if (this.mapping.containsKey(name)) {
                throw new IllegalArgumentException(String.format("Builder contains already a mapping for Postgres type %s", name));
            }
            if (this.mapping.containsValue(enumClass)) {
                throw new IllegalArgumentException(String.format("Builder contains already a mapping for Java type %s", enumClass.getName()));
            }
            this.mapping.put(Assert.requireNotEmpty(name, "Postgres type name must not be null"), enumClass);
            return this;
        }

        public CodecRegistrar build() {
            LinkedHashMap mapping = new LinkedHashMap(this.mapping);
            return (connection, allocator, registry) -> {
                ArrayList missing = new ArrayList(mapping.keySet());
                return PostgresTypes.from(connection).lookupTypes(mapping.keySet()).filter(PostgresTypes.PostgresType::isEnum).doOnNext(it -> {
                    Class enumClass = (Class)mapping.get(it.getName());
                    if (enumClass == null) {
                        logger.warn(String.format("Cannot find Java type for enum type '%s' with oid %d. Known types are: %s", it.getName(), it.getOid(), mapping));
                        return;
                    }
                    missing.remove(it.getName());
                    logger.debug(String.format("Registering codec for type '%s' with oid %d using Java enum type '%s'", it.getName(), it.getOid(), enumClass.getName()));
                    registry.addLast(new EnumCodec(allocator, enumClass, it.getOid()));
                }).doOnComplete(() -> {
                    if (!missing.isEmpty()) {
                        logger.warn(String.format("Could not lookup enum types for: %s", missing));
                    }
                }).then();
            };
        }
    }
}

