/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.Point;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import reactor.util.annotation.Nullable;

final class PointCodec
extends AbstractCodec<Point> {
    private final ByteBufAllocator byteBufAllocator;

    PointCodec(ByteBufAllocator byteBufAllocator) {
        super(Point.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, @Nullable Format format) {
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.POINT == type;
    }

    @Override
    Point doDecode(ByteBuf buffer, PostgresqlObjectId dataType, Format format, Class<? extends Point> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        Assert.requireNonNull(type, "type must not be null");
        Assert.requireNonNull(format, "format must not be null");
        if (format == Format.FORMAT_BINARY) {
            double x = buffer.readDouble();
            double y = buffer.readDouble();
            return Point.of(x, y);
        }
        String decodedAsString = ByteBufUtils.decode(buffer);
        String parenRemovedVal = decodedAsString.replaceAll("[()]", "");
        String[] coordinatesAsString = parenRemovedVal.split(",");
        double x = Double.parseDouble(coordinatesAsString[0]);
        double y = Double.parseDouble(coordinatesAsString[1]);
        return Point.of(x, y);
    }

    @Override
    Parameter doEncode(Point value) {
        Assert.requireNonNull(value, "value must not be null");
        return PointCodec.create(PostgresqlObjectId.POINT, Format.FORMAT_BINARY, () -> this.byteBufAllocator.buffer(this.lengthInBytes()).writeDouble(value.getX()).writeDouble(value.getY()));
    }

    @Override
    public Parameter encodeNull() {
        return PointCodec.createNull(PostgresqlObjectId.POINT, Format.FORMAT_BINARY);
    }

    int lengthInBytes() {
        return 16;
    }
}

