/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.r2dbc.postgresql.client.DefaultHostnameVerifier;
import io.r2dbc.postgresql.client.SSLConfig;
import io.r2dbc.postgresql.client.SSLMode;
import io.r2dbc.postgresql.extension.CodecRegistrar;
import io.r2dbc.postgresql.extension.Extension;
import io.r2dbc.postgresql.util.Assert;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.net.ssl.HostnameVerifier;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.SslProvider;
import reactor.util.annotation.Nullable;

public final class PostgresqlConnectionConfiguration {
    public static final int DEFAULT_PORT = 5432;
    private final String applicationName;
    private final boolean autodetectExtensions;
    private final Duration connectTimeout;
    private final String database;
    private final List<Extension> extensions;
    private final ToIntFunction<String> fetchSize;
    private final boolean forceBinary;
    private final String host;
    @Nullable
    private final LoopResources loopResources;
    private final Map<String, String> options;
    private final CharSequence password;
    private final int port;
    private final boolean preferAttachedBuffers;
    private final int preparedStatementCacheQueries;
    private final String socket;
    private final SSLConfig sslConfig;
    private final boolean tcpKeepAlive;
    private final boolean tcpNoDelay;
    private final String username;

    private PostgresqlConnectionConfiguration(String applicationName, boolean autodetectExtensions, @Nullable Duration connectTimeout, @Nullable String database, List<Extension> extensions, ToIntFunction<String> fetchSize, boolean forceBinary, @Nullable String host, @Nullable LoopResources loopResources, @Nullable Map<String, String> options, @Nullable CharSequence password, int port, boolean preferAttachedBuffers, int preparedStatementCacheQueries, @Nullable String schema, @Nullable String socket, SSLConfig sslConfig, boolean tcpKeepAlive, boolean tcpNoDelay, String username) {
        this.applicationName = Assert.requireNonNull(applicationName, "applicationName must not be null");
        this.autodetectExtensions = autodetectExtensions;
        this.connectTimeout = connectTimeout;
        this.extensions = Assert.requireNonNull(extensions, "extensions must not be null");
        this.database = database;
        this.fetchSize = fetchSize;
        this.forceBinary = forceBinary;
        this.host = host;
        this.loopResources = loopResources;
        Map<String, String> map = this.options = options == null ? new LinkedHashMap<String, String>() : new LinkedHashMap<String, String>(options);
        if (schema != null && !schema.isEmpty()) {
            this.options.put("search_path", schema);
        }
        this.password = password;
        this.port = port;
        this.preferAttachedBuffers = preferAttachedBuffers;
        this.preparedStatementCacheQueries = preparedStatementCacheQueries;
        this.socket = socket;
        this.sslConfig = sslConfig;
        this.tcpKeepAlive = tcpKeepAlive;
        this.tcpNoDelay = tcpNoDelay;
        this.username = Assert.requireNonNull(username, "username must not be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "PostgresqlConnectionConfiguration{applicationName='" + this.applicationName + '\'' + ", autodetectExtensions='" + this.autodetectExtensions + '\'' + ", connectTimeout=" + this.connectTimeout + ", database='" + this.database + '\'' + ", extensions=" + this.extensions + ", fetchSize=" + this.fetchSize + ", forceBinary='" + this.forceBinary + '\'' + ", host='" + this.host + '\'' + ", loopResources='" + this.loopResources + '\'' + ", options='" + this.options + '\'' + ", password='" + PostgresqlConnectionConfiguration.obfuscate(this.password != null ? this.password.length() : 0) + '\'' + ", port=" + this.port + ", preferAttachedBuffers=" + this.preferAttachedBuffers + ", socket=" + this.socket + ", tcpKeepAlive=" + this.tcpKeepAlive + ", tcpNoDelay=" + this.tcpNoDelay + ", username='" + this.username + '\'' + '}';
    }

    String getApplicationName() {
        return this.applicationName;
    }

    @Nullable
    Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Nullable
    String getDatabase() {
        return this.database;
    }

    List<Extension> getExtensions() {
        return this.extensions;
    }

    ToIntFunction<String> getFetchSize() {
        return this.fetchSize;
    }

    int getFetchSize(String sql) {
        return this.fetchSize.applyAsInt(sql);
    }

    @Nullable
    String getHost() {
        return this.host;
    }

    String getRequiredHost() {
        String host = this.getHost();
        if (host == null || host.isEmpty()) {
            throw new IllegalStateException("Connection is configured for socket connections and not for host usage");
        }
        return host;
    }

    @Nullable
    LoopResources getLoopResources() {
        return this.loopResources;
    }

    Map<String, String> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    @Nullable
    CharSequence getPassword() {
        return this.password;
    }

    int getPort() {
        return this.port;
    }

    boolean isPreferAttachedBuffers() {
        return this.preferAttachedBuffers;
    }

    int getPreparedStatementCacheQueries() {
        return this.preparedStatementCacheQueries;
    }

    @Nullable
    String getSocket() {
        return this.socket;
    }

    String getRequiredSocket() {
        String socket = this.getSocket();
        if (socket == null || socket.isEmpty()) {
            throw new IllegalStateException("Connection is configured to use host and port connections and not for socket usage");
        }
        return socket;
    }

    String getUsername() {
        return this.username;
    }

    boolean isAutodetectExtensions() {
        return this.autodetectExtensions;
    }

    boolean isForceBinary() {
        return this.forceBinary;
    }

    boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    boolean isUseSocket() {
        return this.getSocket() != null;
    }

    SSLConfig getSslConfig() {
        return this.sslConfig;
    }

    private static String obfuscate(int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append("*");
        }
        return builder.toString();
    }

    static class FixedFetchSize
    implements ToIntFunction<String> {
        private final int fetchSize;

        public FixedFetchSize(int fetchSize) {
            this.fetchSize = fetchSize;
        }

        @Override
        public int applyAsInt(String value) {
            return this.fetchSize;
        }

        public String toString() {
            return "" + this.fetchSize;
        }
    }

    public static final class Builder {
        private String applicationName = "r2dbc-postgresql";
        private boolean autodetectExtensions = true;
        @Nullable
        private Duration connectTimeout;
        @Nullable
        private String database;
        private final List<Extension> extensions = new ArrayList<Extension>();
        private ToIntFunction<String> fetchSize = sql -> 0;
        private boolean forceBinary = false;
        @Nullable
        private String host;
        private Map<String, String> options;
        @Nullable
        private CharSequence password;
        private int port = 5432;
        private boolean preferAttachedBuffers = false;
        private int preparedStatementCacheQueries = -1;
        @Nullable
        private String schema;
        @Nullable
        private String socket;
        @Nullable
        private String sslCert = null;
        private HostnameVerifier sslHostnameVerifier = DefaultHostnameVerifier.INSTANCE;
        @Nullable
        private String sslKey = null;
        private SSLMode sslMode = SSLMode.DISABLE;
        @Nullable
        private CharSequence sslPassword = null;
        @Nullable
        private String sslRootCert = null;
        private Function<SslContextBuilder, SslContextBuilder> sslContextBuilderCustomizer = Function.identity();
        private boolean tcpKeepAlive = false;
        private boolean tcpNoDelay = false;
        @Nullable
        private LoopResources loopResources = null;
        @Nullable
        private String username;

        private Builder() {
        }

        public Builder applicationName(String applicationName) {
            this.applicationName = Assert.requireNonNull(applicationName, "applicationName must not be null");
            return this;
        }

        public Builder autodetectExtensions(boolean autodetectExtensions) {
            this.autodetectExtensions = autodetectExtensions;
            return this;
        }

        public PostgresqlConnectionConfiguration build() {
            if (this.host == null && this.socket == null) {
                throw new IllegalArgumentException("host or socket must not be null");
            }
            if (this.host != null && this.socket != null) {
                throw new IllegalArgumentException("Connection must be configured for either host/port or socket usage but not both");
            }
            if (this.username == null) {
                throw new IllegalArgumentException("username must not be null");
            }
            return new PostgresqlConnectionConfiguration(this.applicationName, this.autodetectExtensions, this.connectTimeout, this.database, this.extensions, this.fetchSize, this.forceBinary, this.host, this.loopResources, this.options, this.password, this.port, this.preferAttachedBuffers, this.preparedStatementCacheQueries, this.schema, this.socket, this.createSslConfig(), this.tcpKeepAlive, this.tcpNoDelay, this.username);
        }

        public Builder connectTimeout(@Nullable Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder codecRegistrar(CodecRegistrar codecRegistrar) {
            return this.extendWith(codecRegistrar);
        }

        public Builder database(@Nullable String database) {
            this.database = database;
            return this;
        }

        public Builder enableSsl() {
            return this.sslMode(SSLMode.VERIFY_FULL);
        }

        public Builder extendWith(Extension extension) {
            this.extensions.add(Assert.requireNonNull(extension, "extension must not be null"));
            return this;
        }

        public Builder fetchSize(int fetchSize) {
            Assert.isTrue(fetchSize >= 0, "fetch size must be greater or equal zero");
            return this.fetchSize(new FixedFetchSize(fetchSize));
        }

        public Builder fetchSize(ToIntFunction<String> fetchSizeFunction) {
            Assert.requireNonNull(fetchSizeFunction, "fetch size function must be non null");
            this.fetchSize = fetchSizeFunction;
            return this;
        }

        public Builder forceBinary(boolean forceBinary) {
            this.forceBinary = forceBinary;
            return this;
        }

        public Builder host(String host) {
            this.host = Assert.requireNonNull(host, "host must not be null");
            return this;
        }

        public Builder loopResources(LoopResources loopResources) {
            this.loopResources = Assert.requireNonNull(loopResources, "loopResources must not be null");
            return this;
        }

        public Builder options(Map<String, String> options) {
            Assert.requireNonNull(options, "options map must not be null");
            options.forEach((k, v) -> {
                Assert.requireNonNull(k, "option keys must not be null");
                Assert.requireNonNull(v, "option values must not be null");
            });
            this.options = options;
            return this;
        }

        public Builder password(@Nullable CharSequence password) {
            this.password = password;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder preferAttachedBuffers(boolean preferAttachedBuffers) {
            this.preferAttachedBuffers = preferAttachedBuffers;
            return this;
        }

        public Builder preparedStatementCacheQueries(int preparedStatementCacheQueries) {
            this.preparedStatementCacheQueries = preparedStatementCacheQueries;
            return this;
        }

        public Builder schema(@Nullable String schema) {
            this.schema = schema;
            return this;
        }

        public Builder socket(String socket) {
            this.socket = Assert.requireNonNull(socket, "host must not be null");
            this.sslMode(SSLMode.DISABLE);
            return this;
        }

        public Builder sslContextBuilderCustomizer(Function<SslContextBuilder, SslContextBuilder> sslContextBuilderCustomizer) {
            this.sslContextBuilderCustomizer = Assert.requireNonNull(sslContextBuilderCustomizer, "sslContextBuilderCustomizer must not be null");
            return this;
        }

        public Builder sslCert(String sslCert) {
            this.sslCert = Assert.requireFileExistsOrNull(sslCert, "sslCert must not be null and must exist");
            return this;
        }

        public Builder sslHostnameVerifier(HostnameVerifier sslHostnameVerifier) {
            this.sslHostnameVerifier = Assert.requireNonNull(sslHostnameVerifier, "sslHostnameVerifier must not be null");
            return this;
        }

        public Builder sslKey(String sslKey) {
            this.sslKey = Assert.requireFileExistsOrNull(sslKey, "sslKey must not be null and must exist");
            return this;
        }

        public Builder sslMode(SSLMode sslMode) {
            this.sslMode = Assert.requireNonNull(sslMode, "sslMode must be not be null");
            return this;
        }

        public Builder sslPassword(@Nullable CharSequence sslPassword) {
            this.sslPassword = sslPassword;
            return this;
        }

        public Builder sslRootCert(String sslRootCert) {
            this.sslRootCert = Assert.requireFileExistsOrNull(sslRootCert, "sslRootCert must not be null and must exist");
            return this;
        }

        public Builder tcpKeepAlive(boolean enabled) {
            this.tcpKeepAlive = enabled;
            return this;
        }

        public Builder tcpNoDelay(boolean enabled) {
            this.tcpNoDelay = enabled;
            return this;
        }

        public Builder username(String username) {
            this.username = Assert.requireNonNull(username, "username must not be null");
            return this;
        }

        public String toString() {
            return "Builder{applicationName='" + this.applicationName + '\'' + ", autodetectExtensions='" + this.autodetectExtensions + '\'' + ", connectTimeout='" + this.connectTimeout + '\'' + ", database='" + this.database + '\'' + ", extensions='" + this.extensions + '\'' + ", fetchSize='" + this.fetchSize + '\'' + ", forceBinary='" + this.forceBinary + '\'' + ", host='" + this.host + '\'' + ", loopResources='" + this.loopResources + '\'' + ", parameters='" + this.options + '\'' + ", password='" + PostgresqlConnectionConfiguration.obfuscate(this.password != null ? this.password.length() : 0) + '\'' + ", port=" + this.port + ", preparedStatementCacheQueries='" + this.preparedStatementCacheQueries + '\'' + ", schema='" + this.schema + '\'' + ", socket='" + this.socket + '\'' + ", sslContextBuilderCustomizer='" + this.sslContextBuilderCustomizer + '\'' + ", sslMode='" + (Object)((Object)this.sslMode) + '\'' + ", sslRootCert='" + this.sslRootCert + '\'' + ", sslCert='" + this.sslCert + '\'' + ", sslKey='" + this.sslKey + '\'' + ", sslHostnameVerifier='" + this.sslHostnameVerifier + '\'' + ", tcpKeepAlive='" + this.tcpKeepAlive + '\'' + ", tcpNoDelay='" + this.tcpNoDelay + '\'' + ", username='" + this.username + '\'' + '}';
        }

        private SSLConfig createSslConfig() {
            if (this.socket != null || this.sslMode == SSLMode.DISABLE) {
                return SSLConfig.disabled();
            }
            HostnameVerifier hostnameVerifier = this.sslHostnameVerifier;
            return new SSLConfig(this.sslMode, this.createSslProvider(), hostnameVerifier);
        }

        private Supplier<SslProvider> createSslProvider() {
            String pathname;
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
            if (this.sslMode.verifyCertificate()) {
                if (this.sslRootCert != null) {
                    sslContextBuilder.trustManager(new File(this.sslRootCert));
                }
            } else {
                sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            }
            String sslKey = this.sslKey;
            String sslCert = this.sslCert;
            String pathSeparator = System.getProperty("file.separator");
            String defaultDir = System.getProperty("os.name").toLowerCase().contains("windows") ? System.getenv("APPDATA") + pathSeparator + "postgresql" + pathSeparator : System.getProperty("user.home") + pathSeparator + ".postgresql" + pathSeparator;
            if (sslCert == null && new File(pathname = defaultDir + "postgresql.crt").exists()) {
                sslCert = pathname;
            }
            if (sslKey == null && new File(pathname = defaultDir + "postgresql.pk8").exists()) {
                sslKey = pathname;
            }
            if (sslKey != null && sslCert != null) {
                String sslPassword = this.sslPassword == null ? null : this.sslPassword.toString();
                sslContextBuilder.keyManager(new File(sslCert), new File(sslKey), sslPassword);
            }
            return () -> SslProvider.builder().sslContext(this.sslContextBuilderCustomizer.apply(sslContextBuilder)).defaultConfiguration(SslProvider.DefaultConfigurationType.TCP).build();
        }
    }
}

