/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.r2dbc.postgresql.BindingLogger;
import io.r2dbc.postgresql.ConnectionResources;
import io.r2dbc.postgresql.ExceptionFactory;
import io.r2dbc.postgresql.PostgresqlResult;
import io.r2dbc.postgresql.api.PostgresqlStatement;
import io.r2dbc.postgresql.client.Binding;
import io.r2dbc.postgresql.client.ConnectionContext;
import io.r2dbc.postgresql.client.ExtendedQueryMessageFlow;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.message.backend.BindComplete;
import io.r2dbc.postgresql.message.backend.NoData;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.GeneratedValuesUtils;
import io.r2dbc.postgresql.util.PredicateUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import reactor.core.publisher.Flux;

final class ExtendedQueryPostgresqlStatement
implements PostgresqlStatement {
    static final Predicate<BackendMessage> RESULT_FRAME_FILTER;
    private final Bindings bindings;
    private final ConnectionResources resources;
    private final ConnectionContext connectionContext;
    private final String sql;
    private int fetchSize;
    private String[] generatedColumns;

    ExtendedQueryPostgresqlStatement(ConnectionResources resources, String sql) {
        this.resources = Assert.requireNonNull(resources, "context must not be null");
        this.connectionContext = resources.getClient().getContext();
        this.sql = Assert.requireNonNull(sql, "sql must not be null");
        this.bindings = new Bindings(ExtendedQueryPostgresqlStatement.expectedSize(sql));
        this.fetchSize(this.resources.getConfiguration().getFetchSize(sql));
    }

    @Override
    public ExtendedQueryPostgresqlStatement add() {
        this.bindings.finish();
        return this;
    }

    @Override
    public ExtendedQueryPostgresqlStatement bind(String identifier, Object value) {
        Assert.requireNonNull(identifier, "identifier must not be null");
        Assert.requireType(identifier, String.class, "identifier must be a String");
        BindingLogger.logBind(this.connectionContext, identifier, value);
        return this.bind(this.getIndex(identifier), value);
    }

    @Override
    public ExtendedQueryPostgresqlStatement bind(int index, Object value) {
        Assert.requireNonNull(value, "value must not be null");
        BindingLogger.logBind(this.connectionContext, index, value);
        this.bindings.getCurrent().add(index, this.resources.getCodecs().encode(value));
        return this;
    }

    @Override
    public ExtendedQueryPostgresqlStatement bindNull(String identifier, Class<?> type) {
        Assert.requireNonNull(identifier, "identifier must not be null");
        Assert.requireType(identifier, String.class, "identifier must be a String");
        Assert.requireNonNull(type, "type must not be null");
        BindingLogger.logBindNull(this.connectionContext, identifier, type);
        this.bindNull(this.getIndex(identifier), (Class)type);
        return this;
    }

    @Override
    public ExtendedQueryPostgresqlStatement bindNull(int index, Class<?> type) {
        Assert.requireNonNull(type, "type must not be null");
        BindingLogger.logBindNull(this.connectionContext, index, type);
        this.bindings.getCurrent().add(index, this.resources.getCodecs().encodeNull(type));
        return this;
    }

    @Override
    public Flux<io.r2dbc.postgresql.api.PostgresqlResult> execute() {
        if (this.generatedColumns == null) {
            return this.execute(this.sql);
        }
        return this.execute(GeneratedValuesUtils.augment(this.sql, this.generatedColumns));
    }

    @Override
    public ExtendedQueryPostgresqlStatement returnGeneratedValues(String ... columns) {
        Assert.requireNonNull(columns, "columns must not be null");
        if (GeneratedValuesUtils.hasReturningClause(this.sql)) {
            throw new IllegalStateException("Statement already includes RETURNING clause");
        }
        if (!GeneratedValuesUtils.isSupportedCommand(this.sql)) {
            throw new IllegalStateException("Statement is not a DELETE, INSERT, or UPDATE command");
        }
        this.generatedColumns = columns;
        return this;
    }

    @Override
    public ExtendedQueryPostgresqlStatement fetchSize(int rows) {
        Assert.isTrue(rows >= 0, "fetch size must be greater or equal zero");
        this.fetchSize = rows;
        return this;
    }

    public String toString() {
        return "ExtendedQueryPostgresqlStatement{bindings=" + this.bindings + ", context=" + this.resources + ", sql='" + this.sql + '\'' + ", generatedColumns=" + Arrays.toString(this.generatedColumns) + '}';
    }

    static boolean supports(String sql) {
        Assert.requireNonNull(sql, "sql must not be null");
        return !sql.trim().isEmpty() && !sql.contains(";") && sql.contains("$1");
    }

    Binding getCurrentBinding() {
        return this.bindings.getCurrent();
    }

    private static int expectedSize(String sql) {
        Matcher m = ExtendedQueryMessageFlow.PARAMETER_SYMBOL.matcher(sql);
        HashSet<String> paramNames = new HashSet<String>();
        int count = 0;
        while (m.find()) {
            if (!paramNames.add(m.group())) continue;
            ++count;
        }
        return count;
    }

    private Flux<io.r2dbc.postgresql.api.PostgresqlResult> execute(String sql) {
        this.bindings.finish();
        ExceptionFactory factory = ExceptionFactory.withSql(sql);
        return this.resources.getStatementCache().getName(this.bindings.first(), sql).flatMapMany(name -> Flux.fromIterable((Iterable)this.bindings.bindings).map(binding -> ExtendedQueryPostgresqlStatement.createPostgresqlResult(sql, factory, name, binding, this.resources, this.fetchSize))).cast(io.r2dbc.postgresql.api.PostgresqlResult.class);
    }

    static PostgresqlResult createPostgresqlResult(String sql, ExceptionFactory factory, String statementName, Binding binding, ConnectionResources context, int fetchSize) {
        Flux messages = ExtendedQueryMessageFlow.execute(binding, context.getClient(), context.getPortalNameSupplier(), statementName, sql, context.getConfiguration().isForceBinary(), fetchSize).filter(RESULT_FRAME_FILTER);
        return PostgresqlResult.toResult(context, (Flux<BackendMessage>)messages, factory);
    }

    private int getIndex(String identifier) {
        Matcher matcher = ExtendedQueryMessageFlow.PARAMETER_SYMBOL.matcher(identifier);
        if (!matcher.find()) {
            throw new IllegalArgumentException(String.format("Identifier '%s' is not a valid identifier. Should be of the pattern '%s'.", identifier, ExtendedQueryMessageFlow.PARAMETER_SYMBOL.pattern()));
        }
        return Integer.parseInt(matcher.group(1)) - 1;
    }

    static {
        Predicate[] predicateArray = new Predicate[2];
        predicateArray[0] = BindComplete.class::isInstance;
        predicateArray[1] = NoData.class::isInstance;
        RESULT_FRAME_FILTER = PredicateUtils.not(PredicateUtils.or(predicateArray));
    }

    private static final class Bindings {
        private final List<Binding> bindings = new ArrayList<Binding>();
        private final int expectedSize;
        private Binding current;

        private Bindings(int expectedSize) {
            this.expectedSize = expectedSize;
        }

        public String toString() {
            return "Bindings{bindings=" + this.bindings + ", current=" + this.current + '}';
        }

        private void finish() {
            if (this.current != null) {
                this.current.validate();
            }
            this.current = null;
        }

        private Binding first() {
            if (this.bindings.isEmpty()) {
                throw new IllegalStateException("No parameters have been bound");
            }
            return this.bindings.get(0);
        }

        private Binding getCurrent() {
            if (this.current == null) {
                this.current = new Binding(this.expectedSize);
                this.bindings.add(this.current);
            }
            return this.current;
        }
    }
}

