/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.r2dbc.postgresql.codec.Point;
import io.r2dbc.postgresql.util.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Path {
    private final boolean open;
    private final List<Point> points;

    private Path(boolean open, List<Point> points) {
        Assert.requireNonNull(points, "points must not be null");
        this.points = Collections.unmodifiableList(new ArrayList<Point>(points));
        this.open = open;
    }

    public static Path open(List<Point> points) {
        return Path.of(true, points);
    }

    public static Path closed(List<Point> points) {
        return Path.of(false, points);
    }

    public static Path of(boolean open, List<Point> points) {
        return new Path(open, points);
    }

    public static Path open(Point ... points) {
        return Path.of(true, points);
    }

    public static Path closed(Point ... points) {
        return Path.of(false, points);
    }

    public static Path of(boolean open, Point ... points) {
        Assert.requireNonNull(points, "points must not be null");
        return new Path(open, Arrays.asList(points));
    }

    public boolean isOpen() {
        return this.open;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Path path = (Path)o;
        return this.open == path.open && this.points.equals(path.points);
    }

    public int hashCode() {
        return Objects.hash(this.open, this.points);
    }

    public String toString() {
        String points = this.points.stream().map(Point::toString).collect(Collectors.joining(", "));
        return this.isOpen() ? String.format("[%s]", points) : String.format("(%s)", points);
    }
}

