/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.backend;

import io.netty.buffer.ByteBuf;
import io.netty.util.AbstractReferenceCounted;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.util.Assert;
import java.util.Arrays;
import reactor.util.annotation.Nullable;

public final class DataRow
extends AbstractReferenceCounted
implements BackendMessage {
    private static final int NULL = -1;
    private final ByteBuf[] columns;

    public DataRow(ByteBuf ... columns) {
        this.columns = Assert.requireNonNull(columns, "columns must not be null");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataRow dataRow = (DataRow)o;
        return Arrays.equals(this.columns, dataRow.columns);
    }

    public ByteBuf[] getColumns() {
        return this.columns;
    }

    public int hashCode() {
        return Arrays.hashCode(this.columns);
    }

    public String toString() {
        return "DataRow{columns=" + Arrays.toString(this.columns) + '}';
    }

    protected void deallocate() {
        for (ByteBuf column : this.columns) {
            if (column == null) continue;
            column.release();
        }
    }

    public DataRow touch(Object hint) {
        return this;
    }

    static DataRow decode(ByteBuf in) {
        Assert.requireNonNull(in, "in must not be null");
        int columnCount = in.readShort();
        ByteBuf[] columns = new ByteBuf[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            columns[i] = DataRow.decodeColumn(in);
        }
        return new DataRow(columns);
    }

    @Nullable
    private static ByteBuf decodeColumn(ByteBuf in) {
        Assert.requireNonNull(in, "in must not be null");
        int length = in.readInt();
        return -1 == length ? null : in.readRetainedSlice(length);
    }
}

