/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.NumericDecodeUtils;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import reactor.util.annotation.Nullable;

abstract class AbstractNumericCodec<T extends Number>
extends AbstractCodec<T> {
    private static final Set<PostgresqlObjectId> SUPPORTED_TYPES = EnumSet.of(PostgresqlObjectId.INT2, new PostgresqlObjectId[]{PostgresqlObjectId.INT4, PostgresqlObjectId.INT8, PostgresqlObjectId.FLOAT4, PostgresqlObjectId.FLOAT8, PostgresqlObjectId.NUMERIC, PostgresqlObjectId.OID});

    AbstractNumericCodec(Class<T> type) {
        super(type);
    }

    @Override
    public boolean canDecode(int dataType, Format format, Class<?> type) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        if (type == Object.class && PostgresqlObjectId.isValid(dataType) && PostgresqlObjectId.valueOf(dataType) != this.getDefaultType()) {
            return false;
        }
        return super.canDecode(dataType, format, type);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(type, "type must not be null");
        Assert.requireNonNull(format, "format must not be null");
        return SUPPORTED_TYPES.contains((Object)type);
    }

    T decodeNumber(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, Class<T> expectedType, Function<Number, T> converter) {
        Number number = NumericDecodeUtils.decodeNumber(buffer, dataType, format);
        return (T)((Number)AbstractNumericCodec.potentiallyConvert(number, expectedType, converter));
    }

    abstract PostgresqlObjectId getDefaultType();

    private static <T> T potentiallyConvert(Number number, Class<T> expectedType, Function<Number, T> converter) {
        return expectedType.isInstance(number) ? expectedType.cast(number) : converter.apply(number);
    }
}

