/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractNumericCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import reactor.util.annotation.Nullable;

final class FloatCodec
extends AbstractNumericCodec<Float> {
    private final ByteBufAllocator byteBufAllocator;

    FloatCodec(ByteBufAllocator byteBufAllocator) {
        super(Float.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    public Parameter encodeNull() {
        return FloatCodec.createNull(PostgresqlObjectId.FLOAT4, Format.FORMAT_BINARY);
    }

    @Override
    Float doDecode(ByteBuf buffer, PostgresqlObjectId dataType, Format format, @Nullable Class<? extends Float> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        Assert.requireNonNull(format, "format must not be null");
        return this.decodeNumber(buffer, dataType, format, Float.class, Number::floatValue);
    }

    @Override
    Parameter doEncode(Float value) {
        Assert.requireNonNull(value, "value must not be null");
        return FloatCodec.create(PostgresqlObjectId.FLOAT4, Format.FORMAT_BINARY, () -> this.byteBufAllocator.buffer(4).writeFloat(value.floatValue()));
    }

    @Override
    PostgresqlObjectId getDefaultType() {
        return PostgresqlObjectId.FLOAT4;
    }
}

