/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.r2dbc.postgresql.ConnectionResources;
import io.r2dbc.postgresql.ExceptionFactory;
import io.r2dbc.postgresql.ExtendedFlowDelegate;
import io.r2dbc.postgresql.PostgresqlResult;
import io.r2dbc.postgresql.api.PostgresqlStatement;
import io.r2dbc.postgresql.client.Binding;
import io.r2dbc.postgresql.client.SimpleQueryMessageFlow;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.message.backend.CommandComplete;
import io.r2dbc.postgresql.message.backend.EmptyQueryResponse;
import io.r2dbc.postgresql.message.backend.ErrorResponse;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.GeneratedValuesUtils;
import io.r2dbc.postgresql.util.Operators;
import io.r2dbc.postgresql.util.PredicateUtils;
import java.util.Collections;
import java.util.function.Predicate;
import reactor.core.publisher.Flux;
import reactor.util.annotation.Nullable;

final class SimpleQueryPostgresqlStatement
implements PostgresqlStatement {
    private static final boolean REACTOR_3_4_AVAILABLE = SimpleQueryPostgresqlStatement.isPresent("reactor.util.context.ContextView", SimpleQueryPostgresqlStatement.class.getClassLoader());
    private static final Predicate<BackendMessage> WINDOW_UNTIL;
    private final ConnectionResources resources;
    private final String sql;
    private String[] generatedColumns;
    private int fetchSize;

    SimpleQueryPostgresqlStatement(ConnectionResources resources, String sql) {
        this.resources = Assert.requireNonNull(resources, "resources must not be null");
        this.sql = Assert.requireNonNull(sql, "sql must not be null");
        this.fetchSize(this.isBatch() ? 0 : this.resources.getConfiguration().getFetchSize(sql));
    }

    private boolean isBatch() {
        return this.sql.contains(";");
    }

    @Override
    public SimpleQueryPostgresqlStatement add() {
        return this;
    }

    @Override
    public SimpleQueryPostgresqlStatement bind(@Nullable String identifier, @Nullable Object value) {
        throw new UnsupportedOperationException(String.format("Binding parameters is not supported for the statement '%s'", this.sql));
    }

    @Override
    public SimpleQueryPostgresqlStatement bind(int index, @Nullable Object value) {
        throw new UnsupportedOperationException(String.format("Binding parameters is not supported for the statement '%s'", this.sql));
    }

    @Override
    public SimpleQueryPostgresqlStatement bindNull(@Nullable String identifier, @Nullable Class<?> type) {
        throw new UnsupportedOperationException(String.format("Binding parameters is not supported for the statement '%s'", this.sql));
    }

    @Override
    public SimpleQueryPostgresqlStatement bindNull(int index, @Nullable Class<?> type) {
        throw new UnsupportedOperationException(String.format("Binding parameters is not supported for the statement '%s'", this.sql));
    }

    @Override
    public Flux<io.r2dbc.postgresql.api.PostgresqlResult> execute() {
        return this.execute(this.generatedColumns == null ? this.sql : GeneratedValuesUtils.augment(this.sql, this.generatedColumns));
    }

    @Override
    public SimpleQueryPostgresqlStatement fetchSize(int rows) {
        Assert.isTrue(rows >= 0, "Fetch size must be greater or equal zero");
        if (rows != 0) {
            Assert.isTrue(!this.isBatch(), "Fetch size can only be used with a single SQL statement");
        }
        this.fetchSize = rows;
        return this;
    }

    @Override
    public SimpleQueryPostgresqlStatement returnGeneratedValues(String ... columns) {
        Assert.requireNonNull(columns, "columns must not be null");
        if (GeneratedValuesUtils.hasReturningClause(this.sql)) {
            throw new IllegalStateException("Statement already includes RETURNING clause");
        }
        if (!GeneratedValuesUtils.isSupportedCommand(this.sql)) {
            throw new IllegalStateException("Statement is not a DELETE, INSERT, or UPDATE command");
        }
        this.generatedColumns = columns;
        return this;
    }

    public String toString() {
        return "SimpleQueryPostgresqlStatement{context=" + this.resources + ", sql='" + this.sql + '\'' + '}';
    }

    static boolean supports(String sql) {
        Assert.requireNonNull(sql, "sql must not be null");
        return sql.trim().isEmpty() || !sql.contains("$1");
    }

    private Flux<io.r2dbc.postgresql.api.PostgresqlResult> execute(String sql) {
        ExceptionFactory factory = ExceptionFactory.withSql(sql);
        if (this.fetchSize != 0) {
            Flux<BackendMessage> messages = ExtendedFlowDelegate.runQuery(this.resources, factory, sql, Binding.EMPTY, Collections.emptyList(), this.fetchSize);
            return REACTOR_3_4_AVAILABLE ? (Flux)messages.windowUntil(WINDOW_UNTIL).map(msg -> new PostgresqlResult(this.resources, messages, factory)).as(Operators::discardOnCancel) : Flux.just((Object)new PostgresqlResult(this.resources, messages, factory));
        }
        Flux<BackendMessage> messages = SimpleQueryMessageFlow.exchange(this.resources.getClient(), sql);
        return REACTOR_3_4_AVAILABLE ? (Flux)messages.windowUntil(WINDOW_UNTIL).map(msg -> new PostgresqlResult(this.resources, messages, factory)).as(Operators::discardOnCancel) : Flux.just((Object)PostgresqlResult.toResult(this.resources, messages, factory));
    }

    private static boolean isPresent(String className, @Nullable ClassLoader classLoader) {
        try {
            try {
                Class.forName(className, false, classLoader);
            }
            catch (ClassNotFoundException ex) {
                int lastDotIndex = className.lastIndexOf(".");
                if (lastDotIndex != -1) {
                    String innerClassName = className.substring(0, lastDotIndex) + "$" + className.substring(lastDotIndex + 1);
                    try {
                        Class.forName(innerClassName, false, classLoader);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                throw ex;
            }
            return true;
        }
        catch (IllegalAccessError err) {
            throw new IllegalStateException("Readability mismatch in inheritance hierarchy of class [" + className + "]: " + err.getMessage(), err);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    static {
        Predicate[] predicateArray = new Predicate[3];
        predicateArray[0] = CommandComplete.class::isInstance;
        predicateArray[1] = EmptyQueryResponse.class::isInstance;
        predicateArray[2] = ErrorResponse.class::isInstance;
        WINDOW_UNTIL = PredicateUtils.or(predicateArray);
    }
}

