/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractTemporalCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.time.OffsetTime;

final class OffsetTimeCodec
extends AbstractTemporalCodec<OffsetTime> {
    private final ByteBufAllocator byteBufAllocator;

    OffsetTimeCodec(ByteBufAllocator byteBufAllocator) {
        super(OffsetTime.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    PostgresqlObjectId getDefaultType() {
        return PostgresqlObjectId.TIMETZ;
    }

    @Override
    OffsetTime doDecode(ByteBuf buffer, PostgresqlObjectId dataType, Format format, Class<? extends OffsetTime> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return this.decodeTemporal(buffer, dataType, format, OffsetTime.class, OffsetTime::from);
    }

    @Override
    Parameter doEncode(OffsetTime value) {
        Assert.requireNonNull(value, "value must not be null");
        return OffsetTimeCodec.create(PostgresqlObjectId.TIMETZ, Format.FORMAT_TEXT, () -> ByteBufUtils.encode(this.byteBufAllocator, value.toString()));
    }

    @Override
    public Parameter encodeNull() {
        return OffsetTimeCodec.createNull(PostgresqlObjectId.TIMETZ, Format.FORMAT_TEXT);
    }
}

