/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.spi.test;

import io.r2dbc.spi.Blob;
import io.r2dbc.spi.Clob;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ReadableMetadata;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.Statement;
import io.r2dbc.spi.ValidationDepth;
import io.r2dbc.spi.test.Assert;
import io.r2dbc.spi.test.Nullable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.support.AbstractLobCreatingPreparedStatementCallback;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public interface TestKit<T> {
    default public Mono<Integer> extractRowsUpdated(Result result) {
        return Mono.from((Publisher)result.getRowsUpdated());
    }

    default public Mono<Collection<Integer>> extractColumns(Result result) {
        return Flux.from((Publisher)result.map((row, rowMetadata) -> this.extractColumn((Row)row, (Class)Integer.class))).collect(Collectors.toSet());
    }

    @Nullable
    default public Object extractColumn(Row row) {
        return row.get("test_value");
    }

    @Nullable
    default public <V> V extractColumn(Row row, Class<V> type) {
        return (V)row.get("test_value", type);
    }

    default public String expand(TestStatement statement, Object ... args) {
        return String.format(this.doGetSql(statement), args);
    }

    default public String doGetSql(TestStatement statement) {
        return statement.getSql();
    }

    @Deprecated
    default public String getInsertIntoWithAutogeneratedKey() {
        return this.expand(TestStatement.INSERT_VALUE_AUTOGENERATED_KEY, new Object[0]);
    }

    @Deprecated
    default public String getCreateTableWithAutogeneratedKey() {
        return this.expand(TestStatement.CREATE_TABLE_AUTOGENERATED_KEY, new Object[0]);
    }

    default public String blobType() {
        return "BLOB";
    }

    default public String clobType() {
        return "CLOB";
    }

    @BeforeEach
    default public void createTable() {
        this.getJdbcOperations().execute(this.expand(TestStatement.CREATE_TABLE, new Object[0]));
        this.getJdbcOperations().execute(this.expand(TestStatement.CREATE_TABLE_TWO_COLUMNS, new Object[0]));
        this.getJdbcOperations().execute(this.expand(TestStatement.CREATE_BLOB_TABLE, this.blobType()));
        this.getJdbcOperations().execute(this.expand(TestStatement.CREATE_CLOB_TABLE, this.clobType()));
    }

    @AfterEach
    default public void dropTable() {
        this.getJdbcOperations().execute(this.expand(TestStatement.DROP_TABLE, new Object[0]));
        this.getJdbcOperations().execute(this.expand(TestStatement.DROP_TABLE_TWO_COLUMNS, new Object[0]));
        this.getJdbcOperations().execute(this.expand(TestStatement.DROP_BLOB_TABLE, new Object[0]));
        this.getJdbcOperations().execute(this.expand(TestStatement.DROP_CLOB_TABLE, new Object[0]));
    }

    public ConnectionFactory getConnectionFactory();

    public String getPlaceholder(int var1);

    public T getIdentifier(int var1);

    public JdbcOperations getJdbcOperations();

    @Test
    default public void autoCommitByDefault() {
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> Flux.just((Object)connection.isAutoCommit()), Connection::close).as(StepVerifier::create)).expectNext((Object)true).as("new connections are in auto-commit mode").verifyComplete();
    }

    @Test
    default public void changeAutoCommitCommitsTransaction() {
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> Flux.from((Publisher)connection.setAutoCommit(false)).thenMany(connection.beginTransaction()).thenMany(connection.createStatement(this.expand(TestStatement.INSERT_VALUE200, new Object[0])).execute()).flatMap(Result::getRowsUpdated).thenMany(connection.setAutoCommit(true)).thenMany(connection.createStatement(this.expand(TestStatement.SELECT_VALUE, new Object[0])).execute()).flatMap(it -> it.map((row, metadata) -> this.extractColumn((Row)row))), Connection::close).as(StepVerifier::create)).expectNext((Object)200).as("autoCommit(true) committed the transaction. Expecting a value to be present").verifyComplete();
    }

    @Test
    default public void sameAutoCommitLeavesTransactionUnchanged() {
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> Flux.from((Publisher)connection.setAutoCommit(false)).thenMany(connection.beginTransaction()).thenMany(connection.createStatement(this.expand(TestStatement.INSERT_VALUE200, new Object[0])).execute()).flatMap(Result::getRowsUpdated).thenMany(connection.setAutoCommit(false)).thenMany(connection.rollbackTransaction()).thenMany(connection.createStatement(this.expand(TestStatement.SELECT_VALUE, new Object[0])).execute()).flatMap(it -> it.map((row, metadata) -> this.extractColumn((Row)row))), Connection::close).as(StepVerifier::create)).verifyComplete();
    }

    @Test
    default public void batch() {
        this.getJdbcOperations().execute(this.expand(TestStatement.INSERT_VALUE100, new Object[0]));
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> Flux.from((Publisher)connection.createBatch().add(this.expand(TestStatement.INSERT_VALUE200, new Object[0])).add(this.expand(TestStatement.SELECT_VALUE, new Object[0])).execute()).flatMap(Result::getRowsUpdated), Connection::close).then().as(StepVerifier::create)).verifyComplete();
    }

    @Test
    default public void bindFails() {
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> {
            Statement statement = connection.createStatement(this.expand(TestStatement.INSERT_VALUE_PLACEHOLDER, this.getPlaceholder(0)));
            Assertions.assertThrows(IllegalArgumentException.class, () -> statement.bind(0, null), (String)"bind(0, null) should fail");
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> statement.bind(99, (Object)""), (String)"bind(nonexistent-index, null) should fail");
            Assertions.assertThrows(IllegalArgumentException.class, () -> TestKit.bind(statement, this.getIdentifier(0), null), (String)"bind(identifier, null) should fail");
            Assertions.assertThrows(IllegalArgumentException.class, () -> TestKit.bind(statement, this.getIdentifier(0), Class.class), (String)"bind(identifier, Class.class) should fail");
            Assertions.assertThrows(NoSuchElementException.class, () -> statement.bind("unknown-placeholder", (Object)""), (String)"bind(unknown-placeholder, \"\") should fail");
            return Mono.empty();
        }, Connection::close).as(StepVerifier::create)).verifyComplete();
    }

    @Test
    default public void bindNull() {
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> {
            Statement statement = connection.createStatement(this.expand(TestStatement.INSERT_VALUE_PLACEHOLDER, this.getPlaceholder(0)));
            TestKit.bindNull(statement, this.getIdentifier(0), Integer.class);
            return Flux.from((Publisher)statement.execute()).flatMap(this::extractRowsUpdated);
        }, Connection::close).as(StepVerifier::create)).expectNextCount(1L).as("rows inserted").verifyComplete();
    }

    @Test
    default public void bindNullFails() {
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> {
            Statement statement = connection.createStatement(this.expand(TestStatement.INSERT_VALUE_PLACEHOLDER, this.getPlaceholder(0)));
            Assertions.assertThrows(IllegalArgumentException.class, () -> statement.bindNull(null, String.class), (String)"bindNull(null, \u2026) should fail");
            Assertions.assertThrows(IllegalArgumentException.class, () -> TestKit.bind(statement, this.getIdentifier(0), null), (String)"bindNull(identifier, null) should fail");
            return Mono.empty();
        }, Connection::close).as(StepVerifier::create)).verifyComplete();
    }

    @Test
    default public void blobInsert() {
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> {
            Statement statement = connection.createStatement(this.expand(TestStatement.INSERT_BLOB_VALUE_PLACEHOLDER, this.getPlaceholder(0)));
            TestKit.bind(statement, this.getIdentifier(0), Blob.from((Publisher)Mono.just((Object)StandardCharsets.UTF_8.encode("test-value"))));
            return Flux.from((Publisher)statement.execute()).flatMap(this::extractRowsUpdated);
        }, Connection::close).as(StepVerifier::create)).expectNextCount(1L).as("rows inserted").verifyComplete();
    }

    @Test
    default public void blobSelect() {
        this.getJdbcOperations().execute(this.expand(TestStatement.INSERT_BLOB_VALUE_PLACEHOLDER, "?"), (PreparedStatementCallback)new AbstractLobCreatingPreparedStatementCallback((LobHandler)new DefaultLobHandler()){

            protected void setValues(PreparedStatement ps, LobCreator lobCreator) throws SQLException {
                lobCreator.setBlobAsBytes(ps, 1, StandardCharsets.UTF_8.encode("test-value").array());
            }
        });
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> Flux.from((Publisher)connection.createStatement(this.expand(TestStatement.SELECT_BLOB_VALUE, new Object[0])).execute()).flatMap(result -> result.map((row, rowMetadata) -> this.extractColumn((Row)row))).cast(ByteBuffer.class).map(buffer -> {
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            return bytes;
        }), Connection::close).as(StepVerifier::create)).expectNextMatches(actual -> {
            ByteBuffer expected = StandardCharsets.UTF_8.encode("test-value");
            return Arrays.equals(expected.array(), actual);
        }).verifyComplete();
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> Flux.from((Publisher)connection.createStatement(this.expand(TestStatement.SELECT_BLOB_VALUE, new Object[0])).execute()).flatMap(result -> Flux.usingWhen((Publisher)result.map((row, rowMetadata) -> this.extractColumn((Row)row, (Class)Blob.class)), blob -> Flux.from((Publisher)blob.stream()).reduce(ByteBuffer::put), Blob::discard)), Connection::close).as(StepVerifier::create)).expectNextMatches(actual -> {
            ByteBuffer expected = StandardCharsets.UTF_8.encode("test-value");
            return Arrays.equals(expected.array(), actual.array());
        }).verifyComplete();
    }

    @Test
    default public void clobInsert() {
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> {
            Statement statement = connection.createStatement(this.expand(TestStatement.INSERT_CLOB_VALUE_PLACEHOLDER, this.getPlaceholder(0)));
            TestKit.bind(statement, this.getIdentifier(0), Clob.from((Publisher)Mono.just((Object)"test-value")));
            return Flux.from((Publisher)statement.execute()).flatMap(Result::getRowsUpdated);
        }, Connection::close).as(StepVerifier::create)).expectNextCount(1L).as("rows inserted").verifyComplete();
    }

    @Test
    default public void clobSelect() {
        this.getJdbcOperations().execute(this.expand(TestStatement.INSERT_CLOB_VALUE_PLACEHOLDER, "?"), (PreparedStatementCallback)new AbstractLobCreatingPreparedStatementCallback((LobHandler)new DefaultLobHandler()){

            protected void setValues(PreparedStatement ps, LobCreator lobCreator) throws SQLException {
                lobCreator.setClobAsString(ps, 1, "test-value");
            }
        });
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> Flux.from((Publisher)connection.createStatement(this.expand(TestStatement.SELECT_CLOB_VALUE, new Object[0])).execute()).flatMap(result -> result.map((row, rowMetadata) -> this.extractColumn((Row)row))), Connection::close).as(StepVerifier::create)).expectNext((Object)"test-value").as("test_value from select").verifyComplete();
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> Flux.from((Publisher)connection.createStatement(this.expand(TestStatement.SELECT_CLOB_VALUE, new Object[0])).execute()).flatMap(result -> Flux.usingWhen((Publisher)result.map((row, rowMetadata) -> this.extractColumn((Row)row, (Class)Clob.class)), clob -> Flux.from((Publisher)clob.stream()).reduce((Object)new StringBuilder(), StringBuilder::append).map(StringBuilder::toString), Clob::discard)), Connection::close).as(StepVerifier::create)).expectNext((Object)"test-value").as("test_value from select").verifyComplete();
    }

    @Test
    default public void columnMetadata() {
        this.getJdbcOperations().execute(this.expand(TestStatement.INSERT_TWO_COLUMNS, new Object[0]));
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> Flux.from((Publisher)connection.createStatement(this.expand(TestStatement.SELECT_VALUE_TWO_COLUMNS, new Object[0])).execute()).flatMap(result -> result.map((row, rowMetadata) -> Arrays.asList(rowMetadata.contains("test_value"), rowMetadata.contains("TEST_VALUE"), TestKit.captureException(() -> rowMetadata.getColumnMetadata(-1)), TestKit.captureException(() -> rowMetadata.getColumnMetadata(100)), TestKit.captureException(() -> rowMetadata.getColumnMetadata("unknown"))))).flatMapIterable(Function.identity()), Connection::close).as(StepVerifier::create)).expectNext((Object)true).as("rowMetadata.contains(value)").expectNext((Object)true).as("rowMetadata.contains(VALUE)").expectNextMatches(IndexOutOfBoundsException.class::isInstance).as("getColumnMetadata(-1) throws IndexOutOfBoundsException").expectNextMatches(IndexOutOfBoundsException.class::isInstance).as("getColumnMetadata(100) throws IndexOutOfBoundsException").expectNextMatches(NoSuchElementException.class::isInstance).as("getColumnMetadata(unknown) throws NoSuchElementException").verifyComplete();
    }

    @Test
    default public void rowMetadata() {
        this.getJdbcOperations().execute(this.expand(TestStatement.INSERT_TWO_COLUMNS, new Object[0]));
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> Flux.from((Publisher)connection.createStatement(this.expand(TestStatement.SELECT_VALUE_ALIASED_COLUMNS, new Object[0])).execute()).flatMap(result -> result.map((row, rowMetadata) -> rowMetadata.getColumnMetadatas().stream().map(ReadableMetadata::getName).collect(Collectors.toList()))).flatMapIterable(Function.identity()), Connection::close).as(StepVerifier::create)).expectNext((Object)"b").as("First column label: b").expectNext((Object)"c").as("First column label: c").expectNext((Object)"a").as("First column label: a").verifyComplete();
    }

    @Test
    default public void row() {
        this.getJdbcOperations().execute(this.expand(TestStatement.INSERT_TWO_COLUMNS, new Object[0]));
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> Flux.from((Publisher)connection.createStatement(this.expand(TestStatement.SELECT_VALUE_ALIASED_COLUMNS, new Object[0])).execute()).flatMap(result -> result.map(readable -> Arrays.asList(TestKit.captureException(() -> readable.get(-1)), TestKit.captureException(() -> readable.get(100)), TestKit.captureException(() -> readable.get("unknown"))))).flatMapIterable(Function.identity()), Connection::close).as(StepVerifier::create)).expectNextMatches(IndexOutOfBoundsException.class::isInstance).as("get(-1) throws IndexOutOfBoundsException").expectNextMatches(IndexOutOfBoundsException.class::isInstance).as("get(100) throws IndexOutOfBoundsException").expectNextMatches(NoSuchElementException.class::isInstance).as("get(unknown) throws NoSuchElementException").verifyComplete();
    }

    @Test
    default public void compoundStatement() {
        this.getJdbcOperations().execute(this.expand(TestStatement.INSERT_VALUE100, new Object[0]));
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> Flux.from((Publisher)connection.createStatement(this.expand(TestStatement.SELECT_VALUE_BATCH, new Object[0])).execute()).flatMap(this::extractColumns), Connection::close).as(StepVerifier::create)).expectNext(TestKit.collectionOf(100)).as("test_value from first select").expectNext(TestKit.collectionOf(100)).as("test_value from second select").verifyComplete();
    }

    @Test
    default public void createStatementFails() {
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> {
            Assertions.assertThrows(IllegalArgumentException.class, () -> connection.createStatement(null));
            return Mono.empty();
        }, Connection::close).as(StepVerifier::create)).verifyComplete();
    }

    @Test
    default public void duplicateColumnNames() {
        this.getJdbcOperations().execute(this.expand(TestStatement.INSERT_TWO_COLUMNS, new Object[0]));
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> Flux.from((Publisher)connection.createStatement(this.expand(TestStatement.SELECT_VALUE_TWO_COLUMNS, new Object[0])).execute()).flatMap(result -> result.map((row, rowMetadata) -> Arrays.asList(row.get("test_value"), row.get("TEST_VALUE")))).flatMapIterable(Function.identity()), Connection::close).as(StepVerifier::create)).expectNext((Object)100).as("test_value from col1").expectNext((Object)100).as("test_value from col1 (upper case)").verifyComplete();
    }

    @Test
    default public void prepareStatement() {
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> {
            Statement statement = connection.createStatement(this.expand(TestStatement.INSERT_VALUE_PLACEHOLDER, this.getPlaceholder(0)));
            IntStream.range(0, 10).forEach(i -> {
                TestKit.bind(statement, this.getIdentifier(0), i);
                if (i != 9) {
                    statement.add();
                }
            });
            return Flux.from((Publisher)statement.execute()).flatMap(this::extractRowsUpdated);
        }, Connection::close).as(StepVerifier::create)).expectNextCount(10L).as("values from insertions").verifyComplete();
    }

    @Test
    default public void prepareStatementWithTrailingAddShouldFail() {
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> {
            Statement statement = connection.createStatement(this.expand(TestStatement.INSERT_VALUE_PLACEHOLDER, this.getPlaceholder(0)));
            TestKit.bind(statement, this.getIdentifier(0), 0).add();
            return Flux.from((Publisher)statement.execute()).flatMap(this::extractRowsUpdated).then();
        }, Connection::close).as(StepVerifier::create)).verifyError();
    }

    @Test
    default public void prepareStatementWithIncompleteBatchFails() {
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> {
            Statement statement = connection.createStatement(this.expand(TestStatement.INSERT_TWO_VALUES_PLACEHOLDER, this.getPlaceholder(0), this.getPlaceholder(1)));
            TestKit.bind(statement, this.getIdentifier(0), 0);
            Assertions.assertThrows(IllegalStateException.class, () -> ((Statement)statement).add());
            return Mono.empty();
        }, Connection::close).as(StepVerifier::create)).verifyComplete();
    }

    @Test
    default public void prepareStatementWithIncompleteBindingFails() {
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> {
            Statement statement = connection.createStatement(this.expand(TestStatement.INSERT_TWO_VALUES_PLACEHOLDER, this.getPlaceholder(0), this.getPlaceholder(1)));
            TestKit.bind(statement, this.getIdentifier(0), 0);
            Assertions.assertThrows(IllegalStateException.class, () -> ((Statement)statement).execute());
            return Mono.empty();
        }, Connection::close).as(StepVerifier::create)).verifyComplete();
    }

    @Test
    default public void returnGeneratedValues() {
        this.getJdbcOperations().execute(this.expand(TestStatement.DROP_TABLE, new Object[0]));
        this.getJdbcOperations().execute(this.getCreateTableWithAutogeneratedKey());
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> {
            Statement statement = connection.createStatement(this.getInsertIntoWithAutogeneratedKey());
            statement.returnGeneratedValues(new String[0]);
            return Flux.from((Publisher)statement.execute()).flatMap(it -> it.map((row, rowMetadata) -> row.get(0)));
        }, Connection::close).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
    }

    @Test
    default public void returnGeneratedValuesFails() {
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> {
            Statement statement = connection.createStatement(this.expand(TestStatement.INSERT_VALUE100, new Object[0]));
            Assertions.assertThrows(IllegalArgumentException.class, () -> statement.returnGeneratedValues((String[])null));
            return Mono.empty();
        }, Connection::close).as(StepVerifier::create)).verifyComplete();
    }

    @Test
    default public void savePoint() {
        this.getJdbcOperations().execute(this.expand(TestStatement.INSERT_VALUE100, new Object[0]));
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> Mono.from((Publisher)connection.beginTransaction()).thenMany((Publisher)Flux.from((Publisher)connection.createStatement(this.expand(TestStatement.SELECT_VALUE, new Object[0])).execute()).flatMap(this::extractColumns)).concatWith((Publisher)Flux.defer(() -> {
            Statement statement = connection.createStatement(this.expand(TestStatement.INSERT_VALUE_PLACEHOLDER, this.getPlaceholder(0)));
            TestKit.bind(statement, this.getIdentifier(0), 200);
            return statement.execute();
        }).flatMap(this::extractRowsUpdated)).concatWith((Publisher)Flux.from((Publisher)connection.createStatement(this.expand(TestStatement.SELECT_VALUE, new Object[0])).execute()).flatMap(this::extractColumns)).concatWith(connection.createSavepoint("test_savepoint")).concatWith((Publisher)Flux.defer(() -> {
            Statement statement = connection.createStatement(this.expand(TestStatement.INSERT_VALUE_PLACEHOLDER, this.getPlaceholder(0)));
            TestKit.bind(statement, this.getIdentifier(0), 300);
            return statement.execute();
        }).flatMap(this::extractRowsUpdated)).concatWith((Publisher)Flux.from((Publisher)connection.createStatement(this.expand(TestStatement.SELECT_VALUE, new Object[0])).execute()).flatMap(this::extractColumns)).concatWith(connection.rollbackTransactionToSavepoint("test_savepoint")).concatWith((Publisher)Flux.from((Publisher)connection.createStatement(this.expand(TestStatement.SELECT_VALUE, new Object[0])).execute()).flatMap(this::extractColumns)), Connection::close).as(StepVerifier::create)).expectNext(TestKit.collectionOf(100)).as("test_value from select").expectNext((Object)1).as("rows inserted").expectNext(TestKit.collectionOf(100, 200)).as("values from select").expectNext((Object)1).as("rows inserted").expectNext(TestKit.collectionOf(100, 200, 300)).as("values from select").expectNext(TestKit.collectionOf(100, 200)).as("values from select").verifyComplete();
    }

    @Test
    default public void savePointStartsTransaction() {
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> Mono.from((Publisher)connection.createSavepoint("test_savepoint")).then(Mono.fromSupplier(() -> connection.isAutoCommit())), Connection::close).as(StepVerifier::create)).expectNext((Object)false).as("createSavepoint starts a transaction").verifyComplete();
    }

    @Test
    default public void segmentInsertEmitsUpdateCount() {
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> Flux.from((Publisher)connection.createStatement(this.expand(TestStatement.INSERT_VALUE100, new Object[0])).execute()).flatMap(result -> result.flatMap(segment -> Mono.just((Object)((Result.UpdateCount)segment).value()))), Connection::close).as(StepVerifier::create)).expectNext((Object)1L).as("insert of a single row").verifyComplete();
    }

    @Test
    default public void segmentInsertWithFilterCompletesWithoutOnNext() {
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> Flux.from((Publisher)connection.createStatement(this.expand(TestStatement.INSERT_VALUE100, new Object[0])).execute()).flatMap(result -> result.filter(it -> false).flatMap(segment -> Mono.just((Object)false))), Connection::close).as(StepVerifier::create)).as("filter(it -> false) should complete without data signals").verifyComplete();
    }

    @Test
    default public void segmentSelectWithFilterCompletesWithoutOnNext() {
        this.getJdbcOperations().execute(this.expand(TestStatement.INSERT_VALUE100, new Object[0]));
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> Flux.from((Publisher)connection.createStatement(this.expand(TestStatement.SELECT_VALUE, new Object[0])).execute()).flatMap(result -> result.filter(it -> false).flatMap(segment -> Mono.just((Object)false))), Connection::close).as(StepVerifier::create)).as("filter(it -> false) should complete without data signals").verifyComplete();
    }

    @Test
    default public void segmentSelectWithEmitsRow() {
        this.getJdbcOperations().execute(this.expand(TestStatement.INSERT_VALUE100, new Object[0]));
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> Flux.from((Publisher)connection.createStatement(this.expand(TestStatement.SELECT_VALUE, new Object[0])).execute()).flatMap(result -> result.filter(Result.RowSegment.class::isInstance).flatMap(segment -> Mono.just((Object)this.extractColumn(((Result.RowSegment)segment).row())))), Connection::close).as(StepVerifier::create)).expectNext((Object)100).as("test_value from select").verifyComplete();
    }

    @Test
    default public void transactionCommit() {
        this.getJdbcOperations().execute(this.expand(TestStatement.INSERT_VALUE100, new Object[0]));
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> Mono.from((Publisher)connection.beginTransaction()).thenMany((Publisher)Flux.from((Publisher)connection.createStatement(this.expand(TestStatement.SELECT_VALUE, new Object[0])).execute()).flatMap(this::extractColumns)).concatWith((Publisher)Flux.defer(() -> {
            Statement statement = connection.createStatement(this.expand(TestStatement.INSERT_VALUE_PLACEHOLDER, this.getPlaceholder(0)));
            TestKit.bind(statement, this.getIdentifier(0), 200);
            return statement.execute();
        }).flatMap(this::extractRowsUpdated)).concatWith((Publisher)Flux.from((Publisher)connection.createStatement(this.expand(TestStatement.SELECT_VALUE, new Object[0])).execute()).flatMap(this::extractColumns)).concatWith(connection.commitTransaction()).concatWith((Publisher)Flux.from((Publisher)connection.createStatement(this.expand(TestStatement.SELECT_VALUE, new Object[0])).execute()).flatMap(this::extractColumns)), Connection::close).as(StepVerifier::create)).expectNext(TestKit.collectionOf(100)).as("test_value from select").expectNext((Object)1).as("rows inserted").expectNext(TestKit.collectionOf(100, 200)).as("values from select").expectNext(TestKit.collectionOf(100, 200)).as("values from select").verifyComplete();
    }

    @Test
    default public void transactionRollback() {
        this.getJdbcOperations().execute(this.expand(TestStatement.INSERT_VALUE100, new Object[0]));
        ((StepVerifier.FirstStep)Flux.usingWhen((Publisher)this.getConnectionFactory().create(), connection -> Mono.from((Publisher)connection.beginTransaction()).thenMany((Publisher)Flux.from((Publisher)connection.createStatement(this.expand(TestStatement.SELECT_VALUE, new Object[0])).execute()).flatMap(this::extractColumns)).concatWith((Publisher)Flux.defer(() -> {
            Statement statement = connection.createStatement(this.expand(TestStatement.INSERT_VALUE_PLACEHOLDER, this.getPlaceholder(0)));
            TestKit.bind(statement, this.getIdentifier(0), 200);
            return statement.execute();
        }).flatMap(this::extractRowsUpdated)).concatWith((Publisher)Flux.from((Publisher)connection.createStatement(this.expand(TestStatement.SELECT_VALUE, new Object[0])).execute()).flatMap(this::extractColumns)).concatWith(connection.rollbackTransaction()).concatWith((Publisher)Flux.from((Publisher)connection.createStatement(this.expand(TestStatement.SELECT_VALUE, new Object[0])).execute()).flatMap(this::extractColumns)), Connection::close).as(StepVerifier::create)).expectNext(TestKit.collectionOf(100)).as("test_value from select").expectNext((Object)1).as("rows inserted").expectNext(TestKit.collectionOf(100, 200)).as("values from select").expectNext(TestKit.collectionOf(100)).as("test_value from select").verifyComplete();
    }

    @Test
    default public void validate() {
        ((StepVerifier.FirstStep)Mono.from((Publisher)this.getConnectionFactory().create()).flatMapMany(connection -> Flux.concat((Publisher[])new Publisher[]{connection.validate(ValidationDepth.LOCAL), connection.validate(ValidationDepth.REMOTE), connection.close(), connection.validate(ValidationDepth.LOCAL), connection.validate(ValidationDepth.REMOTE)})).as(StepVerifier::create)).expectNext((Object)true).as("successful local validation").expectNext((Object)true).as("successful remote validation").expectNext((Object)false).as("failed local validation after close").expectNext((Object)false).as("failed remote validation after close").verifyComplete();
    }

    public static Statement bind(Statement statement, Object identifier, Object value) {
        Assert.requireNonNull(identifier, "Identifier must not be null");
        if (identifier instanceof String) {
            return statement.bind((String)identifier, value);
        }
        if (identifier instanceof Integer) {
            return statement.bind(((Integer)identifier).intValue(), value);
        }
        throw new IllegalArgumentException(String.format("Identifier %s must be a String or Integer. Was: %s", identifier, identifier.getClass().getName()));
    }

    public static Statement bindNull(Statement statement, Object identifier, Class<?> type) {
        Assert.requireNonNull(identifier, "Identifier must not be null");
        if (identifier instanceof String) {
            return statement.bindNull((String)identifier, type);
        }
        if (identifier instanceof Integer) {
            return statement.bindNull(((Integer)identifier).intValue(), type);
        }
        throw new IllegalArgumentException(String.format("Identifier %s must be a String or Integer. Was: %s", identifier, identifier.getClass().getName()));
    }

    @SafeVarargs
    public static <T> Collection<T> collectionOf(T ... values) {
        return new HashSet<T>(Arrays.asList(values));
    }

    public static Exception captureException(Callable<?> throwingCallable) {
        try {
            throwingCallable.call();
        }
        catch (Exception e) {
            return e;
        }
        throw new IllegalStateException("Callable did not throw an exception.");
    }

    public static enum TestStatement {
        INSERT_VALUE_PLACEHOLDER("INSERT INTO test VALUES(%s)"),
        INSERT_VALUE100("INSERT INTO test VALUES(100)"),
        INSERT_VALUE200("INSERT INTO test VALUES(200)"),
        INSERT_TWO_VALUES_PLACEHOLDER("INSERT INTO test VALUES(%s,%s)"),
        SELECT_VALUE("SELECT test_value FROM test"),
        CREATE_TABLE("CREATE TABLE test ( test_value INTEGER )"),
        DROP_TABLE("DROP TABLE test"),
        SELECT_VALUE_BATCH("SELECT test_value FROM test; SELECT test_value FROM test"),
        INSERT_VALUE_AUTOGENERATED_KEY("INSERT INTO test VALUES(100)"),
        CREATE_TABLE_AUTOGENERATED_KEY("CREATE TABLE test ( id INTEGER IDENTITY,  test_value INTEGER )"),
        INSERT_BLOB_VALUE_PLACEHOLDER("INSERT INTO blob_test VALUES (%s)"),
        CREATE_BLOB_TABLE("CREATE TABLE blob_test ( test_value %s )"),
        DROP_BLOB_TABLE("DROP TABLE blob_test"),
        SELECT_BLOB_VALUE("SELECT test_value FROM blob_test"),
        INSERT_CLOB_VALUE_PLACEHOLDER("INSERT INTO clob_test VALUES (%s)"),
        SELECT_CLOB_VALUE("SELECT test_value FROM clob_test"),
        CREATE_CLOB_TABLE("CREATE TABLE clob_test ( test_value %s )"),
        DROP_CLOB_TABLE("DROP TABLE clob_test"),
        INSERT_TWO_COLUMNS("INSERT INTO test_two_column VALUES (100, 'hello')"),
        SELECT_VALUE_TWO_COLUMNS("SELECT col1 AS test_value, col2 AS test_value FROM test_two_column"),
        SELECT_VALUE_ALIASED_COLUMNS("SELECT col1 AS b, col1 AS c, col1 AS a FROM test_two_column"),
        CREATE_TABLE_TWO_COLUMNS("CREATE TABLE test_two_column ( col1 INTEGER, col2 VARCHAR(100) )"),
        DROP_TABLE_TWO_COLUMNS("DROP TABLE test_two_column");

        private final String sql;

        private TestStatement(String sql) {
            this.sql = sql;
        }

        public String getSql() {
            return this.sql;
        }
    }
}

