/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.spi.test;

import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.RowMetadata;
import io.r2dbc.spi.test.Assert;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;

public final class MockRowMetadata
implements RowMetadata {
    static final Collator COLLATOR;
    private final List<ColumnMetadata> columnMetadatas;
    private final Set<String> contains = new TreeSet<Object>(COLLATOR);

    private MockRowMetadata(List<ColumnMetadata> columnMetadatas) {
        this.columnMetadatas = Assert.requireNonNull(columnMetadatas, "columnMetadatas must not be null");
        for (ColumnMetadata columnMetadata : this.columnMetadatas) {
            this.contains.add(columnMetadata.getName());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MockRowMetadata empty() {
        return MockRowMetadata.builder().build();
    }

    public ColumnMetadata getColumnMetadata(int index) {
        return this.columnMetadatas.get(index);
    }

    public ColumnMetadata getColumnMetadata(String name) {
        Assert.requireNonNull(name, "name must not be null");
        for (ColumnMetadata columnMetadata : this.columnMetadatas) {
            if (!columnMetadata.getName().equalsIgnoreCase(name)) continue;
            return columnMetadata;
        }
        throw new NoSuchElementException(String.format("Column %s not found", name));
    }

    public List<ColumnMetadata> getColumnMetadatas() {
        return this.columnMetadatas;
    }

    public boolean contains(String columnName) {
        return this.contains.contains(columnName);
    }

    public String toString() {
        return "MockRowMetadata{columnMetadatas=" + this.columnMetadatas + '}';
    }

    static {
        Collator collator = Collator.getInstance(Locale.US);
        collator.setStrength(1);
        COLLATOR = collator;
    }

    public static final class Builder {
        private final List<ColumnMetadata> columnMetadatas = new ArrayList<ColumnMetadata>();

        private Builder() {
        }

        public MockRowMetadata build() {
            return new MockRowMetadata(this.columnMetadatas);
        }

        public Builder columnMetadata(ColumnMetadata columnMetadata) {
            Assert.requireNonNull(columnMetadata, "columnMetadata must not be null");
            this.columnMetadatas.add(columnMetadata);
            return this;
        }

        public String toString() {
            return "Builder{columnMetadatas=" + this.columnMetadatas + '}';
        }
    }
}

