/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.net.NetSocket;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.impl.ProtonConnectionImpl;
import io.vertx.proton.impl.ProtonSaslAuthenticator;
import io.vertx.proton.sasl.ProtonSaslMechanism;
import io.vertx.proton.sasl.impl.ProtonSaslMechanismFinderImpl;
import java.util.HashSet;
import java.util.Set;
import javax.security.sasl.SaslException;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Transport;

public class ProtonSaslClientAuthenticatorImpl
implements ProtonSaslAuthenticator {
    private Sasl sasl;
    private final String username;
    private final String password;
    private ProtonSaslMechanism mechanism;
    private Set<String> mechanismsRestriction;
    private Handler<AsyncResult<ProtonConnection>> handler;
    private NetSocket socket;
    private ProtonConnectionImpl connection;

    public ProtonSaslClientAuthenticatorImpl(String username, String password, String[] allowedSaslMechanisms, NetSocket socket, Handler<AsyncResult<ProtonConnection>> handler, ProtonConnectionImpl connection) {
        this.handler = handler;
        this.socket = socket;
        this.connection = connection;
        this.username = username;
        this.password = password;
        if (allowedSaslMechanisms != null) {
            HashSet<String> mechs = new HashSet<String>();
            for (int i = 0; i < allowedSaslMechanisms.length; ++i) {
                String mech = allowedSaslMechanisms[i];
                if (mech.trim().isEmpty()) continue;
                mechs.add(mech);
            }
            if (!mechs.isEmpty()) {
                this.mechanismsRestriction = mechs;
            }
        }
    }

    @Override
    public void init(Transport transport) {
        this.sasl = transport.sasl();
        this.sasl.client();
    }

    @Override
    public boolean process() {
        if (this.sasl == null) {
            throw new IllegalStateException("Init was not called with the associated transport");
        }
        boolean done = false;
        try {
            switch (this.sasl.getState()) {
                case PN_SASL_IDLE: {
                    this.handleSaslInit();
                    break;
                }
                case PN_SASL_STEP: {
                    this.handleSaslStep();
                    break;
                }
                case PN_SASL_FAIL: {
                    done = true;
                    this.handler.handle(Future.failedFuture(new SecurityException("Failed to authenticate")));
                    break;
                }
                case PN_SASL_PASS: {
                    done = true;
                    this.handler.handle(Future.succeededFuture(this.connection));
                    break;
                }
            }
        }
        catch (Exception e) {
            done = true;
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            finally {
                this.handler.handle(Future.failedFuture(e));
            }
        }
        return done;
    }

    private void handleSaslInit() throws SecurityException {
        block4: {
            try {
                String[] remoteMechanisms = this.sasl.getRemoteMechanisms();
                if (remoteMechanisms == null || remoteMechanisms.length == 0) break block4;
                this.mechanism = ProtonSaslMechanismFinderImpl.findMatchingMechanism(this.username, this.password, this.mechanismsRestriction, remoteMechanisms);
                if (this.mechanism != null) {
                    this.mechanism.setUsername(this.username);
                    this.mechanism.setPassword(this.password);
                    this.sasl.setMechanisms(this.mechanism.getName());
                    byte[] response = this.mechanism.getInitialResponse();
                    if (response != null) {
                        this.sasl.send(response, 0, response.length);
                    }
                    break block4;
                }
                throw new SecurityException("Could not find a suitable SASL mechanism for the remote peer using the available credentials.");
            }
            catch (SaslException se) {
                SecurityException sece = new SecurityException("Exception while processing SASL init.", se);
                throw sece;
            }
        }
    }

    private void handleSaslStep() throws SecurityException {
        try {
            if (this.sasl.pending() != 0) {
                byte[] challenge = new byte[this.sasl.pending()];
                this.sasl.recv(challenge, 0, challenge.length);
                byte[] response = this.mechanism.getChallengeResponse(challenge);
                this.sasl.send(response, 0, response.length);
            }
        }
        catch (SaslException se) {
            SecurityException sece = new SecurityException("Exception while processing SASL step.", se);
            throw sece;
        }
    }
}

