/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.amqp;

import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonMessageHandler;
import io.vertx.proton.ProtonReceiver;
import org.apache.qpid.proton.message.Message;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.amqp.AMQPFlowControllerListener;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U4Q!\u0001\u0002\u0001\t1\u0011!#Q'R!\u001acwn^\"p]R\u0014x\u000e\u001c7fe*\u00111\u0001B\u0001\u0005C6\f\bO\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!D\n\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g!\t!r#D\u0001\u0016\u0015\t1b!\u0001\u0005j]R,'O\\1m\u0013\tARCA\u0004M_\u001e<\u0017N\\4\t\u0011i\u0001!\u0011!Q\u0001\nq\t\u0001B]3dK&4XM]\u0002\u0001!\tiB%D\u0001\u001f\u0015\ty\u0002%\u0001\u0004qe>$xN\u001c\u0006\u0003C\t\nQA^3sibT\u0011aI\u0001\u0003S>L!!\n\u0010\u0003\u001dA\u0013x\u000e^8o%\u0016\u001cW-\u001b<fe\"Aq\u0005\u0001B\u0001B\u0003%\u0001&\u0001\u0005mSN$XM\\3s!\tI#&D\u0001\u0003\u0013\tY#A\u0001\u000eB\u001bF\u0003f\t\\8x\u0007>tGO]8mY\u0016\u0014H*[:uK:,'\u000fC\u0003.\u0001\u0011\u0005a&\u0001\u0004=S:LGO\u0010\u000b\u0004_A\n\u0004CA\u0015\u0001\u0011\u0015QB\u00061\u0001\u001d\u0011\u00159C\u00061\u0001)\u0011\u001d\u0019\u0004A1A\u0005\u0016Q\nqb\u0011*F\t&#6k\u0018#F\r\u0006+F\nV\u000b\u0002k=\ta'\b\u0002\u0004Q$1\u0001\b\u0001Q\u0001\u000eU\n\u0001c\u0011*F\t&#6k\u0018#F\r\u0006+F\n\u0016\u0011\t\u000fi\u0002!\u0019!C\u000bw\u0005\t2IU#E\u0013R\u001bv\f\u0016%S\u000bNCu\n\u0014#\u0016\u0003qz\u0011!P\u000f\u0003\u0003QHaa\u0010\u0001!\u0002\u001ba\u0014AE\"S\u000b\u0012KEkU0U\u0011J+5\u000bS(M\t\u0002Bq!\u0011\u0001A\u0002\u0013E!)A\u0003d_VtG/F\u0001D!\tqA)\u0003\u0002F\u001f\t\u0019\u0011J\u001c;\t\u000f\u001d\u0003\u0001\u0019!C\t\u0011\u0006I1m\\;oi~#S-\u001d\u000b\u0003\u00132\u0003\"A\u0004&\n\u0005-{!\u0001B+oSRDq!\u0014$\u0002\u0002\u0003\u00071)A\u0002yIEBaa\u0014\u0001!B\u0013\u0019\u0015AB2pk:$\b\u0005C\u0004R\u0001\u0001\u0007I\u0011\u0003\"\u0002\u000f\r\u0014X\rZ5ug\"91\u000b\u0001a\u0001\n#!\u0016aC2sK\u0012LGo]0%KF$\"!S+\t\u000f5\u0013\u0016\u0011!a\u0001\u0007\"1q\u000b\u0001Q!\n\r\u000b\u0001b\u0019:fI&$8\u000f\t\u0005\u00063\u0002!)AW\u0001\u0005_B,g\u000eF\u0001J\u0011\u0015a\u0006\u0001\"\u0002[\u0003\u0015\u0019Gn\\:f\u0011\u0015q\u0006\u0001\"\u0001[\u0003)\u0011WMZ8sK>\u0003XM\u001c\u0005\u0006A\u0002!\tAW\u0001\fE\u00164wN]3DY>\u001cX\rC\u0003c\u0001\u0011E1-A\u0004bGF,\u0018N]3\u0015\u0007%#\u0017\u000eC\u0003fC\u0002\u0007a-\u0001\u0005eK2Lg/\u001a:z!\tir-\u0003\u0002i=\tq\u0001K]8u_:$U\r\\5wKJL\b\"\u00026b\u0001\u0004Y\u0017aB7fgN\fw-\u001a\t\u0003YFl\u0011!\u001c\u0006\u0003U:T!aH8\u000b\u0005AD\u0011\u0001B9qS\u0012L!A]7\u0003\u000f5+7o]1hK\")A\u000f\u0001C\t5\u0006a\u0011n]:vK\u000e\u0013X\rZ5ug\u0002")
public class AMQPFlowController
implements Logging {
    private final ProtonReceiver receiver;
    private final AMQPFlowControllerListener listener;
    private final int CREDITS_DEFAULT;
    private final int CREDITS_THRESHOLD;
    private int count;
    private int credits;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public final int CREDITS_DEFAULT() {
        return 1000;
    }

    public final int CREDITS_THRESHOLD() {
        return 500;
    }

    public int count() {
        return this.count;
    }

    public void count_$eq(int x$1) {
        this.count = x$1;
    }

    public int credits() {
        return this.credits;
    }

    public void credits_$eq(int x$1) {
        this.credits = x$1;
    }

    public final void open() {
        this.count_$eq(0);
        this.credits_$eq(1000);
        this.receiver.setAutoAccept(false).handler(new ProtonMessageHandler(this){
            private final /* synthetic */ AMQPFlowController $outer;

            public void handle(ProtonDelivery delivery, Message message) {
                this.$outer.acquire(delivery, message);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.beforeOpen();
        this.receiver.setPrefetch(0);
        this.receiver.flow(this.credits());
        this.receiver.open();
    }

    public final void close() {
        this.beforeClose();
        if (Option$.MODULE$.apply((Object)this.receiver).isDefined()) {
            this.receiver.close();
        }
    }

    public void beforeOpen() {
    }

    public void beforeClose() {
    }

    public void acquire(ProtonDelivery delivery, Message message) {
        this.logDebug((Function0<String>)new Serializable(this, delivery){
            public static final long serialVersionUID = 0L;
            private final ProtonDelivery delivery$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Process delivery tag [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new String(this.delivery$1.getTag())}));
            }
            {
                this.delivery$1 = delivery$1;
            }
        });
        this.count_$eq(this.count() + 1);
        this.listener.onAcquire(delivery, message);
        this.issueCredits();
    }

    public void issueCredits() {
        if (this.count() >= this.credits() - 500) {
            int creditsToIssue = this.count();
            this.logDebug((Function0<String>)new Serializable(this, creditsToIssue){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AMQPFlowController $outer;
                private final int creditsToIssue$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Flow: count ", " >= ", " ... issuing ", " credits"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.count()), BoxesRunTime.boxToInteger((int)(this.$outer.credits() - 500)), BoxesRunTime.boxToInteger((int)this.creditsToIssue$1)}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.creditsToIssue$1 = creditsToIssue$1;
                }
            });
            this.receiver.flow(creditsToIssue);
            this.count_$eq(0);
        }
    }

    public AMQPFlowController(ProtonReceiver receiver, AMQPFlowControllerListener listener) {
        this.receiver = receiver;
        this.listener = listener;
        Logging.class.$init$((Logging)this);
        this.count = 0;
        this.credits = 0;
        if (Option$.MODULE$.apply((Object)receiver).isEmpty()) {
            throw new IllegalArgumentException("The receiver instance cannot be null");
        }
        if (Option$.MODULE$.apply((Object)listener).isEmpty()) {
            throw new IllegalArgumentException("The listener instance cannot be null");
        }
    }
}

