/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.amqp;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.proton.ProtonClient;
import io.vertx.proton.ProtonClientOptions;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonReceiver;
import org.apache.qpid.proton.message.Message;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.amqp.AMQPFlowController;
import org.apache.spark.streaming.amqp.AMQPFlowControllerListener;
import org.apache.spark.streaming.receiver.Receiver;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005]d!B\u0001\u0003\u0001\u0011a!\u0001D!N#B\u0013VmY3jm\u0016\u0014(BA\u0002\u0005\u0003\u0011\tW.\u001d9\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<WCA\u0007\u0017'\u0011\u0001abI\u0015\u0011\u0007=\u0011B#D\u0001\u0011\u0015\t\tB!\u0001\u0005sK\u000e,\u0017N^3s\u0013\t\u0019\u0002C\u0001\u0005SK\u000e,\u0017N^3s!\t)b\u0003\u0004\u0001\u0005\u000b]\u0001!\u0019A\r\u0003\u0003Q\u001b\u0001!\u0005\u0002\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t9aj\u001c;iS:<\u0007CA\u000e\"\u0013\t\u0011CDA\u0002B]f\u0004\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0004\u0002\u0011%tG/\u001a:oC2L!\u0001K\u0013\u0003\u000f1{wmZ5oOB\u0011!fK\u0007\u0002\u0005%\u0011AF\u0001\u0002\u001b\u00036\u000b\u0006K\u00127po\u000e{g\u000e\u001e:pY2,'\u000fT5ti\u0016tWM\u001d\u0005\t]\u0001\u0011\t\u0011)A\u0005_\u0005!\u0001n\\:u!\t\u00014G\u0004\u0002\u001cc%\u0011!\u0007H\u0001\u0007!J,G-\u001a4\n\u0005Q*$AB*ue&twM\u0003\u000239!Aq\u0007\u0001B\u0001B\u0003%\u0001(\u0001\u0003q_J$\bCA\u000e:\u0013\tQDDA\u0002J]RD\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006IaL\u0001\bC\u0012$'/Z:t\u0011!q\u0004A!A!\u0002\u0013y\u0014\u0001E7fgN\fw-Z\"p]Z,'\u000f^3s!\u0011Y\u0002I\u0011'\n\u0005\u0005c\"!\u0003$v]\u000e$\u0018n\u001c82!\t\u0019%*D\u0001E\u0015\t)e)A\u0004nKN\u001c\u0018mZ3\u000b\u0005\u001dC\u0015A\u00029s_R|gN\u0003\u0002J\u0011\u0005!\u0011\u000f]5e\u0013\tYEIA\u0004NKN\u001c\u0018mZ3\u0011\u0007miE#\u0003\u0002O9\t1q\n\u001d;j_:D\u0011\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!U,\u0002\u0019M$xN]1hK2+g/\u001a7\u0011\u0005I+V\"A*\u000b\u0005Q3\u0011aB:u_J\fw-Z\u0005\u0003-N\u0013Ab\u0015;pe\u0006<W\rT3wK2L!\u0001\u0015\n\t\u000be\u0003A\u0011\u0001.\u0002\rqJg.\u001b;?)\u0019YF,\u00180`AB\u0019!\u0006\u0001\u000b\t\u000b9B\u0006\u0019A\u0018\t\u000b]B\u0006\u0019\u0001\u001d\t\u000bqB\u0006\u0019A\u0018\t\u000byB\u0006\u0019A \t\u000bAC\u0006\u0019A)\t\u0013\t\u0004\u0001\u0019!a\u0001\n#\u0019\u0017A\u00044m_^\u001cuN\u001c;s_2dWM]\u000b\u0002IB\u0011!&Z\u0005\u0003M\n\u0011!#Q'R!\u001acwn^\"p]R\u0014x\u000e\u001c7fe\"I\u0001\u000e\u0001a\u0001\u0002\u0004%\t\"[\u0001\u0013M2|woQ8oiJ|G\u000e\\3s?\u0012*\u0017\u000f\u0006\u0002k[B\u00111d[\u0005\u0003Yr\u0011A!\u00168ji\"9anZA\u0001\u0002\u0004!\u0017a\u0001=%c!1\u0001\u000f\u0001Q!\n\u0011\fqB\u001a7po\u000e{g\u000e\u001e:pY2,'\u000f\t\u0005\ne\u0002\u0001\r\u00111A\u0005\u0012M\fqaY8oi\u0016DH/F\u0001u!\t)H0D\u0001w\u0015\t9\b0\u0001\u0003d_J,'BA={\u0003\u00151XM\u001d;y\u0015\u0005Y\u0018AA5p\u0013\tihOA\u0004D_:$X\r\u001f;\t\u0015}\u0004\u0001\u0019!a\u0001\n#\t\t!A\u0006d_:$X\r\u001f;`I\u0015\fHc\u00016\u0002\u0004!9aN`A\u0001\u0002\u0004!\bbBA\u0004\u0001\u0001\u0006K\u0001^\u0001\tG>tG/\u001a=uA!Q\u0011\u0010\u0001a\u0001\u0002\u0004%\t\"a\u0003\u0016\u0005\u00055\u0001cA;\u0002\u0010%\u0019\u0011\u0011\u0003<\u0003\u000bY+'\u000f\u001e=\t\u0017\u0005U\u0001\u00011AA\u0002\u0013E\u0011qC\u0001\nm\u0016\u0014H\u000f_0%KF$2A[A\r\u0011%q\u00171CA\u0001\u0002\u0004\ti\u0001\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0015BA\u0007\u0003\u00191XM\u001d;yA!Y\u0011\u0011\u0005\u0001A\u0002\u0003\u0007I\u0011CA\u0012\u0003\u0019\u0019G.[3oiV\u0011\u0011Q\u0005\t\u0005\u0003O\tY#\u0004\u0002\u0002*)\u0011q\t_\u0005\u0005\u0003[\tIC\u0001\u0007Qe>$xN\\\"mS\u0016tG\u000fC\u0006\u00022\u0001\u0001\r\u00111A\u0005\u0012\u0005M\u0012AC2mS\u0016tGo\u0018\u0013fcR\u0019!.!\u000e\t\u00139\fy#!AA\u0002\u0005\u0015\u0002\u0002CA\u001d\u0001\u0001\u0006K!!\n\u0002\u000f\rd\u0017.\u001a8uA!Y\u0011Q\b\u0001A\u0002\u0003\u0007I\u0011CA \u0003)\u0019wN\u001c8fGRLwN\\\u000b\u0003\u0003\u0003\u0002B!a\n\u0002D%!\u0011QIA\u0015\u0005A\u0001&o\u001c;p]\u000e{gN\\3di&|g\u000eC\u0006\u0002J\u0001\u0001\r\u00111A\u0005\u0012\u0005-\u0013AD2p]:,7\r^5p]~#S-\u001d\u000b\u0004U\u00065\u0003\"\u00038\u0002H\u0005\u0005\t\u0019AA!\u0011!\t\t\u0006\u0001Q!\n\u0005\u0005\u0013aC2p]:,7\r^5p]\u0002Bq!!\u0016\u0001\t\u0003\n9&A\u0004p]N#\u0018M\u001d;\u0015\u0003)Dq!a\u0017\u0001\t\u0003\n9&\u0001\u0004p]N#x\u000e\u001d\u0005\b\u0003?\u0002A\u0011BA1\u0003E\u0001(o\\2fgN\u001cuN\u001c8fGRLwN\u001c\u000b\u0004U\u0006\r\u0004\u0002CA\u001f\u0003;\u0002\r!!\u0011\t\u000f\u0005\u001d\u0004\u0001\"\u0011\u0002j\u0005IqN\\!dcVL'/\u001a\u000b\u0006U\u0006-\u0014Q\u000f\u0005\t\u0003[\n)\u00071\u0001\u0002p\u0005AA-\u001a7jm\u0016\u0014\u0018\u0010\u0005\u0003\u0002(\u0005E\u0014\u0002BA:\u0003S\u0011a\u0002\u0015:pi>tG)\u001a7jm\u0016\u0014\u0018\u0010\u0003\u0004F\u0003K\u0002\rA\u0011")
public class AMQPReceiver<T>
extends Receiver<T>
implements Logging,
AMQPFlowControllerListener {
    private final String host;
    private final int port;
    private final String address;
    private final Function1<Message, Option<T>> messageConverter;
    private AMQPFlowController flowController;
    private Context context;
    private Vertx vertx;
    private ProtonClient client;
    private ProtonConnection connection;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public AMQPFlowController flowController() {
        return this.flowController;
    }

    public void flowController_$eq(AMQPFlowController x$1) {
        this.flowController = x$1;
    }

    public Context context() {
        return this.context;
    }

    public void context_$eq(Context x$1) {
        this.context = x$1;
    }

    public Vertx vertx() {
        return this.vertx;
    }

    public void vertx_$eq(Vertx x$1) {
        this.vertx = x$1;
    }

    public ProtonClient client() {
        return this.client;
    }

    public void client_$eq(ProtonClient x$1) {
        this.client = x$1;
    }

    public ProtonConnection connection() {
        return this.connection;
    }

    public void connection_$eq(ProtonConnection x$1) {
        this.connection = x$1;
    }

    public void onStart() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "onStart";
            }
        });
        this.vertx_$eq(Vertx.vertx());
        ProtonClientOptions options = new ProtonClientOptions();
        this.client_$eq(ProtonClient.create(this.vertx()));
        this.client().connect(options, this.host, this.port, new Handler<AsyncResult<ProtonConnection>>(this){
            private final /* synthetic */ AMQPReceiver $outer;

            public void handle(AsyncResult<ProtonConnection> ar) {
                if (ar.succeeded()) {
                    this.$outer.context_$eq(this.$outer.vertx().getOrCreateContext());
                    this.$outer.connection_$eq(ar.result());
                    this.$outer.org$apache$spark$streaming$amqp$AMQPReceiver$$processConnection(this.$outer.connection());
                } else {
                    this.$outer.restart("Connection to AMQP address not established", ar.cause());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void onStop() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "onStop";
            }
        });
        Object object = Option$.MODULE$.apply((Object)this.connection()).isDefined() ? this.connection().close() : BoxedUnit.UNIT;
        if (Option$.MODULE$.apply((Object)this.flowController()).isDefined()) {
            this.flowController().close();
        }
        if (Option$.MODULE$.apply((Object)this.vertx()).isDefined()) {
            this.vertx().close();
        }
    }

    public void org$apache$spark$streaming$amqp$AMQPReceiver$$processConnection(ProtonConnection connection) {
        connection.closeHandler(new Handler<AsyncResult<ProtonConnection>>(this){
            private final /* synthetic */ AMQPReceiver $outer;

            public void handle(AsyncResult<ProtonConnection> ar) {
                if (ar.succeeded()) {
                    this.$outer.restart(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connection closed by peer ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ar.result().getRemoteContainer()})));
                } else {
                    this.$outer.restart("Connection closed by peer", ar.cause());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).disconnectHandler(new Handler<ProtonConnection>(this){
            private final /* synthetic */ AMQPReceiver $outer;

            public void handle(ProtonConnection connection) {
                this.$outer.restart(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Disconnection by peer ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{connection.getRemoteContainer()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).open();
        ProtonReceiver receiver = connection.createReceiver(this.address);
        this.flowController_$eq(new AMQPFlowController(receiver, this));
        this.flowController().open();
    }

    @Override
    public void onAcquire(ProtonDelivery delivery, Message message) {
        this.store(((Option)this.messageConverter.apply((Object)message)).get());
    }

    public AMQPReceiver(String host, int port, String address, Function1<Message, Option<T>> messageConverter, StorageLevel storageLevel) {
        this.host = host;
        this.port = port;
        this.address = address;
        this.messageConverter = messageConverter;
        super(storageLevel);
        Logging.class.$init$((Logging)this);
    }
}

