/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.impl;

import io.vertx.core.Handler;
import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonSender;
import io.vertx.proton.impl.ProtonDeliveryImpl;
import io.vertx.proton.impl.ProtonLinkImpl;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.message.impl.MessageImpl;

public class ProtonSenderImpl
extends ProtonLinkImpl<ProtonSender>
implements ProtonSender {
    private Handler<ProtonSender> drainHandler;
    private boolean anonymousSender;
    private boolean autoSettle;
    private int tag = 1;

    ProtonSenderImpl(Sender sender) {
        super(sender);
    }

    private Sender sender() {
        return (Sender)this.link;
    }

    @Override
    public ProtonDelivery send(Message message) {
        return this.send(message, null);
    }

    @Override
    public ProtonDelivery send(Message message, Handler<ProtonDelivery> onUpdated) {
        return this.send(this.generateTag(), message, onUpdated);
    }

    private byte[] generateTag() {
        return String.valueOf(this.tag++).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public ProtonDelivery send(byte[] tag, Message message) {
        return this.send(tag, message, null);
    }

    @Override
    public ProtonDelivery send(byte[] tag, Message message, Handler<ProtonDelivery> onUpdated) {
        if (this.anonymousSender && message.getAddress() == null) {
            throw new IllegalArgumentException("Message must have an address when using anonymous sender.");
        }
        Delivery delivery = this.sender().delivery(tag);
        MessageImpl msg = (MessageImpl)message;
        int BUFFER_SIZE = 1024;
        byte[] encodedMessage = new byte[BUFFER_SIZE];
        int len = msg.encode2(encodedMessage, 0, BUFFER_SIZE);
        if (len > encodedMessage.length) {
            encodedMessage = new byte[len];
            msg.encode(encodedMessage, 0, len);
        }
        this.sender().send(encodedMessage, 0, len);
        if (this.link.getSenderSettleMode() == SenderSettleMode.SETTLED) {
            delivery.settle();
        }
        this.sender().advance();
        ProtonDeliveryImpl protonDeliveryImpl = new ProtonDeliveryImpl(delivery);
        if (onUpdated != null) {
            protonDeliveryImpl.setAutoSettle(this.autoSettle);
            protonDeliveryImpl.handler(onUpdated);
        } else {
            protonDeliveryImpl.setAutoSettle(true);
        }
        this.getSession().getConnectionImpl().flush();
        return protonDeliveryImpl;
    }

    @Override
    public boolean isAutoSettle() {
        return this.autoSettle;
    }

    @Override
    public ProtonSender setAutoSettle(boolean autoSettle) {
        this.autoSettle = autoSettle;
        return this;
    }

    boolean isAnonymousSender() {
        return this.anonymousSender;
    }

    void setAnonymousSender(boolean anonymousSender) {
        this.anonymousSender = anonymousSender;
    }

    @Override
    protected ProtonSenderImpl self() {
        return this;
    }

    @Override
    public boolean sendQueueFull() {
        return this.link.getRemoteCredit() <= 0;
    }

    @Override
    public ProtonSender sendQueueDrainHandler(Handler<ProtonSender> drainHandler) {
        this.drainHandler = drainHandler;
        this.fireLinkFlow();
        return this;
    }

    @Override
    void fireLinkFlow() {
        if (this.link.getRemoteCredit() > 0 && this.drainHandler != null) {
            this.drainHandler.handle(this);
        }
    }
}

