/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.reactor.impl;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.reactor.Selectable;
import org.apache.qpid.proton.reactor.Selector;
import org.apache.qpid.proton.reactor.impl.IO;
import org.apache.qpid.proton.reactor.impl.SelectableImpl;

class SelectorImpl
implements Selector {
    private final java.nio.channels.Selector selector;
    private final HashSet<Selectable> selectables = new HashSet();
    private final HashSet<Selectable> readable = new HashSet();
    private final HashSet<Selectable> writeable = new HashSet();
    private final HashSet<Selectable> expired = new HashSet();
    private final HashSet<Selectable> error = new HashSet();

    protected SelectorImpl(IO io) throws IOException {
        this.selector = io.selector();
    }

    @Override
    public void add(Selectable selectable) throws IOException {
        if (selectable.getChannel() != null) {
            selectable.getChannel().configureBlocking(false);
            SelectionKey key = selectable.getChannel().register(this.selector, 0);
            key.attach(selectable);
        }
        this.selectables.add(selectable);
        this.update(selectable);
    }

    @Override
    public void update(Selectable selectable) {
        if (selectable.getChannel() != null) {
            int interestedOps = 0;
            if (selectable.getChannel() instanceof SocketChannel && ((SocketChannel)selectable.getChannel()).isConnectionPending()) {
                interestedOps |= 8;
            } else {
                if (selectable.isReading()) {
                    interestedOps = selectable.getChannel() instanceof ServerSocketChannel ? (interestedOps |= 0x10) : (interestedOps |= 1);
                }
                if (selectable.isWriting()) {
                    interestedOps |= 4;
                }
            }
            SelectionKey key = selectable.getChannel().keyFor(this.selector);
            key.interestOps(interestedOps);
        }
    }

    @Override
    public void remove(Selectable selectable) {
        SelectionKey key;
        if (selectable.getChannel() != null && (key = selectable.getChannel().keyFor(this.selector)) != null) {
            key.cancel();
            key.attach(null);
        }
        this.selectables.remove(selectable);
    }

    @Override
    public void select(long timeout) throws IOException {
        long now = System.currentTimeMillis();
        if (timeout > 0L) {
            long deadline = 0L;
            for (Selectable selectable : this.selectables) {
                long d = selectable.getDeadline();
                if (d <= 0L) continue;
                deadline = deadline == 0L ? d : Math.min(deadline, d);
            }
            if (deadline > 0L) {
                long delta = deadline - now;
                if (delta < 0L) {
                    timeout = 0L;
                } else if (delta < timeout) {
                    timeout = delta;
                }
            }
        }
        this.error.clear();
        long awoken = 0L;
        if (timeout > 0L) {
            for (long remainingTimeout = timeout; remainingTimeout > 0L; remainingTimeout -= awoken - now) {
                this.selector.select(remainingTimeout);
                awoken = System.currentTimeMillis();
                Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                while (iterator.hasNext()) {
                    SelectionKey key = iterator.next();
                    if (!key.isConnectable()) continue;
                    try {
                        ((SocketChannel)key.channel()).finishConnect();
                        this.update((Selectable)key.attachment());
                    }
                    catch (IOException ioException) {
                        SelectableImpl selectable = (SelectableImpl)key.attachment();
                        ErrorCondition condition = new ErrorCondition();
                        condition.setCondition(Symbol.getSymbol("proton:io"));
                        condition.setDescription(ioException.getMessage());
                        Transport transport = selectable.getTransport();
                        if (transport != null) {
                            transport.setCondition(condition);
                            transport.close_tail();
                            transport.close_head();
                            transport.pop(transport.pending());
                        }
                        this.error.add(selectable);
                    }
                    iterator.remove();
                }
                if (this.selector.selectedKeys().isEmpty()) {
                    continue;
                }
                break;
            }
        } else {
            this.selector.selectNow();
            awoken = System.currentTimeMillis();
        }
        this.readable.clear();
        this.writeable.clear();
        this.expired.clear();
        for (SelectionKey key : this.selector.selectedKeys()) {
            Selectable selectable = (Selectable)key.attachment();
            if (key.isReadable()) {
                this.readable.add(selectable);
            }
            if (key.isAcceptable()) {
                this.readable.add(selectable);
            }
            if (!key.isWritable()) continue;
            this.writeable.add(selectable);
        }
        this.selector.selectedKeys().clear();
        for (Selectable selectable : this.selectables) {
            long deadline = selectable.getDeadline();
            if (deadline <= 0L || awoken < deadline) continue;
            this.expired.add(selectable);
        }
    }

    @Override
    public Iterator<Selectable> readable() {
        return this.readable.iterator();
    }

    @Override
    public Iterator<Selectable> writeable() {
        return this.writeable.iterator();
    }

    @Override
    public Iterator<Selectable> expired() {
        return this.expired.iterator();
    }

    @Override
    public Iterator<Selectable> error() {
        return this.error.iterator();
    }

    @Override
    public void free() {
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

