/*
 * Decompiled with CFR 0.152.
 */
package io.radanalytics.streaming.amqp;

import io.radanalytics.streaming.amqp.AMQPFlowControllerListener;
import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonMessageHandler;
import io.vertx.proton.ProtonReceiver;
import org.apache.qpid.proton.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001i4A!\u0001\u0002\u0001\u0017\t\u0011\u0012)T)Q\r2|woQ8oiJ|G\u000e\\3s\u0015\t\u0019A!\u0001\u0003b[F\u0004(BA\u0003\u0007\u0003%\u0019HO]3b[&twM\u0003\u0002\b\u0011\u0005a!/\u00193b]\u0006d\u0017\u0010^5dg*\t\u0011\"\u0001\u0002j_\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\"A1\u0003\u0001B\u0001B\u0003%A#\u0001\u0005sK\u000e,\u0017N^3s!\t)\"$D\u0001\u0017\u0015\t9\u0002$\u0001\u0004qe>$xN\u001c\u0006\u00033!\tQA^3sibL!a\u0007\f\u0003\u001dA\u0013x\u000e^8o%\u0016\u001cW-\u001b<fe\"AQ\u0004\u0001B\u0001B\u0003%a$\u0001\u0005mSN$XM\\3s!\ty\u0002%D\u0001\u0003\u0013\t\t#A\u0001\u000eB\u001bF\u0003f\t\\8x\u0007>tGO]8mY\u0016\u0014H*[:uK:,'\u000fC\u0003$\u0001\u0011\u0005A%\u0001\u0004=S:LGO\u0010\u000b\u0004K\u0019:\u0003CA\u0010\u0001\u0011\u0015\u0019\"\u00051\u0001\u0015\u0011\u0015i\"\u00051\u0001\u001f\u0011\u001dI\u0003A1A\u0005\u0016)\nqb\u0011*F\t&#6k\u0018#F\r\u0006+F\nV\u000b\u0002W=\tA&\b\u0002\u0004Q$1a\u0006\u0001Q\u0001\u000e-\n\u0001c\u0011*F\t&#6k\u0018#F\r\u0006+F\n\u0016\u0011\t\u000fA\u0002!\u0019!C\u000bc\u0005\t2IU#E\u0013R\u001bv\f\u0016%S\u000bNCu\n\u0014#\u0016\u0003Iz\u0011aM\u000f\u0003\u0003QHa!\u000e\u0001!\u0002\u001b\u0011\u0014AE\"S\u000b\u0012KEkU0U\u0011J+5\u000bS(M\t\u0002Bqa\u000e\u0001A\u0002\u0013E\u0001(A\u0003d_VtG/F\u0001:!\ti!(\u0003\u0002<\u001d\t\u0019\u0011J\u001c;\t\u000fu\u0002\u0001\u0019!C\t}\u0005I1m\\;oi~#S-\u001d\u000b\u0003\u007f\t\u0003\"!\u0004!\n\u0005\u0005s!\u0001B+oSRDqa\u0011\u001f\u0002\u0002\u0003\u0007\u0011(A\u0002yIEBa!\u0012\u0001!B\u0013I\u0014AB2pk:$\b\u0005C\u0004H\u0001\u0001\u0007I\u0011\u0003\u001d\u0002\u000f\r\u0014X\rZ5ug\"9\u0011\n\u0001a\u0001\n#Q\u0015aC2sK\u0012LGo]0%KF$\"aP&\t\u000f\rC\u0015\u0011!a\u0001s!1Q\n\u0001Q!\ne\n\u0001b\u0019:fI&$8\u000f\t\u0005\b\u001f\u0002\u0011\r\u0011\"\u0003Q\u0003\rawnZ\u000b\u0002#B\u0011!kV\u0007\u0002'*\u0011A+V\u0001\u0006g24GG\u001b\u0006\u0002-\u0006\u0019qN]4\n\u0005a\u001b&A\u0002'pO\u001e,'\u000f\u0003\u0004[\u0001\u0001\u0006I!U\u0001\u0005Y><\u0007\u0005C\u0003]\u0001\u0011\u0015Q,\u0001\u0003pa\u0016tG#A \t\u000b}\u0003AQA/\u0002\u000b\rdwn]3\t\u000b\u0005\u0004A\u0011A/\u0002\u0015\t,gm\u001c:f\u001fB,g\u000eC\u0003d\u0001\u0011\u0005Q,A\u0006cK\u001a|'/Z\"m_N,\u0007\"B3\u0001\t#1\u0017aB1dcVL'/\u001a\u000b\u0004\u007f\u001dd\u0007\"\u00025e\u0001\u0004I\u0017\u0001\u00033fY&4XM]=\u0011\u0005UQ\u0017BA6\u0017\u00059\u0001&o\u001c;p]\u0012+G.\u001b<fefDQ!\u001c3A\u00029\fq!\\3tg\u0006<W\r\u0005\u0002pm6\t\u0001O\u0003\u0002nc*\u0011qC\u001d\u0006\u0003gR\fA!\u001d9jI*\u0011Q/V\u0001\u0007CB\f7\r[3\n\u0005]\u0004(aB'fgN\fw-\u001a\u0005\u0006s\u0002!\t\"X\u0001\rSN\u001cX/Z\"sK\u0012LGo\u001d")
public class AMQPFlowController {
    private final ProtonReceiver receiver;
    private final AMQPFlowControllerListener listener;
    private final int CREDITS_DEFAULT;
    private final int CREDITS_THRESHOLD;
    private int count;
    private int credits;
    private final Logger log;

    public final int CREDITS_DEFAULT() {
        return 1000;
    }

    public final int CREDITS_THRESHOLD() {
        return 500;
    }

    public int count() {
        return this.count;
    }

    public void count_$eq(int x$1) {
        this.count = x$1;
    }

    public int credits() {
        return this.credits;
    }

    public void credits_$eq(int x$1) {
        this.credits = x$1;
    }

    private Logger log() {
        return this.log;
    }

    public final void open() {
        this.count_$eq(0);
        this.credits_$eq(1000);
        this.receiver.setAutoAccept(false).handler(new ProtonMessageHandler(this){
            private final /* synthetic */ AMQPFlowController $outer;

            public void handle(ProtonDelivery delivery, Message message) {
                this.$outer.acquire(delivery, message);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.beforeOpen();
        this.receiver.setPrefetch(0);
        this.receiver.flow(this.credits());
        this.receiver.open();
    }

    public final void close() {
        this.beforeClose();
        if (Option$.MODULE$.apply((Object)this.receiver).isDefined()) {
            this.receiver.close();
        }
    }

    public void beforeOpen() {
    }

    public void beforeClose() {
    }

    public void acquire(ProtonDelivery delivery, Message message) {
        this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Process delivery tag [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new String(delivery.getTag())})));
        this.count_$eq(this.count() + 1);
        this.listener.onAcquire(delivery, message);
        this.issueCredits();
    }

    public void issueCredits() {
        if (this.count() >= this.credits() - 500) {
            int creditsToIssue = this.count();
            this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Flow: count ", " >= ", " ... issuing ", " credits"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.count()), BoxesRunTime.boxToInteger((int)(this.credits() - 500)), BoxesRunTime.boxToInteger((int)creditsToIssue)})));
            this.receiver.flow(creditsToIssue);
            this.count_$eq(0);
        }
    }

    public AMQPFlowController(ProtonReceiver receiver, AMQPFlowControllerListener listener) {
        this.receiver = receiver;
        this.listener = listener;
        this.count = 0;
        this.credits = 0;
        this.log = LoggerFactory.getLogger(this.getClass());
        if (Option$.MODULE$.apply((Object)receiver).isEmpty()) {
            throw new IllegalArgumentException("The receiver instance cannot be null");
        }
        if (Option$.MODULE$.apply((Object)listener).isEmpty()) {
            throw new IllegalArgumentException("The listener instance cannot be null");
        }
    }
}

