/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.proton.ProtonHelper;
import io.vertx.proton.ProtonLink;
import io.vertx.proton.ProtonQoS;
import io.vertx.proton.impl.ProtonSessionImpl;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.amqp.transport.Source;
import org.apache.qpid.proton.amqp.transport.Target;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Link;

abstract class ProtonLinkImpl<T extends ProtonLink<T>>
implements ProtonLink<T> {
    protected final Link link;
    private Handler<AsyncResult<T>> openHandler;
    private Handler<AsyncResult<T>> closeHandler;

    ProtonLinkImpl(Link link) {
        this.link = link;
        this.link.setContext(this);
        this.setQoS(this.getRemoteQoS());
    }

    protected abstract T self();

    @Override
    public ProtonSessionImpl getSession() {
        return (ProtonSessionImpl)this.link.getSession().getContext();
    }

    @Override
    public ErrorCondition getCondition() {
        return this.link.getCondition();
    }

    public int getCredit() {
        return this.link.getCredit();
    }

    public boolean getDrain() {
        return this.link.getDrain();
    }

    public EndpointState getLocalState() {
        return this.link.getLocalState();
    }

    public String getName() {
        return this.link.getName();
    }

    @Override
    public ErrorCondition getRemoteCondition() {
        return this.link.getRemoteCondition();
    }

    public int getRemoteCredit() {
        return this.link.getRemoteCredit();
    }

    public EndpointState getRemoteState() {
        return this.link.getRemoteState();
    }

    @Override
    public Target getRemoteTarget() {
        return this.link.getRemoteTarget();
    }

    @Override
    public Target getTarget() {
        return this.link.getTarget();
    }

    @Override
    public T setTarget(Target target) {
        this.link.setTarget(target);
        return this.self();
    }

    @Override
    public Source getRemoteSource() {
        return this.link.getRemoteSource();
    }

    @Override
    public Source getSource() {
        return this.link.getSource();
    }

    @Override
    public T setSource(Source source) {
        this.link.setSource(source);
        return this.self();
    }

    public int getUnsettled() {
        return this.link.getUnsettled();
    }

    public int getQueued() {
        return this.link.getQueued();
    }

    public boolean advance() {
        return this.link.advance();
    }

    public int drained() {
        return this.link.drained();
    }

    public boolean detached() {
        return this.link.detached();
    }

    public Delivery delivery(byte[] tag, int offset, int length) {
        return this.link.delivery(tag, offset, length);
    }

    public Delivery current() {
        return this.link.current();
    }

    @Override
    public T setCondition(ErrorCondition condition) {
        this.link.setCondition(condition);
        return this.self();
    }

    public Delivery delivery(byte[] tag) {
        return this.link.delivery(tag);
    }

    @Override
    public T open() {
        this.link.open();
        this.getSession().getConnectionImpl().flush();
        return this.self();
    }

    @Override
    public T close() {
        this.link.close();
        this.getSession().getConnectionImpl().flush();
        return this.self();
    }

    public T detach() {
        this.link.detach();
        this.getSession().getConnectionImpl().flush();
        return this.self();
    }

    @Override
    public T openHandler(Handler<AsyncResult<T>> openHandler) {
        this.openHandler = openHandler;
        return this.self();
    }

    @Override
    public T closeHandler(Handler<AsyncResult<T>> closeHandler) {
        this.closeHandler = closeHandler;
        return this.self();
    }

    @Override
    public boolean isOpen() {
        return this.getLocalState() == EndpointState.ACTIVE;
    }

    @Override
    public ProtonQoS getQoS() {
        if (this.link.getSenderSettleMode() == SenderSettleMode.SETTLED) {
            return ProtonQoS.AT_MOST_ONCE;
        }
        return ProtonQoS.AT_LEAST_ONCE;
    }

    @Override
    public ProtonQoS getRemoteQoS() {
        if (this.link.getRemoteSenderSettleMode() == SenderSettleMode.SETTLED) {
            return ProtonQoS.AT_MOST_ONCE;
        }
        return ProtonQoS.AT_LEAST_ONCE;
    }

    @Override
    public T setQoS(ProtonQoS qos) {
        if (qos == null) {
            throw new IllegalArgumentException("Value must be specified");
        }
        switch (qos) {
            case AT_MOST_ONCE: {
                this.link.setSenderSettleMode(SenderSettleMode.SETTLED);
                this.link.setReceiverSettleMode(ReceiverSettleMode.FIRST);
                break;
            }
            case AT_LEAST_ONCE: {
                this.link.setSenderSettleMode(SenderSettleMode.UNSETTLED);
                this.link.setReceiverSettleMode(ReceiverSettleMode.FIRST);
            }
        }
        return this.self();
    }

    void fireRemoteOpen() {
        if (this.openHandler != null) {
            this.openHandler.handle(ProtonHelper.future(this.self(), this.getRemoteCondition()));
        }
    }

    void fireRemoteClose() {
        if (this.closeHandler != null) {
            this.closeHandler.handle(ProtonHelper.future(this.self(), this.getRemoteCondition()));
        }
    }

    void fireLinkFlow() {
    }
}

