/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Parcelable;
import io.radar.sdk.Radar;
import io.radar.sdk.model.RadarEvent;
import io.radar.sdk.model.RadarUser;
import java.text.ParseException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H&J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H&J+\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH&\u00a2\u0006\u0002\u0010\u001cJ \u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH&J\u0018\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 H&J\u0018\u0010!\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006#"}, d2={"Lio/radar/sdk/RadarReceiver;", "Landroid/content/BroadcastReceiver;", "()V", "handleError", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "handleLocation", "handleLog", "handleSuccess", "onClientLocationUpdated", "location", "Landroid/location/Location;", "stopped", "", "source", "Lio/radar/sdk/Radar$RadarLocationSource;", "onError", "status", "Lio/radar/sdk/Radar$RadarStatus;", "onEventsReceived", "events", "", "Lio/radar/sdk/model/RadarEvent;", "user", "Lio/radar/sdk/model/RadarUser;", "(Landroid/content/Context;[Lio/radar/sdk/model/RadarEvent;Lio/radar/sdk/model/RadarUser;)V", "onLocationUpdated", "onLog", "message", "", "onReceive", "Companion", "sdk_release"})
public abstract class RadarReceiver
extends BroadcastReceiver {
    @NotNull
    public static final String ACTION_RECEIVED = "io.radar.sdk.RECEIVED";
    @NotNull
    public static final String EXTRA_RESPONSE = "response";
    @NotNull
    public static final String EXTRA_LOCATION = "location";
    @NotNull
    public static final String EXTRA_STOPPED = "stopped";
    @NotNull
    public static final String EXTRA_SOURCE = "source";
    @NotNull
    public static final String EXTRA_STATUS = "status";
    @NotNull
    public static final String EXTRA_MESSAGE = "message";
    public static final Companion Companion = new Companion(null);

    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        if (Intrinsics.areEqual((Object)intent.getAction(), (Object)ACTION_RECEIVED)) {
            if (intent.hasExtra(EXTRA_LOCATION) && intent.hasExtra(EXTRA_RESPONSE)) {
                this.handleSuccess(context, intent);
            } else if (intent.hasExtra(EXTRA_LOCATION) && intent.hasExtra(EXTRA_STOPPED) && intent.hasExtra(EXTRA_SOURCE)) {
                this.handleLocation(context, intent);
            } else if (intent.hasExtra(EXTRA_STATUS)) {
                this.handleError(context, intent);
            } else if (intent.hasExtra(EXTRA_MESSAGE)) {
                this.handleLog(context, intent);
            }
        }
    }

    private final void handleSuccess(Context context, Intent intent) {
        String res = intent.getStringExtra(EXTRA_RESPONSE);
        Location location = (Location)intent.getParcelableExtra(EXTRA_LOCATION);
        if (res != null && location != null) {
            try {
                JSONObject response = new JSONObject(res);
                JSONArray eventsArr = response.getJSONArray("events");
                RadarEvent[] events = RadarEvent.Companion.fromJson(eventsArr);
                RadarUser user = RadarUser.Companion.fromJson(response.getJSONObject("user"));
                if (user != null) {
                    if (events != null) {
                        RadarEvent[] radarEventArray = events;
                        boolean bl = false;
                        RadarEvent[] radarEventArray2 = radarEventArray;
                        boolean bl2 = false;
                        if (!(radarEventArray2.length == 0)) {
                            this.onEventsReceived(context, events, user);
                        }
                    }
                    this.onLocationUpdated(context, location, user);
                }
            }
            catch (JSONException e) {
                this.onError(context, Radar.RadarStatus.ERROR_UNKNOWN);
            }
            catch (ParseException e) {
                this.onError(context, Radar.RadarStatus.ERROR_UNKNOWN);
            }
        }
    }

    private final void handleLocation(Context context, Intent intent) {
        Radar.RadarLocationSource source;
        Location location = (Location)intent.getParcelableExtra(EXTRA_LOCATION);
        boolean stopped = intent.getBooleanExtra(EXTRA_STOPPED, false);
        int sourceIndex = intent.getIntExtra(EXTRA_SOURCE, -1);
        Radar.RadarLocationSource[] sourceValues = Radar.RadarLocationSource.values();
        int n = sourceIndex;
        int n2 = n;
        Radar.RadarLocationSource radarLocationSource = source = 0 <= n2 && sourceValues.length > n2 ? sourceValues[sourceIndex] : Radar.RadarLocationSource.UNKNOWN;
        if (location != null) {
            this.onClientLocationUpdated(context, location, stopped, source);
        }
    }

    private final void handleError(Context context, Intent intent) {
        Radar.RadarStatus status;
        int statusIndex = intent.getIntExtra(EXTRA_STATUS, -1);
        Radar.RadarStatus[] statusValues = Radar.RadarStatus.values();
        int n = statusIndex;
        int n2 = n;
        Radar.RadarStatus radarStatus = status = 0 <= n2 && statusValues.length > n2 ? statusValues[statusIndex] : Radar.RadarStatus.ERROR_UNKNOWN;
        if (status != Radar.RadarStatus.SUCCESS && status != Radar.RadarStatus.ERROR_UNKNOWN) {
            this.onError(context, status);
        }
    }

    private final void handleLog(Context context, Intent intent) {
        String message = intent.getStringExtra(EXTRA_MESSAGE);
        if (message != null) {
            this.onLog(context, message);
        }
    }

    public abstract void onEventsReceived(@NotNull Context var1, @NotNull RadarEvent[] var2, @NotNull RadarUser var3);

    public abstract void onLocationUpdated(@NotNull Context var1, @NotNull Location var2, @NotNull RadarUser var3);

    public abstract void onClientLocationUpdated(@NotNull Context var1, @NotNull Location var2, boolean var3, @NotNull Radar.RadarLocationSource var4);

    public abstract void onError(@NotNull Context var1, @NotNull Radar.RadarStatus var2);

    public abstract void onLog(@NotNull Context var1, @NotNull String var2);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ%\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u001aJ\u001d\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/radar/sdk/RadarReceiver$Companion;", "", "()V", "ACTION_RECEIVED", "", "EXTRA_LOCATION", "EXTRA_MESSAGE", "EXTRA_RESPONSE", "EXTRA_SOURCE", "EXTRA_STATUS", "EXTRA_STOPPED", "createErrorIntent", "Landroid/content/Intent;", "status", "Lio/radar/sdk/Radar$RadarStatus;", "createErrorIntent$sdk_release", "createLocationIntent", "location", "Landroid/location/Location;", "stopped", "", "source", "Lio/radar/sdk/Radar$RadarLocationSource;", "createLocationIntent$sdk_release", "createLogIntent", "message", "createLogIntent$sdk_release", "createSuccessIntent", "res", "Lorg/json/JSONObject;", "createSuccessIntent$sdk_release", "sdk_release"})
    public static final class Companion {
        @NotNull
        public final Intent createSuccessIntent$sdk_release(@NotNull JSONObject res, @NotNull Location location) {
            Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
            Intrinsics.checkParameterIsNotNull((Object)location, (String)RadarReceiver.EXTRA_LOCATION);
            Intent intent = new Intent(RadarReceiver.ACTION_RECEIVED);
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$apply = intent;
            boolean bl3 = false;
            $this$apply.putExtra(RadarReceiver.EXTRA_RESPONSE, res.toString());
            $this$apply.putExtra(RadarReceiver.EXTRA_LOCATION, (Parcelable)location);
            return intent;
        }

        @NotNull
        public final Intent createLocationIntent$sdk_release(@NotNull Location location, boolean stopped, @NotNull Radar.RadarLocationSource source) {
            Intrinsics.checkParameterIsNotNull((Object)location, (String)RadarReceiver.EXTRA_LOCATION);
            Intrinsics.checkParameterIsNotNull((Object)((Object)source), (String)RadarReceiver.EXTRA_SOURCE);
            Intent intent = new Intent(RadarReceiver.ACTION_RECEIVED);
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$apply = intent;
            boolean bl3 = false;
            $this$apply.putExtra(RadarReceiver.EXTRA_LOCATION, (Parcelable)location);
            $this$apply.putExtra(RadarReceiver.EXTRA_STOPPED, stopped);
            $this$apply.putExtra(RadarReceiver.EXTRA_SOURCE, source.ordinal());
            return intent;
        }

        @NotNull
        public final Intent createErrorIntent$sdk_release(@NotNull Radar.RadarStatus status) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)RadarReceiver.EXTRA_STATUS);
            Intent intent = new Intent(RadarReceiver.ACTION_RECEIVED);
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$apply = intent;
            boolean bl3 = false;
            $this$apply.putExtra(RadarReceiver.EXTRA_STATUS, status.ordinal());
            return intent;
        }

        @NotNull
        public final Intent createLogIntent$sdk_release(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)RadarReceiver.EXTRA_MESSAGE);
            Intent intent = new Intent(RadarReceiver.ACTION_RECEIVED);
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$apply = intent;
            boolean bl3 = false;
            $this$apply.putExtra(RadarReceiver.EXTRA_MESSAGE, message);
            return intent;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

