/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.net.Uri;
import android.os.Build;
import android.os.SystemClock;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarApiHelper;
import io.radar.sdk.RadarReceiver;
import io.radar.sdk.RadarSettings;
import io.radar.sdk.RadarState;
import io.radar.sdk.RadarTrackingOptions;
import io.radar.sdk.RadarTripOptions;
import io.radar.sdk.RadarUtils;
import io.radar.sdk.model.RadarAddress;
import io.radar.sdk.model.RadarContext;
import io.radar.sdk.model.RadarEvent;
import io.radar.sdk.model.RadarGeofence;
import io.radar.sdk.model.RadarPlace;
import io.radar.sdk.model.RadarPoint;
import io.radar.sdk.model.RadarRoutes;
import io.radar.sdk.model.RadarTrip;
import io.radar.sdk.model.RadarUser;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001:\bXYZ[\\]^_B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J-\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u001d\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0017J\r\u0010\u0018\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0019J\u001d\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJC\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00102\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020'H\u0000\u00a2\u0006\u0002\b(J\u001c\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0*2\u0006\u0010+\u001a\u00020\u000eH\u0002J\u0015\u0010,\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020-H\u0000\u00a2\u0006\u0002\b.J\u001d\u0010/\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b0JK\u00101\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u00122\u000e\u00103\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u0001042\b\u00105\u001a\u0004\u0018\u0001062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u000207H\u0000\u00a2\u0006\u0004\b8\u00109Ja\u0010:\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u00122\u000e\u0010;\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u0001042\u000e\u0010<\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u0001042\u000e\u0010=\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u0001042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020>H\u0000\u00a2\u0006\u0004\b?\u0010@JA\u0010A\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u00122\u000e\u00103\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u0001042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020BH\u0000\u00a2\u0006\u0004\bC\u0010DJA\u0010E\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020G2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020G2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010LH\u0000\u00a2\u0006\u0002\bMJ\u0015\u0010N\u001a\u00020\f2\u0006\u0010O\u001a\u00020PH\u0000\u00a2\u0006\u0002\bQJ)\u0010R\u001a\u00020\f2\u0006\u0010S\u001a\u00020\u000e2\u0006\u0010T\u001a\u00020U2\n\b\u0002\u0010V\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0002\bWR\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lio/radar/sdk/RadarApiClient;", "", "context", "Landroid/content/Context;", "apiHelper", "Lio/radar/sdk/RadarApiHelper;", "(Landroid/content/Context;Lio/radar/sdk/RadarApiHelper;)V", "getApiHelper$sdk_release", "()Lio/radar/sdk/RadarApiHelper;", "setApiHelper$sdk_release", "(Lio/radar/sdk/RadarApiHelper;)V", "autocomplete", "", "query", "", "near", "Landroid/location/Location;", "limit", "", "callback", "Lio/radar/sdk/RadarApiClient$RadarGeocodeApiCallback;", "autocomplete$sdk_release", "geocode", "geocode$sdk_release", "getConfig", "getConfig$sdk_release", "getContext", "location", "Lio/radar/sdk/RadarApiClient$RadarContextApiCallback;", "getContext$sdk_release", "getDistance", "origin", "destination", "modes", "Ljava/util/EnumSet;", "Lio/radar/sdk/Radar$RadarRouteMode;", "units", "Lio/radar/sdk/Radar$RadarRouteUnits;", "geometryPoints", "Lio/radar/sdk/RadarApiClient$RadarDistanceApiCallback;", "getDistance$sdk_release", "headers", "", "publishableKey", "ipGeocode", "Lio/radar/sdk/RadarApiClient$RadarIpGeocodeApiCallback;", "ipGeocode$sdk_release", "reverseGeocode", "reverseGeocode$sdk_release", "searchGeofences", "radius", "tags", "", "metadata", "Lorg/json/JSONObject;", "Lio/radar/sdk/RadarApiClient$RadarSearchGeofencesApiCallback;", "searchGeofences$sdk_release", "(Landroid/location/Location;I[Ljava/lang/String;Lorg/json/JSONObject;Ljava/lang/Integer;Lio/radar/sdk/RadarApiClient$RadarSearchGeofencesApiCallback;)V", "searchPlaces", "chains", "categories", "groups", "Lio/radar/sdk/RadarApiClient$RadarSearchPlacesApiCallback;", "searchPlaces$sdk_release", "(Landroid/location/Location;I[Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;Ljava/lang/Integer;Lio/radar/sdk/RadarApiClient$RadarSearchPlacesApiCallback;)V", "searchPoints", "Lio/radar/sdk/RadarApiClient$RadarSearchPointsApiCallback;", "searchPoints$sdk_release", "(Landroid/location/Location;I[Ljava/lang/String;Ljava/lang/Integer;Lio/radar/sdk/RadarApiClient$RadarSearchPointsApiCallback;)V", "track", "stopped", "", "foreground", "source", "Lio/radar/sdk/Radar$RadarLocationSource;", "replayed", "Lio/radar/sdk/RadarApiClient$RadarTrackApiCallback;", "track$sdk_release", "updateTrip", "status", "Lio/radar/sdk/model/RadarTrip$RadarTripStatus;", "updateTrip$sdk_release", "verifyEvent", "eventId", "verification", "Lio/radar/sdk/model/RadarEvent$RadarEventVerification;", "verifiedPlaceId", "verifyEvent$sdk_release", "RadarContextApiCallback", "RadarDistanceApiCallback", "RadarGeocodeApiCallback", "RadarIpGeocodeApiCallback", "RadarSearchGeofencesApiCallback", "RadarSearchPlacesApiCallback", "RadarSearchPointsApiCallback", "RadarTrackApiCallback", "sdk_release"})
public final class RadarApiClient {
    private final Context context;
    @NotNull
    private RadarApiHelper apiHelper;

    private final Map<String, String> headers(String publishableKey) {
        return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"Authorization", (Object)publishableKey), TuplesKt.to((Object)"Content-Type", (Object)"application/json"), TuplesKt.to((Object)"X-Radar-Config", (Object)"true"), TuplesKt.to((Object)"X-Radar-Device-Make", (Object)RadarUtils.INSTANCE.getDeviceMake$sdk_release()), TuplesKt.to((Object)"X-Radar-Device-Model", (Object)RadarUtils.INSTANCE.getDeviceModel$sdk_release()), TuplesKt.to((Object)"X-Radar-Device-OS", (Object)RadarUtils.INSTANCE.getDeviceOS$sdk_release()), TuplesKt.to((Object)"X-Radar-Device-Type", (Object)"Android"), TuplesKt.to((Object)"X-Radar-SDK-Version", (Object)"3.0.9")});
    }

    public final void getConfig$sdk_release() {
        String deviceId;
        String string = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (string == null) {
            return;
        }
        String publishableKey = string;
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("installId=" + RadarSettings.INSTANCE.getInstallId$sdk_release(this.context));
        String userId = RadarSettings.INSTANCE.getUserId$sdk_release(this.context);
        if (userId != null) {
            queryParams.append("&userId=" + userId);
        }
        if ((deviceId = RadarUtils.INSTANCE.getDeviceId$sdk_release(this.context)) != null) {
            queryParams.append("&deviceId=" + deviceId);
        }
        String host = RadarSettings.INSTANCE.getHost$sdk_release(this.context);
        Uri uri = Uri.parse((String)host).buildUpon().appendEncodedPath("v1/config?" + queryParams).build();
        URL url = new URL(uri.toString());
        Map<String, String> headers = this.headers(publishableKey);
        this.apiHelper.request$sdk_release(this.context, "GET", url, headers, null, new RadarApiHelper.RadarApiCallback(this){
            final /* synthetic */ RadarApiClient this$0;

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                JSONObject meta;
                Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
                if (res != null && res.has("meta") && (meta = res.getJSONObject("meta")).has("config")) {
                    JSONObject config = meta.getJSONObject("config");
                    RadarSettings.INSTANCE.setConfig$sdk_release(RadarApiClient.access$getContext$p(this.this$0), config);
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public final void track$sdk_release(@NotNull Location location, boolean stopped, boolean foreground, @NotNull Radar.RadarLocationSource source, boolean replayed, @Nullable RadarTrackApiCallback callback) {
        RadarTrackingOptions options;
        RadarTripOptions tripOptions;
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)((Object)source), (String)"source");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarTrackApiCallback radarTrackApiCallback = callback;
            if (radarTrackApiCallback != null) {
                RadarTrackApiCallback.DefaultImpls.onComplete$default(radarTrackApiCallback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, null, null, 30, null);
            }
            return;
        }
        JSONObject params = new JSONObject();
        params.putOpt("installId", (Object)RadarSettings.INSTANCE.getInstallId$sdk_release(this.context));
        params.putOpt("id", (Object)RadarSettings.INSTANCE.getId$sdk_release(this.context));
        params.putOpt("userId", (Object)RadarSettings.INSTANCE.getUserId$sdk_release(this.context));
        params.putOpt("deviceId", (Object)RadarUtils.INSTANCE.getDeviceId$sdk_release(this.context));
        params.putOpt("description", (Object)RadarSettings.INSTANCE.getDescription$sdk_release(this.context));
        params.putOpt("metadata", (Object)RadarSettings.INSTANCE.getMetadata$sdk_release(this.context));
        if (RadarSettings.INSTANCE.getAdIdEnabled$sdk_release(this.context)) {
            params.putOpt("adId", (Object)RadarUtils.INSTANCE.getAdId$sdk_release(this.context));
        }
        params.putOpt("latitude", (Object)location.getLatitude());
        params.putOpt("longitude", (Object)location.getLongitude());
        float accuracy = location.getAccuracy();
        if (accuracy <= 0.0f) {
            accuracy = 1.0f;
        }
        params.putOpt("accuracy", (Object)Float.valueOf(accuracy));
        params.putOpt("speed", (Object)Float.valueOf(location.getSpeed()));
        params.putOpt("course", (Object)Float.valueOf(location.getBearing()));
        if (Build.VERSION.SDK_INT >= 26) {
            params.putOpt("verticalAccuracy", (Object)Float.valueOf(location.getVerticalAccuracyMeters()));
            params.putOpt("speedAccuracy", (Object)Float.valueOf(location.getSpeedAccuracyMetersPerSecond()));
            params.putOpt("courseAccuracy", (Object)Float.valueOf(location.getBearingAccuracyDegrees()));
        }
        if (!foreground && Build.VERSION.SDK_INT >= 17) {
            long updatedAtMsDiff = (SystemClock.elapsedRealtimeNanos() - location.getElapsedRealtimeNanos()) / (long)1000000;
            params.putOpt("updatedAtMsDiff", (Object)updatedAtMsDiff);
        }
        params.putOpt("foreground", (Object)foreground);
        params.putOpt("stopped", (Object)stopped);
        params.putOpt("replayed", (Object)replayed);
        params.putOpt("deviceType", (Object)"Android");
        params.putOpt("deviceMake", (Object)RadarUtils.INSTANCE.getDeviceMake$sdk_release());
        params.putOpt("sdkVersion", (Object)"3.0.9");
        params.putOpt("deviceModel", (Object)RadarUtils.INSTANCE.getDeviceModel$sdk_release());
        params.putOpt("deviceOS", (Object)RadarUtils.INSTANCE.getDeviceOS$sdk_release());
        params.putOpt("deviceType", (Object)"Android");
        params.putOpt("deviceMake", (Object)RadarUtils.INSTANCE.getDeviceMake$sdk_release());
        params.putOpt("country", (Object)RadarUtils.INSTANCE.getCountry$sdk_release());
        params.putOpt("timeZoneOffset", (Object)RadarUtils.INSTANCE.getTimeZoneOffset$sdk_release());
        params.putOpt("source", (Object)Radar.stringForSource(source));
        if (Build.VERSION.SDK_INT >= 18) {
            boolean mocked = location.isFromMockProvider();
            params.putOpt("mocked", (Object)mocked);
        }
        if ((tripOptions = RadarSettings.INSTANCE.getTripOptions$sdk_release(this.context)) != null) {
            JSONObject tripOptionsObj = new JSONObject();
            tripOptionsObj.putOpt("externalId", (Object)tripOptions.getExternalId());
            tripOptionsObj.putOpt("metadata", (Object)tripOptions.getMetadata());
            tripOptionsObj.putOpt("destinationGeofenceTag", (Object)tripOptions.getDestinationGeofenceTag());
            tripOptionsObj.putOpt("destinationGeofenceExternalId", (Object)tripOptions.getDestinationGeofenceExternalId());
            tripOptionsObj.putOpt("mode", (Object)Radar.stringForMode(tripOptions.getMode()));
            params.putOpt("tripOptions", (Object)tripOptionsObj);
        }
        if ((options = RadarSettings.INSTANCE.getTrackingOptions$sdk_release(this.context)).getSyncGeofences()) {
            params.putOpt("nearbyGeofences", (Object)true);
        }
        String host = RadarSettings.INSTANCE.getHost$sdk_release(this.context);
        Uri uri = Uri.parse((String)host).buildUpon().appendEncodedPath("v1/track").build();
        URL url = new URL(uri.toString());
        Map<String, String> headers = this.headers(publishableKey);
        this.apiHelper.request$sdk_release(this.context, "POST", url, headers, params, new RadarApiHelper.RadarApiCallback(this, options, stopped, source, location, callback){
            final /* synthetic */ RadarApiClient this$0;
            final /* synthetic */ RadarTrackingOptions $options;
            final /* synthetic */ boolean $stopped;
            final /* synthetic */ Radar.RadarLocationSource $source;
            final /* synthetic */ Location $location;
            final /* synthetic */ RadarTrackApiCallback $callback;

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                block13: {
                    RadarGeofence[] nearbyGeofences;
                    RadarGeofence[] radarGeofenceArray;
                    RadarUser radarUser;
                    RadarEvent[] radarEventArray;
                    boolean bl;
                    JSONArray config;
                    JSONObject meta;
                    Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
                    if (status != Radar.RadarStatus.SUCCESS || res == null) {
                        if (this.$options.getReplay() == RadarTrackingOptions.RadarTrackingOptionsReplay.STOPS && this.$stopped && this.$source != Radar.RadarLocationSource.FOREGROUND_LOCATION && this.$source != Radar.RadarLocationSource.BACKGROUND_LOCATION) {
                            RadarState.INSTANCE.setLastFailedStoppedLocation$sdk_release(RadarApiClient.access$getContext$p(this.this$0), this.$location);
                        }
                        Intent errorIntent = RadarReceiver.Companion.createErrorIntent$sdk_release(status);
                        Radar.INSTANCE.broadcastIntent$sdk_release(errorIntent);
                        RadarTrackApiCallback radarTrackApiCallback = this.$callback;
                        if (radarTrackApiCallback != null) {
                            RadarTrackApiCallback.DefaultImpls.onComplete$default(radarTrackApiCallback, status, null, null, null, null, 30, null);
                        }
                        return;
                    }
                    RadarState.INSTANCE.setLastFailedStoppedLocation$sdk_release(RadarApiClient.access$getContext$p(this.this$0), null);
                    if (res.has("meta") && (meta = res.getJSONObject("meta")).has("config")) {
                        config = meta.getJSONObject("config");
                        RadarSettings.INSTANCE.setConfig$sdk_release(RadarApiClient.access$getContext$p(this.this$0), (JSONObject)config);
                    }
                    JSONArray jSONArray = res.optJSONArray("events");
                    if (jSONArray != null) {
                        config = jSONArray;
                        boolean bl2 = false;
                        bl = false;
                        JSONArray eventsArr = config;
                        boolean bl3 = false;
                        radarEventArray = RadarEvent.Companion.fromJson(eventsArr);
                    } else {
                        radarEventArray = null;
                    }
                    RadarEvent[] events = radarEventArray;
                    JSONObject jSONObject = res.optJSONObject("user");
                    if (jSONObject != null) {
                        JSONObject jSONObject2 = jSONObject;
                        bl = false;
                        boolean bl4 = false;
                        JSONObject userObj = jSONObject2;
                        boolean bl5 = false;
                        radarUser = RadarUser.Companion.fromJson(userObj);
                    } else {
                        radarUser = null;
                    }
                    RadarUser user = radarUser;
                    JSONArray jSONArray2 = res.optJSONArray("nearbyGeofences");
                    if (jSONArray2 != null) {
                        JSONArray jSONArray3 = jSONArray2;
                        boolean bl6 = false;
                        boolean bl7 = false;
                        JSONArray nearbyGeofencesArr = jSONArray3;
                        boolean bl8 = false;
                        radarGeofenceArray = RadarGeofence.Companion.fromJson(nearbyGeofencesArr);
                    } else {
                        radarGeofenceArray = nearbyGeofences = null;
                    }
                    if (events != null && user != null) {
                        RadarSettings.INSTANCE.setId$sdk_release(RadarApiClient.access$getContext$p(this.this$0), user.get_id());
                        if (user.getTrip() == null) {
                            RadarSettings.INSTANCE.setTripOptions$sdk_release(RadarApiClient.access$getContext$p(this.this$0), null);
                        }
                        Intent successIntent = RadarReceiver.Companion.createSuccessIntent$sdk_release(res, this.$location);
                        Radar.INSTANCE.broadcastIntent$sdk_release(successIntent);
                        RadarTrackApiCallback radarTrackApiCallback = this.$callback;
                        if (radarTrackApiCallback != null) {
                            radarTrackApiCallback.onComplete(Radar.RadarStatus.SUCCESS, res, events, user, nearbyGeofences);
                        }
                        return;
                    }
                    Intent errorIntent = RadarReceiver.Companion.createErrorIntent$sdk_release(status);
                    Radar.INSTANCE.broadcastIntent$sdk_release(errorIntent);
                    RadarTrackApiCallback radarTrackApiCallback = this.$callback;
                    if (radarTrackApiCallback == null) break block13;
                    RadarTrackApiCallback.DefaultImpls.onComplete$default(radarTrackApiCallback, Radar.RadarStatus.ERROR_SERVER, null, null, null, null, 30, null);
                }
            }
            {
                this.this$0 = $outer;
                this.$options = $captured_local_variable$1;
                this.$stopped = $captured_local_variable$2;
                this.$source = $captured_local_variable$3;
                this.$location = $captured_local_variable$4;
                this.$callback = $captured_local_variable$5;
            }
        });
    }

    public static /* synthetic */ void track$sdk_release$default(RadarApiClient radarApiClient, Location location, boolean bl, boolean bl2, Radar.RadarLocationSource radarLocationSource, boolean bl3, RadarTrackApiCallback radarTrackApiCallback, int n, Object object) {
        if ((n & 0x20) != 0) {
            radarTrackApiCallback = null;
        }
        radarApiClient.track$sdk_release(location, bl, bl2, radarLocationSource, bl3, radarTrackApiCallback);
    }

    public final void verifyEvent$sdk_release(@NotNull String eventId, @NotNull RadarEvent.RadarEventVerification verification, @Nullable String verifiedPlaceId) {
        Intrinsics.checkParameterIsNotNull((Object)eventId, (String)"eventId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)verification), (String)"verification");
        String string = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (string == null) {
            return;
        }
        String publishableKey = string;
        JSONObject params = new JSONObject();
        params.putOpt("verification", (Object)verification);
        params.putOpt("verifiedPlaceId", (Object)verifiedPlaceId);
        String host = RadarSettings.INSTANCE.getHost$sdk_release(this.context);
        Uri uri = Uri.parse((String)host).buildUpon().appendEncodedPath("v1/events/").appendEncodedPath(eventId).appendEncodedPath("/verification").build();
        URL url = new URL(uri.toString());
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "PUT", url, headers, params, null, 32, null);
    }

    public static /* synthetic */ void verifyEvent$sdk_release$default(RadarApiClient radarApiClient, String string, RadarEvent.RadarEventVerification radarEventVerification, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        radarApiClient.verifyEvent$sdk_release(string, radarEventVerification, string2);
    }

    public final void updateTrip$sdk_release(@NotNull RadarTrip.RadarTripStatus status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        String string = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (string == null) {
            return;
        }
        String publishableKey = string;
        Object object = RadarSettings.INSTANCE.getTripOptions$sdk_release(this.context);
        if (object == null || (object = ((RadarTripOptions)object).getExternalId()) == null) {
            return;
        }
        Object externalId = object;
        JSONObject params = new JSONObject();
        params.putOpt("status", (Object)Radar.stringForTripStatus(status));
        String host = RadarSettings.INSTANCE.getHost$sdk_release(this.context);
        Uri uri = Uri.parse((String)host).buildUpon().appendEncodedPath("v1/trips/").appendEncodedPath((String)externalId).build();
        URL url = new URL(uri.toString());
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "PATCH", url, headers, params, null, 32, null);
    }

    public final void getContext$sdk_release(@NotNull Location location, @NotNull RadarContextApiCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarContextApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("coordinates=" + location.getLatitude() + ',' + location.getLongitude());
        String host = RadarSettings.INSTANCE.getHost$sdk_release(this.context);
        Uri.Builder uri = Uri.parse((String)host).buildUpon().appendEncodedPath("v1/context?" + queryParams);
        URL url = new URL(uri.toString());
        Map<String, String> headers = this.headers(publishableKey);
        this.apiHelper.request$sdk_release(this.context, "GET", url, headers, null, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarContextApiCallback $callback;

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarContext context;
                RadarContext radarContext;
                Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarContextApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONObject jSONObject = res.optJSONObject("context");
                if (jSONObject != null) {
                    JSONObject jSONObject2 = jSONObject;
                    boolean bl = false;
                    boolean bl2 = false;
                    JSONObject contextObj = jSONObject2;
                    boolean bl3 = false;
                    radarContext = RadarContext.Companion.fromJson(contextObj);
                } else {
                    radarContext = context = null;
                }
                if (context != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, context);
                    return;
                }
                RadarContextApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    public final void searchPlaces$sdk_release(@NotNull Location location, int radius, @Nullable String[] chains, @Nullable String[] categories, @Nullable String[] groups, @Nullable Integer limit, @NotNull RadarSearchPlacesApiCallback callback) {
        boolean bl;
        String[] stringArray;
        boolean bl2;
        String[] stringArray2;
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarSearchPlacesApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("near=" + location.getLatitude() + ',' + location.getLongitude());
        queryParams.append("&radius=" + radius);
        queryParams.append("&limit=" + limit);
        if (chains != null) {
            stringArray2 = chains;
            bl2 = false;
            stringArray = stringArray2;
            bl = false;
            if (!(stringArray.length == 0)) {
                queryParams.append("&chains=" + ArraysKt.joinToString$default((Object[])chains, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
        }
        if (categories != null) {
            stringArray2 = categories;
            bl2 = false;
            stringArray = stringArray2;
            bl = false;
            if (!(stringArray.length == 0)) {
                queryParams.append("&categories=" + ArraysKt.joinToString$default((Object[])categories, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
        }
        if (groups != null) {
            stringArray2 = groups;
            bl2 = false;
            stringArray = stringArray2;
            bl = false;
            if (!(stringArray.length == 0)) {
                queryParams.append("&groups=" + ArraysKt.joinToString$default((Object[])groups, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
        }
        String host = RadarSettings.INSTANCE.getHost$sdk_release(this.context);
        Uri uri = Uri.parse((String)host).buildUpon().appendEncodedPath("v1/search/places?" + queryParams).build();
        URL url = new URL(uri.toString());
        Map<String, String> headers = this.headers(publishableKey);
        this.apiHelper.request$sdk_release(this.context, "GET", url, headers, null, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarSearchPlacesApiCallback $callback;

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarPlace[] places;
                RadarPlace[] radarPlaceArray;
                Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarSearchPlacesApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONArray jSONArray = res.optJSONArray("places");
                if (jSONArray != null) {
                    JSONArray jSONArray2 = jSONArray;
                    boolean bl = false;
                    boolean bl2 = false;
                    JSONArray placesArr = jSONArray2;
                    boolean bl3 = false;
                    radarPlaceArray = RadarPlace.Companion.fromJson(placesArr);
                } else {
                    radarPlaceArray = places = null;
                }
                if (places != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, places);
                    return;
                }
                RadarSearchPlacesApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    public final void searchGeofences$sdk_release(@NotNull Location location, int radius, @Nullable String[] tags, @Nullable JSONObject metadata, @Nullable Integer limit, @NotNull RadarSearchGeofencesApiCallback callback) {
        Object object;
        boolean bl;
        Object object2;
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarSearchGeofencesApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("near=" + location.getLatitude() + ',' + location.getLongitude());
        queryParams.append("&radius=" + radius);
        queryParams.append("&limit=" + limit);
        Object object3 = tags;
        if (object3 != null) {
            Object object4 = object3;
            boolean bl2 = false;
            object2 = object4;
            bl = false;
            if (!(((String[])object2).length == 0)) {
                queryParams.append("&tags=" + ArraysKt.joinToString$default((Object[])tags, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
        }
        if ((object = metadata) != null && (object = object.keys()) != null) {
            Object $this$forEach$iv = object;
            boolean $i$f$forEach = false;
            object2 = $this$forEach$iv;
            bl = false;
            Object object5 = object2;
            while (object5.hasNext()) {
                Object element$iv = object5.next();
                String key = (String)element$iv;
                boolean bl3 = false;
                Object value = metadata.get(key);
                queryParams.append("&metadata[" + key + "]=" + value);
            }
        }
        String host = RadarSettings.INSTANCE.getHost$sdk_release(this.context);
        Uri uri = Uri.parse((String)host).buildUpon().appendEncodedPath("v1/search/geofences?" + queryParams).build();
        URL url = new URL(uri.toString());
        Map<String, String> headers = this.headers(publishableKey);
        this.apiHelper.request$sdk_release(this.context, "GET", url, headers, null, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarSearchGeofencesApiCallback $callback;

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarGeofence[] geofences;
                RadarGeofence[] radarGeofenceArray;
                Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarSearchGeofencesApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONArray jSONArray = res.optJSONArray("geofences");
                if (jSONArray != null) {
                    JSONArray jSONArray2 = jSONArray;
                    boolean bl = false;
                    boolean bl2 = false;
                    JSONArray geofencesArr = jSONArray2;
                    boolean bl3 = false;
                    radarGeofenceArray = RadarGeofence.Companion.fromJson(geofencesArr);
                } else {
                    radarGeofenceArray = geofences = null;
                }
                if (geofences != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, geofences);
                    return;
                }
                RadarSearchGeofencesApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    public final void searchPoints$sdk_release(@NotNull Location location, int radius, @Nullable String[] tags, @Nullable Integer limit, @NotNull RadarSearchPointsApiCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarSearchPointsApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("near=" + location.getLatitude() + ',' + location.getLongitude());
        queryParams.append("&radius=" + radius);
        queryParams.append("&limit=" + limit);
        if (tags != null) {
            String[] stringArray = tags;
            boolean bl = false;
            String[] stringArray2 = stringArray;
            boolean bl2 = false;
            if (!(stringArray2.length == 0)) {
                queryParams.append("&tags=" + ArraysKt.joinToString$default((Object[])tags, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
        }
        String host = RadarSettings.INSTANCE.getHost$sdk_release(this.context);
        Uri uri = Uri.parse((String)host).buildUpon().appendEncodedPath("v1/search/points?" + queryParams).build();
        URL url = new URL(uri.toString());
        Map<String, String> headers = this.headers(publishableKey);
        this.apiHelper.request$sdk_release(this.context, "GET", url, headers, null, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarSearchPointsApiCallback $callback;

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarPoint[] points;
                RadarPoint[] radarPointArray;
                Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarSearchPointsApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONArray jSONArray = res.optJSONArray("points");
                if (jSONArray != null) {
                    JSONArray jSONArray2 = jSONArray;
                    boolean bl = false;
                    boolean bl2 = false;
                    JSONArray pointsArr = jSONArray2;
                    boolean bl3 = false;
                    radarPointArray = RadarPoint.Companion.fromJson(pointsArr);
                } else {
                    radarPointArray = points = null;
                }
                if (points != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, points);
                    return;
                }
                RadarSearchPointsApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    public final void autocomplete$sdk_release(@NotNull String query, @NotNull Location near, int limit, @NotNull RadarGeocodeApiCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intrinsics.checkParameterIsNotNull((Object)near, (String)"near");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarGeocodeApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("query=" + query);
        queryParams.append("&near=" + near.getLatitude() + ',' + near.getLongitude());
        queryParams.append("&limit=" + limit);
        String host = RadarSettings.INSTANCE.getHost$sdk_release(this.context);
        Uri uri = Uri.parse((String)host).buildUpon().appendEncodedPath("v1/search/autocomplete?" + queryParams).build();
        URL url = new URL(uri.toString());
        Map<String, String> headers = this.headers(publishableKey);
        this.apiHelper.request$sdk_release(this.context, "GET", url, headers, null, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarGeocodeApiCallback $callback;

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarAddress[] addresses;
                RadarAddress[] radarAddressArray;
                Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONArray jSONArray = res.optJSONArray("addresses");
                if (jSONArray != null) {
                    JSONArray jSONArray2 = jSONArray;
                    boolean bl = false;
                    boolean bl2 = false;
                    JSONArray addressesArr = jSONArray2;
                    boolean bl3 = false;
                    radarAddressArray = RadarAddress.Companion.fromJson(addressesArr);
                } else {
                    radarAddressArray = addresses = null;
                }
                if (addresses != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, addresses);
                    return;
                }
                RadarGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    public final void geocode$sdk_release(@NotNull String query, @NotNull RadarGeocodeApiCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarGeocodeApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("query=" + query);
        String host = RadarSettings.INSTANCE.getHost$sdk_release(this.context);
        Uri uri = Uri.parse((String)host).buildUpon().appendEncodedPath("v1/geocode/forward?" + queryParams).build();
        URL url = new URL(uri.toString());
        Map<String, String> headers = this.headers(publishableKey);
        this.apiHelper.request$sdk_release(this.context, "GET", url, headers, null, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarGeocodeApiCallback $callback;

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarAddress[] addresses;
                RadarAddress[] radarAddressArray;
                Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONArray jSONArray = res.optJSONArray("addresses");
                if (jSONArray != null) {
                    JSONArray jSONArray2 = jSONArray;
                    boolean bl = false;
                    boolean bl2 = false;
                    JSONArray addressesArr = jSONArray2;
                    boolean bl3 = false;
                    radarAddressArray = RadarAddress.Companion.fromJson(addressesArr);
                } else {
                    radarAddressArray = addresses = null;
                }
                if (addresses != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, addresses);
                    return;
                }
                RadarGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    public final void reverseGeocode$sdk_release(@NotNull Location location, @NotNull RadarGeocodeApiCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarGeocodeApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("coordinates=" + location.getLatitude() + ',' + location.getLongitude());
        String host = RadarSettings.INSTANCE.getHost$sdk_release(this.context);
        Uri uri = Uri.parse((String)host).buildUpon().appendEncodedPath("v1/geocode/reverse?" + queryParams).build();
        URL url = new URL(uri.toString());
        Map<String, String> headers = this.headers(publishableKey);
        this.apiHelper.request$sdk_release(this.context, "GET", url, headers, null, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarGeocodeApiCallback $callback;

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarAddress[] addresses;
                RadarAddress[] radarAddressArray;
                Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONArray jSONArray = res.optJSONArray("addresses");
                if (jSONArray != null) {
                    JSONArray jSONArray2 = jSONArray;
                    boolean bl = false;
                    boolean bl2 = false;
                    JSONArray addressesArr = jSONArray2;
                    boolean bl3 = false;
                    radarAddressArray = RadarAddress.Companion.fromJson(addressesArr);
                } else {
                    radarAddressArray = addresses = null;
                }
                if (addresses != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, addresses);
                    return;
                }
                RadarGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    public final void ipGeocode$sdk_release(@NotNull RadarIpGeocodeApiCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarIpGeocodeApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, false, 14, null);
            return;
        }
        String host = RadarSettings.INSTANCE.getHost$sdk_release(this.context);
        Uri uri = Uri.parse((String)host).buildUpon().appendEncodedPath("v1/geocode/ip").build();
        URL url = new URL(uri.toString());
        Map<String, String> headers = this.headers(publishableKey);
        this.apiHelper.request$sdk_release(this.context, "GET", url, headers, null, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarIpGeocodeApiCallback $callback;

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarAddress radarAddress;
                Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarIpGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, false, 14, null);
                    return;
                }
                JSONObject jSONObject = res.optJSONObject("address");
                if (jSONObject != null) {
                    JSONObject jSONObject2 = jSONObject;
                    boolean bl = false;
                    boolean bl2 = false;
                    JSONObject addressObj = jSONObject2;
                    boolean bl3 = false;
                    radarAddress = RadarAddress.Companion.fromJson(addressObj);
                } else {
                    radarAddress = null;
                }
                RadarAddress address = radarAddress;
                boolean proxy = res.optBoolean("proxy");
                if (address != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, address, proxy);
                    return;
                }
                RadarIpGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, false, 14, null);
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    public final void getDistance$sdk_release(@NotNull Location origin, @NotNull Location destination, @NotNull EnumSet<Radar.RadarRouteMode> modes, @NotNull Radar.RadarRouteUnits units, int geometryPoints, @NotNull RadarDistanceApiCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)origin, (String)"origin");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Intrinsics.checkParameterIsNotNull(modes, (String)"modes");
        Intrinsics.checkParameterIsNotNull((Object)((Object)units), (String)"units");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarDistanceApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("origin=" + origin.getLatitude() + ',' + origin.getLongitude());
        queryParams.append("&destination=" + destination.getLatitude() + ',' + destination.getLongitude());
        boolean bl = false;
        List modesList = new ArrayList();
        if (modes.contains((Object)Radar.RadarRouteMode.FOOT)) {
            modesList.add("foot");
        }
        if (modes.contains((Object)Radar.RadarRouteMode.BIKE)) {
            modesList.add("bike");
        }
        if (modes.contains((Object)Radar.RadarRouteMode.CAR)) {
            modesList.add("car");
        }
        queryParams.append("&modes=" + CollectionsKt.joinToString$default((Iterable)modesList, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        if (units == Radar.RadarRouteUnits.METRIC) {
            queryParams.append("&units=metric");
        } else {
            queryParams.append("&units=imperial");
        }
        if (geometryPoints > 1) {
            queryParams.append("&geometryPoints=" + geometryPoints);
        }
        queryParams.append("&geometry=linestring");
        String host = RadarSettings.INSTANCE.getHost$sdk_release(this.context);
        Uri uri = Uri.parse((String)host).buildUpon().appendEncodedPath("v1/route/distance?" + queryParams).build();
        URL url = new URL(uri.toString());
        Map<String, String> headers = this.headers(publishableKey);
        this.apiHelper.request$sdk_release(this.context, "GET", url, headers, null, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarDistanceApiCallback $callback;

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarRoutes routes;
                RadarRoutes radarRoutes;
                Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarDistanceApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONObject jSONObject = res.optJSONObject("routes");
                if (jSONObject != null) {
                    JSONObject jSONObject2 = jSONObject;
                    boolean bl = false;
                    boolean bl2 = false;
                    JSONObject routesObj = jSONObject2;
                    boolean bl3 = false;
                    radarRoutes = RadarRoutes.Companion.fromJson(routesObj);
                } else {
                    radarRoutes = routes = null;
                }
                if (routes != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, routes);
                    return;
                }
                RadarDistanceApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    public final RadarApiHelper getApiHelper$sdk_release() {
        return this.apiHelper;
    }

    public final void setApiHelper$sdk_release(@NotNull RadarApiHelper radarApiHelper) {
        Intrinsics.checkParameterIsNotNull((Object)radarApiHelper, (String)"<set-?>");
        this.apiHelper = radarApiHelper;
    }

    public RadarApiClient(@NotNull Context context, @NotNull RadarApiHelper apiHelper) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)apiHelper, (String)"apiHelper");
        this.context = context;
        this.apiHelper = apiHelper;
    }

    public /* synthetic */ RadarApiClient(Context context, RadarApiHelper radarApiHelper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            radarApiHelper = new RadarApiHelper();
        }
        this(context, radarApiHelper);
    }

    public static final /* synthetic */ Context access$getContext$p(RadarApiClient $this) {
        return $this.context;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001JQ\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\tH&\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lio/radar/sdk/RadarApiClient$RadarTrackApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "events", "", "Lio/radar/sdk/model/RadarEvent;", "user", "Lio/radar/sdk/model/RadarUser;", "nearbyGeofences", "Lio/radar/sdk/model/RadarGeofence;", "(Lio/radar/sdk/Radar$RadarStatus;Lorg/json/JSONObject;[Lio/radar/sdk/model/RadarEvent;Lio/radar/sdk/model/RadarUser;[Lio/radar/sdk/model/RadarGeofence;)V", "sdk_release"})
    public static interface RadarTrackApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarEvent[] var3, @Nullable RadarUser var4, @Nullable RadarGeofence[] var5);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarTrackApiCallback radarTrackApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarEvent[] radarEventArray, RadarUser radarUser, RadarGeofence[] radarGeofenceArray, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarEventArray = null;
                }
                if ((n & 8) != 0) {
                    radarUser = null;
                }
                if ((n & 0x10) != 0) {
                    radarGeofenceArray = null;
                }
                radarTrackApiCallback.onComplete(radarStatus, jSONObject, radarEventArray, radarUser, radarGeofenceArray);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lio/radar/sdk/RadarApiClient$RadarContextApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "context", "Lio/radar/sdk/model/RadarContext;", "sdk_release"})
    public static interface RadarContextApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarContext var3);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarContextApiCallback radarContextApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarContext radarContext, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarContext = null;
                }
                radarContextApiCallback.onComplete(radarStatus, jSONObject, radarContext);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J3\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH&\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/radar/sdk/RadarApiClient$RadarSearchPlacesApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "places", "", "Lio/radar/sdk/model/RadarPlace;", "(Lio/radar/sdk/Radar$RadarStatus;Lorg/json/JSONObject;[Lio/radar/sdk/model/RadarPlace;)V", "sdk_release"})
    public static interface RadarSearchPlacesApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarPlace[] var3);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarSearchPlacesApiCallback radarSearchPlacesApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarPlace[] radarPlaceArray, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarPlaceArray = null;
                }
                radarSearchPlacesApiCallback.onComplete(radarStatus, jSONObject, radarPlaceArray);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J3\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH&\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/radar/sdk/RadarApiClient$RadarSearchGeofencesApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "geofences", "", "Lio/radar/sdk/model/RadarGeofence;", "(Lio/radar/sdk/Radar$RadarStatus;Lorg/json/JSONObject;[Lio/radar/sdk/model/RadarGeofence;)V", "sdk_release"})
    public static interface RadarSearchGeofencesApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarGeofence[] var3);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarSearchGeofencesApiCallback radarSearchGeofencesApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarGeofence[] radarGeofenceArray, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarGeofenceArray = null;
                }
                radarSearchGeofencesApiCallback.onComplete(radarStatus, jSONObject, radarGeofenceArray);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J3\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH&\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/radar/sdk/RadarApiClient$RadarSearchPointsApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "points", "", "Lio/radar/sdk/model/RadarPoint;", "(Lio/radar/sdk/Radar$RadarStatus;Lorg/json/JSONObject;[Lio/radar/sdk/model/RadarPoint;)V", "sdk_release"})
    public static interface RadarSearchPointsApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarPoint[] var3);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarSearchPointsApiCallback radarSearchPointsApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarPoint[] radarPointArray, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarPointArray = null;
                }
                radarSearchPointsApiCallback.onComplete(radarStatus, jSONObject, radarPointArray);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J3\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH&\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/radar/sdk/RadarApiClient$RadarGeocodeApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "addresses", "", "Lio/radar/sdk/model/RadarAddress;", "(Lio/radar/sdk/Radar$RadarStatus;Lorg/json/JSONObject;[Lio/radar/sdk/model/RadarAddress;)V", "sdk_release"})
    public static interface RadarGeocodeApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarAddress[] var3);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarGeocodeApiCallback radarGeocodeApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarAddress[] radarAddressArray, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarAddressArray = null;
                }
                radarGeocodeApiCallback.onComplete(radarStatus, jSONObject, radarAddressArray);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J2\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\f"}, d2={"Lio/radar/sdk/RadarApiClient$RadarIpGeocodeApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "address", "Lio/radar/sdk/model/RadarAddress;", "proxy", "", "sdk_release"})
    public static interface RadarIpGeocodeApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarAddress var3, boolean var4);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarIpGeocodeApiCallback radarIpGeocodeApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarAddress radarAddress, boolean bl, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarAddress = null;
                }
                if ((n & 8) != 0) {
                    bl = false;
                }
                radarIpGeocodeApiCallback.onComplete(radarStatus, jSONObject, radarAddress, bl);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lio/radar/sdk/RadarApiClient$RadarDistanceApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "routes", "Lio/radar/sdk/model/RadarRoutes;", "sdk_release"})
    public static interface RadarDistanceApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarRoutes var3);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarDistanceApiCallback radarDistanceApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarRoutes radarRoutes, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarRoutes = null;
                }
                radarDistanceApiCallback.onComplete(radarStatus, jSONObject, radarRoutes);
            }
        }
    }
}

