/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingClient;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarActivityLifecycleCallbacks;
import io.radar.sdk.RadarApiClient;
import io.radar.sdk.RadarLocationManager$WhenMappings;
import io.radar.sdk.RadarLocationReceiver;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.RadarPermissionsHelper;
import io.radar.sdk.RadarReceiver;
import io.radar.sdk.RadarSettings;
import io.radar.sdk.RadarState;
import io.radar.sdk.RadarTrackingOptions;
import io.radar.sdk.RadarUtils;
import io.radar.sdk.model.RadarCircleGeometry;
import io.radar.sdk.model.RadarCoordinate;
import io.radar.sdk.model.RadarEvent;
import io.radar.sdk.model.RadarGeofence;
import io.radar.sdk.model.RadarPolygonGeometry;
import io.radar.sdk.model.RadarUser;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 K2\u00020\u0001:\u0001KB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\rH\u0002J\u001c\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020+2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-H\u0002J\u0010\u0010.\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\rJ\u0018\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u00020\"2\b\u0010(\u001a\u0004\u0018\u00010\rJ\r\u00100\u001a\u00020'H\u0000\u00a2\u0006\u0002\b1J\u0018\u00102\u001a\u00020'2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u00103\u001a\u000204J\b\u00105\u001a\u00020'H\u0002J\b\u00106\u001a\u00020'H\u0002J\b\u00107\u001a\u00020'H\u0002J\u001a\u00108\u001a\u00020'2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u00109\u001a\u00020 H\u0002J\u001d\u0010:\u001a\u00020'2\u000e\u0010;\u001a\n\u0012\u0004\u0012\u00020=\u0018\u00010<H\u0002\u00a2\u0006\u0002\u0010>J(\u0010?\u001a\u00020'2\u0006\u0010,\u001a\u00020-2\u0006\u00109\u001a\u00020 2\u0006\u00103\u001a\u0002042\u0006\u0010@\u001a\u00020 H\u0002J \u0010A\u001a\u00020'2\u0006\u0010/\u001a\u00020\"2\u0006\u0010B\u001a\u00020$2\u0006\u0010C\u001a\u00020$H\u0002J\u0010\u0010D\u001a\u00020'2\b\b\u0002\u0010E\u001a\u00020FJ\b\u0010G\u001a\u00020'H\u0002J\u0006\u0010H\u001a\u00020'J\u0019\u0010I\u001a\u00020'2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-H\u0000\u00a2\u0006\u0002\bJR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lio/radar/sdk/RadarLocationManager;", "", "context", "Landroid/content/Context;", "apiClient", "Lio/radar/sdk/RadarApiClient;", "logger", "Lio/radar/sdk/RadarLogger;", "permissionsHelper", "Lio/radar/sdk/RadarPermissionsHelper;", "(Landroid/content/Context;Lio/radar/sdk/RadarApiClient;Lio/radar/sdk/RadarLogger;Lio/radar/sdk/RadarPermissionsHelper;)V", "callbacks", "Ljava/util/ArrayList;", "Lio/radar/sdk/Radar$RadarLocationCallback;", "Lkotlin/collections/ArrayList;", "geofencingClient", "Lcom/google/android/gms/location/GeofencingClient;", "getGeofencingClient$sdk_release", "()Lcom/google/android/gms/location/GeofencingClient;", "setGeofencingClient$sdk_release", "(Lcom/google/android/gms/location/GeofencingClient;)V", "locationClient", "Lcom/google/android/gms/location/FusedLocationProviderClient;", "getLocationClient$sdk_release", "()Lcom/google/android/gms/location/FusedLocationProviderClient;", "setLocationClient$sdk_release", "(Lcom/google/android/gms/location/FusedLocationProviderClient;)V", "getPermissionsHelper$sdk_release", "()Lio/radar/sdk/RadarPermissionsHelper;", "setPermissionsHelper$sdk_release", "(Lio/radar/sdk/RadarPermissionsHelper;)V", "started", "", "startedDesiredAccuracy", "Lio/radar/sdk/RadarTrackingOptions$RadarTrackingOptionsDesiredAccuracy;", "startedFastestInterval", "", "startedInterval", "addCallback", "", "callback", "callCallbacks", "status", "Lio/radar/sdk/Radar$RadarStatus;", "location", "Landroid/location/Location;", "getLocation", "desiredAccuracy", "handleBootCompleted", "handleBootCompleted$sdk_release", "handleLocation", "source", "Lio/radar/sdk/Radar$RadarLocationSource;", "removeAllGeofences", "removeBubbleGeofences", "removeSyncedGeofences", "replaceBubbleGeofence", "stopped", "replaceSyncedGeofences", "radarGeofences", "", "Lio/radar/sdk/model/RadarGeofence;", "([Lio/radar/sdk/model/RadarGeofence;)V", "sendLocation", "replayed", "startLocationUpdates", "interval", "fastestInterval", "startTracking", "options", "Lio/radar/sdk/RadarTrackingOptions;", "stopLocationUpdates", "stopTracking", "updateTracking", "updateTracking$sdk_release", "Companion", "sdk_release"})
@SuppressLint(value={"MissingPermission"})
public final class RadarLocationManager {
    @NotNull
    private FusedLocationProviderClient locationClient;
    @NotNull
    private GeofencingClient geofencingClient;
    private boolean started;
    private RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy startedDesiredAccuracy;
    private int startedInterval;
    private int startedFastestInterval;
    private final ArrayList<Radar.RadarLocationCallback> callbacks;
    private final Context context;
    private final RadarApiClient apiClient;
    private final RadarLogger logger;
    @NotNull
    private RadarPermissionsHelper permissionsHelper;
    @NotNull
    public static final String BUBBLE_MOVING_GEOFENCE_REQUEST_ID = "radar_moving";
    @NotNull
    public static final String BUBBLE_STOPPED_GEOFENCE_REQUEST_ID = "radar_stopped";
    @NotNull
    public static final String SYNCED_GEOFENCES_REQUEST_ID_PREFIX = "radar_sync";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final FusedLocationProviderClient getLocationClient$sdk_release() {
        return this.locationClient;
    }

    public final void setLocationClient$sdk_release(@NotNull FusedLocationProviderClient fusedLocationProviderClient) {
        Intrinsics.checkParameterIsNotNull((Object)fusedLocationProviderClient, (String)"<set-?>");
        this.locationClient = fusedLocationProviderClient;
    }

    @NotNull
    public final GeofencingClient getGeofencingClient$sdk_release() {
        return this.geofencingClient;
    }

    public final void setGeofencingClient$sdk_release(@NotNull GeofencingClient geofencingClient) {
        Intrinsics.checkParameterIsNotNull((Object)geofencingClient, (String)"<set-?>");
        this.geofencingClient = geofencingClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addCallback(Radar.RadarLocationCallback callback) {
        if (callback == null) {
            return;
        }
        ArrayList<Radar.RadarLocationCallback> arrayList = this.callbacks;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (arrayList) {
            boolean bl3 = false;
            bl2 = this.callbacks.add(callback);
        }
        new Handler().postAtTime(new Runnable(this, callback){
            final /* synthetic */ RadarLocationManager this$0;
            final /* synthetic */ Radar.RadarLocationCallback $callback;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                ArrayList arrayList = RadarLocationManager.access$getCallbacks$p(this.this$0);
                boolean bl = false;
                boolean bl2 = false;
                synchronized (arrayList) {
                    boolean bl3 = false;
                    if (RadarLocationManager.access$getCallbacks$p(this.this$0).contains(this.$callback)) {
                        Radar.RadarLocationCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_LOCATION, null, false, 6, null);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            {
                this.this$0 = radarLocationManager;
                this.$callback = radarLocationCallback;
            }
        }, (Object)"timeout", SystemClock.uptimeMillis() + 20000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void callCallbacks(Radar.RadarStatus status, Location location) {
        ArrayList<Radar.RadarLocationCallback> arrayList = this.callbacks;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (arrayList) {
            boolean bl3 = false;
            if (this.callbacks.isEmpty()) {
                return;
            }
            RadarLogger.d$default(this.logger, this.context, "Calling callbacks | callbacks.size = " + this.callbacks.size(), null, 4, null);
            for (Radar.RadarLocationCallback callback : this.callbacks) {
                callback.onComplete(status, location, RadarState.INSTANCE.getStopped$sdk_release(this.context));
            }
            this.callbacks.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    static /* synthetic */ void callCallbacks$default(RadarLocationManager radarLocationManager, Radar.RadarStatus radarStatus, Location location, int n, Object object) {
        if ((n & 2) != 0) {
            location = null;
        }
        radarLocationManager.callCallbacks(radarStatus, location);
    }

    public final void getLocation(@Nullable Radar.RadarLocationCallback callback) {
        this.getLocation(RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy.MEDIUM, callback);
    }

    public final void getLocation(@NotNull RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy desiredAccuracy, @Nullable Radar.RadarLocationCallback callback) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)((Object)desiredAccuracy), (String)"desiredAccuracy");
        this.addCallback(callback);
        if (!this.permissionsHelper.fineLocationPermissionGranted$sdk_release(this.context)) {
            Intent errorIntent = RadarReceiver.Companion.createErrorIntent$sdk_release(Radar.RadarStatus.ERROR_PERMISSIONS);
            Radar.INSTANCE.broadcastIntent$sdk_release(errorIntent);
            Radar.RadarLocationCallback radarLocationCallback = callback;
            if (radarLocationCallback != null) {
                Radar.RadarLocationCallback.DefaultImpls.onComplete$default(radarLocationCallback, Radar.RadarStatus.ERROR_PERMISSIONS, null, false, 6, null);
            }
            return;
        }
        RadarLocationManager locationManager = this;
        switch (RadarLocationManager$WhenMappings.$EnumSwitchMapping$0[desiredAccuracy.ordinal()]) {
            case 1: {
                n = 100;
                break;
            }
            case 2: {
                n = 102;
                break;
            }
            case 3: {
                n = 104;
                break;
            }
            case 4: {
                n = 105;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int desiredPriority = n;
        LocationRequest locationRequest = new LocationRequest();
        boolean bl = false;
        boolean bl2 = false;
        LocationRequest $this$apply = locationRequest;
        boolean bl3 = false;
        $this$apply.setPriority(desiredPriority);
        $this$apply.setInterval(1000L);
        $this$apply.setFastestInterval(1000L);
        $this$apply.setNumUpdates(1);
        LocationRequest locationRequest2 = locationRequest.setExpirationDuration(20000L);
        RadarLogger.d$default(this.logger, this.context, "Requesting location", null, 4, null);
        this.locationClient.requestLocationUpdates(locationRequest2, new LocationCallback(this, locationManager){
            final /* synthetic */ RadarLocationManager this$0;
            final /* synthetic */ RadarLocationManager $locationManager;

            public void onLocationResult(@Nullable LocationResult result) {
                this.this$0.getLocationClient$sdk_release().removeLocationUpdates((LocationCallback)this);
                LocationResult locationResult = result;
                this.$locationManager.handleLocation((Location)(locationResult != null ? locationResult.getLastLocation() : null), Radar.RadarLocationSource.FOREGROUND_LOCATION);
            }
            {
                this.this$0 = $outer;
                this.$locationManager = $captured_local_variable$1;
            }
        }, Looper.getMainLooper());
    }

    public final void startTracking(@NotNull RadarTrackingOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.stopLocationUpdates();
        if (!this.permissionsHelper.fineLocationPermissionGranted$sdk_release(this.context)) {
            Intent errorIntent = RadarReceiver.Companion.createErrorIntent$sdk_release(Radar.RadarStatus.ERROR_PERMISSIONS);
            Radar.INSTANCE.broadcastIntent$sdk_release(errorIntent);
            return;
        }
        RadarSettings.INSTANCE.setTracking$sdk_release(this.context, true);
        RadarSettings.INSTANCE.setTrackingOptions$sdk_release(this.context, options);
        RadarLocationManager.updateTracking$sdk_release$default(this, null, 1, null);
    }

    public static /* synthetic */ void startTracking$default(RadarLocationManager radarLocationManager, RadarTrackingOptions radarTrackingOptions, int n, Object object) {
        if ((n & 1) != 0) {
            radarTrackingOptions = RadarTrackingOptions.EFFICIENT;
        }
        radarLocationManager.startTracking(radarTrackingOptions);
    }

    public final void stopTracking() {
        this.started = false;
        RadarSettings.INSTANCE.setTracking$sdk_release(this.context, false);
        RadarLocationManager.updateTracking$sdk_release$default(this, null, 1, null);
    }

    private final void startLocationUpdates(RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy desiredAccuracy, int interval, int fastestInterval) {
        if (!this.started || desiredAccuracy != this.startedDesiredAccuracy || interval != this.startedInterval || fastestInterval != this.startedFastestInterval) {
            int n;
            switch (RadarLocationManager$WhenMappings.$EnumSwitchMapping$1[desiredAccuracy.ordinal()]) {
                case 1: {
                    n = 100;
                    break;
                }
                case 2: {
                    n = 102;
                    break;
                }
                case 3: {
                    n = 104;
                    break;
                }
                default: {
                    n = 102;
                }
            }
            int priority = n;
            LocationRequest locationRequest = new LocationRequest();
            boolean bl = false;
            boolean bl2 = false;
            LocationRequest $this$apply = locationRequest;
            boolean bl3 = false;
            $this$apply.setPriority(priority);
            $this$apply.setInterval((long)interval * 1000L);
            $this$apply.setFastestInterval((long)fastestInterval * 1000L);
            LocationRequest locationRequest2 = locationRequest;
            this.locationClient.requestLocationUpdates(locationRequest2, RadarLocationReceiver.Companion.getLocationPendingIntent$sdk_release(this.context));
            this.started = true;
            this.startedDesiredAccuracy = desiredAccuracy;
            this.startedInterval = interval;
            this.startedFastestInterval = fastestInterval;
        }
    }

    private final void stopLocationUpdates() {
        this.locationClient.removeLocationUpdates(RadarLocationReceiver.Companion.getLocationPendingIntent$sdk_release(this.context));
        this.started = false;
    }

    public final void handleBootCompleted$sdk_release() {
        this.started = false;
        RadarState.INSTANCE.setStopped$sdk_release(this.context, false);
        this.locationClient.getLastLocation().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Location>(this){
            final /* synthetic */ RadarLocationManager this$0;

            public final void onSuccess(@Nullable Location location) {
                this.this$0.updateTracking$sdk_release(location);
            }
            {
                this.this$0 = radarLocationManager;
            }
        }).addOnFailureListener(new OnFailureListener(this){
            final /* synthetic */ RadarLocationManager this$0;

            public final void onFailure(@NotNull Exception it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                RadarLocationManager.updateTracking$sdk_release$default(this.this$0, null, 1, null);
            }
            {
                this.this$0 = radarLocationManager;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    public final void updateTracking$sdk_release(@Nullable Location location) {
        tracking = RadarSettings.INSTANCE.getTracking$sdk_release(this.context);
        options = RadarSettings.INSTANCE.getTrackingOptions$sdk_release(this.context);
        RadarLogger.d$default(this.logger, this.context, "Updating tracking | options = " + options + "; location = " + location, null, 4, null);
        now = new Date();
        if (tracking || options.getStartTrackingAfter() == null) ** GOTO lbl-1000
        v0 = options.getStartTrackingAfter();
        if (v0 == null) {
            Intrinsics.throwNpe();
        }
        if (v0.before(now)) {
            RadarLogger.d$default(this.logger, this.context, "Starting time-based tracking | startTrackingAfter = " + options.getStartTrackingAfter(), null, 4, null);
            tracking = true;
            RadarSettings.INSTANCE.setTracking$sdk_release(this.context, true);
        } else if (tracking && options.getStopTrackingAfter() != null) {
            v1 = options.getStopTrackingAfter();
            if (v1 == null) {
                Intrinsics.throwNpe();
            }
            if (v1.before(now)) {
                RadarLogger.d$default(this.logger, this.context, "Stopping time-based tracking | startTrackingAfter = " + options.getStartTrackingAfter(), null, 4, null);
                tracking = false;
                RadarSettings.INSTANCE.setTracking$sdk_release(this.context, false);
            }
        }
        if (tracking) {
            stopped = RadarState.INSTANCE.getStopped$sdk_release(this.context);
            if (stopped) {
                if (options.getDesiredStoppedUpdateInterval() == 0) {
                    this.stopLocationUpdates();
                } else {
                    this.startLocationUpdates(options.getDesiredAccuracy(), options.getDesiredStoppedUpdateInterval(), options.getFastestStoppedUpdateInterval());
                }
                if (options.getUseStoppedGeofence() && location != null) {
                    this.replaceBubbleGeofence(location, true);
                } else {
                    this.removeBubbleGeofences();
                }
            } else {
                if (options.getDesiredMovingUpdateInterval() == 0) {
                    this.stopLocationUpdates();
                } else {
                    this.startLocationUpdates(options.getDesiredAccuracy(), options.getDesiredMovingUpdateInterval(), options.getFastestMovingUpdateInterval());
                }
                if (options.getUseMovingGeofence() && location != null) {
                    this.replaceBubbleGeofence(location, false);
                } else {
                    this.removeBubbleGeofences();
                }
            }
        } else {
            this.stopLocationUpdates();
            this.removeAllGeofences();
        }
    }

    public static /* synthetic */ void updateTracking$sdk_release$default(RadarLocationManager radarLocationManager, Location location, int n, Object object) {
        if ((n & 1) != 0) {
            location = null;
        }
        radarLocationManager.updateTracking$sdk_release(location);
    }

    private final void replaceBubbleGeofence(Location location, boolean stopped) {
        if (location == null) {
            return;
        }
        this.removeBubbleGeofences();
        RadarTrackingOptions options = RadarSettings.INSTANCE.getTrackingOptions$sdk_release(this.context);
        if (stopped && options.getUseStoppedGeofence()) {
            String identifier = BUBBLE_STOPPED_GEOFENCE_REQUEST_ID;
            float radius = options.getStoppedGeofenceRadius();
            Geofence geofence = new Geofence.Builder().setRequestId(identifier).setCircularRegion(location.getLatitude(), location.getLongitude(), radius).setExpirationDuration(-1L).setTransitionTypes(2).build();
            GeofencingRequest request2 = new GeofencingRequest.Builder().addGeofence(geofence).setInitialTrigger(2).build();
            this.geofencingClient.addGeofences(request2, RadarLocationReceiver.Companion.getBubbleGeofencePendingIntent$sdk_release(this.context));
            RadarLogger.d$default(this.logger, this.context, "Replaced stopped bubble geofence | latitude = " + location.getLatitude() + "; longitude = " + location.getLongitude() + "; radius = " + radius + "; identifier = " + identifier, null, 4, null);
        } else if (!stopped && options.getUseMovingGeofence()) {
            String identifier = BUBBLE_MOVING_GEOFENCE_REQUEST_ID;
            float radius = options.getStoppedGeofenceRadius();
            Geofence geofence = new Geofence.Builder().setRequestId(identifier).setCircularRegion(location.getLatitude(), location.getLongitude(), radius).setExpirationDuration(-1L).setLoiteringDelay(options.getStopDuration() * 1000 + 10000).setTransitionTypes(4).build();
            GeofencingRequest request3 = new GeofencingRequest.Builder().addGeofence(geofence).setInitialTrigger(4).build();
            this.geofencingClient.addGeofences(request3, RadarLocationReceiver.Companion.getBubbleGeofencePendingIntent$sdk_release(this.context));
            RadarLogger.d$default(this.logger, this.context, "Replaced moving bubble geofence | latitude = " + location.getLatitude() + "; longitude = " + location.getLongitude() + "; radius = " + radius + "; identifier = " + identifier, null, 4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceSyncedGeofences(RadarGeofence[] radarGeofences) {
        this.removeSyncedGeofences();
        RadarTrackingOptions options = RadarSettings.INSTANCE.getTrackingOptions$sdk_release(this.context);
        if (!options.getSyncGeofences() || radarGeofences == null) {
            return;
        }
        boolean bl = false;
        List geofences = new ArrayList();
        RadarGeofence[] $this$forEachIndexed$iv = radarGeofences;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (RadarGeofence item$iv : $this$forEachIndexed$iv) {
            Geofence geofence;
            void radarGeofence;
            int n = index$iv++;
            RadarGeofence radarGeofence2 = item$iv;
            int i = n;
            boolean bl2 = false;
            RadarCoordinate center = null;
            double radius = 100.0;
            if (radarGeofence.getGeometry() instanceof RadarCircleGeometry) {
                center = ((RadarCircleGeometry)radarGeofence.getGeometry()).getCenter();
                radius = ((RadarCircleGeometry)radarGeofence.getGeometry()).getRadius();
            } else if (radarGeofence.getGeometry() instanceof RadarPolygonGeometry) {
                center = ((RadarPolygonGeometry)radarGeofence.getGeometry()).getCenter();
                radius = ((RadarPolygonGeometry)radarGeofence.getGeometry()).getRadius();
            }
            if (center == null) continue;
            String identifier = "radar_sync_" + i;
            Geofence geofence2 = geofence = new Geofence.Builder().setRequestId(identifier).setCircularRegion(center.getLatitude(), center.getLongitude(), (float)radius).setExpirationDuration(-1L).setLoiteringDelay(options.getStopDuration() * 1000 + 10000).setTransitionTypes(7).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)geofence2, (String)"geofence");
            geofences.add(geofence2);
            RadarLogger.d$default(this.logger, this.context, "Synced geofence | latitude = " + center.getLatitude() + "; longitude = " + center.getLongitude() + "; radius = " + radius + "; identifier = " + identifier, null, 4, null);
        }
        GeofencingRequest request2 = new GeofencingRequest.Builder().addGeofences(geofences).setInitialTrigger(0).build();
        this.geofencingClient.addGeofences(request2, RadarLocationReceiver.Companion.getSyncedGeofencesPendingIntent$sdk_release(this.context));
    }

    private final void removeBubbleGeofences() {
        this.geofencingClient.removeGeofences(RadarLocationReceiver.Companion.getBubbleGeofencePendingIntent$sdk_release(this.context));
    }

    private final void removeSyncedGeofences() {
        this.geofencingClient.removeGeofences(RadarLocationReceiver.Companion.getSyncedGeofencesPendingIntent$sdk_release(this.context));
    }

    private final void removeAllGeofences() {
        this.removeBubbleGeofences();
        this.removeSyncedGeofences();
    }

    /*
     * Unable to fully structure code
     */
    public final void handleLocation(@Nullable Location location, @NotNull Radar.RadarLocationSource source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        RadarLogger.d$default(this.logger, this.context, "Handling location | location = " + location, null, 4, null);
        if (location == null || !RadarUtils.INSTANCE.valid$sdk_release(location)) {
            RadarLogger.d$default(this.logger, this.context, "Invalid location | source = " + (Object)source + "; location = " + location, null, 4, null);
            errorIntent = RadarReceiver.Companion.createErrorIntent$sdk_release(Radar.RadarStatus.ERROR_LOCATION);
            Radar.INSTANCE.broadcastIntent$sdk_release(errorIntent);
            RadarLocationManager.callCallbacks$default(this, Radar.RadarStatus.ERROR_LOCATION, null, 2, null);
            return;
        }
        options = RadarSettings.INSTANCE.getTrackingOptions$sdk_release(this.context);
        wasStopped = RadarState.INSTANCE.getStopped$sdk_release(this.context);
        stopped = new Ref.BooleanRef();
        v0 = force = source == Radar.RadarLocationSource.FOREGROUND_LOCATION || source == Radar.RadarLocationSource.MANUAL_LOCATION;
        if (!force && location.getAccuracy() > (float)1000 && options.getDesiredAccuracy() != RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy.LOW) {
            RadarLogger.d$default(this.logger, this.context, "Skipping location: inaccurate | accuracy = " + location.getAccuracy(), null, 4, null);
            this.updateTracking$sdk_release(location);
            return;
        }
        new Handler().removeCallbacksAndMessages((Object)"timeout");
        distance = FloatCompanionObject.INSTANCE.getMAX_VALUE();
        duration = 0L;
        if (options.getStopDistance() > 0 && options.getStopDuration() > 0) {
            lastMovedLocation = RadarState.INSTANCE.getLastMovedLocation$sdk_release(this.context);
            if (lastMovedLocation == null) {
                lastMovedLocation = location;
                RadarState.INSTANCE.setLastMovedLocation$sdk_release(this.context, lastMovedLocation);
            }
            if ((lastMovedAt = RadarState.INSTANCE.getLastMovedAt$sdk_release(this.context)) == 0L) {
                lastMovedAt = location.getTime();
                RadarState.INSTANCE.setLastMovedAt$sdk_release(this.context, lastMovedAt);
            }
            if (!force && lastMovedAt > location.getTime()) {
                RadarLogger.d$default(this.logger, this.context, "Skipping location: old | lastMovedAt = " + lastMovedAt + "; location.time = " + location + ".time", null, 4, null);
                return;
            }
            distance = location.distanceTo(lastMovedLocation);
            duration = (location.getTime() - lastMovedAt) / (long)1000;
            stopped.element = distance < (float)options.getStopDistance() && duration > (long)options.getStopDuration();
            RadarLogger.d$default(this.logger, this.context, "Calculating stopped | stopped = " + stopped.element + "; distance = " + distance + "; duration = " + duration + "; location.time = " + location.getTime() + "; lastMovedAt = " + lastMovedAt, null, 4, null);
            if (distance > (float)options.getStopDistance()) {
                RadarState.INSTANCE.setLastMovedLocation$sdk_release(this.context, location);
                if (!stopped.element) {
                    RadarState.INSTANCE.setLastMovedAt$sdk_release(this.context, location.getTime());
                }
            }
        } else {
            stopped.element = force != false || source == Radar.RadarLocationSource.GEOFENCE_DWELL;
        }
        justStopped = stopped.element != false && wasStopped == false;
        RadarState.INSTANCE.setStopped$sdk_release(this.context, stopped.element);
        locationIntent = RadarReceiver.Companion.createLocationIntent$sdk_release(location, stopped.element, source);
        Radar.INSTANCE.broadcastIntent$sdk_release(locationIntent);
        if (source != Radar.RadarLocationSource.MANUAL_LOCATION) {
            this.updateTracking$sdk_release(location);
        }
        this.callCallbacks(Radar.RadarStatus.SUCCESS, location);
        var12_14 = new Ref.ObjectRef();
        var12_14.element = location;
        lastFailedStoppedLocation = RadarState.INSTANCE.getLastFailedStoppedLocation$sdk_release(this.context);
        var14_16 = new Ref.BooleanRef();
        var14_16.element = false;
        if (options.getReplay() == RadarTrackingOptions.RadarTrackingOptionsReplay.STOPS && lastFailedStoppedLocation != null && !justStopped) {
            sendLocation.element = lastFailedStoppedLocation;
            stopped.element = true;
            replayed.element = true;
            RadarState.INSTANCE.setLastFailedStoppedLocation$sdk_release(this.context, null);
            RadarLogger.d$default(this.logger, this.context, "Replaying location | location = " + location + "; stopped = " + stopped.element, null, 4, null);
        }
        if ((lastSentAt = RadarState.INSTANCE.getLastSentAt$sdk_release(this.context)) == 0L) ** GOTO lbl-1000
        var18_18 = this.callbacks;
        var19_20 = false;
        if (var18_18.size() > 0 || justStopped || replayed.element) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        ignoreSync = v1;
        now = System.currentTimeMillis();
        lastSyncInterval = now - lastSentAt;
        if (!ignoreSync) {
            if (!force && stopped.element && wasStopped && distance < (float)options.getStopDistance() && (options.getDesiredStoppedUpdateInterval() == 0 || options.getSync() != RadarTrackingOptions.RadarTrackingOptionsSync.ALL)) {
                RadarLogger.d$default(this.logger, this.context, "Skipping sync: already stopped | stopped = " + stopped.element + "; wasStopped = " + wasStopped, null, 4, null);
                return;
            }
            if (lastSyncInterval < (long)options.getDesiredSyncInterval()) {
                RadarLogger.d$default(this.logger, this.context, "Skipping sync: desired sync interval | desiredSyncInterval = " + options.getDesiredSyncInterval() + "; lastSyncInterval = " + lastSyncInterval, null, 4, null);
                return;
            }
            if (!force && !justStopped && lastSyncInterval < 1000L) {
                RadarLogger.d$default(this.logger, this.context, "Skipping sync: rate limit | justStopped = " + justStopped + "; lastSyncInterval = " + lastSyncInterval, null, 4, null);
                return;
            }
            if (options.getSync() == RadarTrackingOptions.RadarTrackingOptionsSync.NONE) {
                RadarLogger.d$default(this.logger, this.context, "Skipping sync: sync mode | sync = " + (Object)options.getSync(), null, 4, null);
                return;
            }
            canExit = RadarState.INSTANCE.getCanExit$sdk_release(this.context);
            if (!canExit && options.getSync() == RadarTrackingOptions.RadarTrackingOptionsSync.STOPS_AND_EXITS) {
                RadarLogger.d$default(this.logger, this.context, "Skipping sync: can't exit | sync = " + (Object)options.getSync() + "; canExit = " + canExit, null, 4, null);
                return;
            }
        }
        RadarState.INSTANCE.updateLastSentAt$sdk_release(this.context);
        if (source == Radar.RadarLocationSource.FOREGROUND_LOCATION) {
            return;
        }
        if (lastSyncInterval < 1000L) {
            RadarLogger.d$default(this.logger, this.context, "Scheduling location send", null, 4, null);
            new Handler().postAtTime(new Runnable(this, (Ref.ObjectRef)sendLocation, stopped, source, (Ref.BooleanRef)replayed){
                final /* synthetic */ RadarLocationManager this$0;
                final /* synthetic */ Ref.ObjectRef $sendLocation;
                final /* synthetic */ Ref.BooleanRef $stopped;
                final /* synthetic */ Radar.RadarLocationSource $source;
                final /* synthetic */ Ref.BooleanRef $replayed;

                public final void run() {
                    RadarLocationManager.access$sendLocation(this.this$0, (Location)this.$sendLocation.element, this.$stopped.element, this.$source, this.$replayed.element);
                }
                {
                    this.this$0 = radarLocationManager;
                    this.$sendLocation = objectRef;
                    this.$stopped = booleanRef;
                    this.$source = radarLocationSource;
                    this.$replayed = booleanRef2;
                }
            }, (Object)"send", SystemClock.uptimeMillis() + 2000L);
        } else {
            this.sendLocation((Location)sendLocation.element, stopped.element, source, replayed.element);
        }
    }

    private final void sendLocation(Location location, boolean stopped, Radar.RadarLocationSource source, boolean replayed) {
        RadarLogger.d$default(this.logger, this.context, "Sending location | source = " + (Object)((Object)source) + "; location = " + location + "; stopped = " + stopped + "; replayed = " + replayed, null, 4, null);
        RadarLocationManager locationManager = this;
        this.apiClient.track$sdk_release(location, stopped, RadarActivityLifecycleCallbacks.Companion.getForeground(), source, replayed, new RadarApiClient.RadarTrackApiCallback(this, locationManager){
            final /* synthetic */ RadarLocationManager this$0;
            final /* synthetic */ RadarLocationManager $locationManager;

            /*
             * Unable to fully structure code
             */
            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res, @Nullable RadarEvent[] events, @Nullable RadarUser user, @Nullable RadarGeofence[] nearbyGeofences) {
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
                    if (user == null) break block2;
                    if (user.getGeofences() == null) ** GOTO lbl-1000
                    var7_6 = user.getGeofences();
                    var8_8 = false;
                    var9_9 = var7_6;
                    var10_11 = false;
                    if (var9_9.length == 0 == false) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                    inGeofences = v0;
                    atPlace = user.getPlace() != null;
                    v1 = user.getInsights();
                    atHome = v1 != null && (v1 = v1.getState()) != null ? v1.getHome() : false;
                    v2 = user.getInsights();
                    atOffice = v2 != null && (v2 = v2.getState()) != null ? v2.getOffice() : false;
                    canExit = inGeofences != false || atPlace != false || atHome != false || atOffice != false;
                    RadarState.INSTANCE.setCanExit$sdk_release(RadarLocationManager.access$getContext$p(this.this$0), canExit);
                }
                RadarLocationManager.access$replaceSyncedGeofences(this.$locationManager, nearbyGeofences);
            }
            {
                this.this$0 = $outer;
                this.$locationManager = $captured_local_variable$1;
            }
        });
    }

    @NotNull
    public final RadarPermissionsHelper getPermissionsHelper$sdk_release() {
        return this.permissionsHelper;
    }

    public final void setPermissionsHelper$sdk_release(@NotNull RadarPermissionsHelper radarPermissionsHelper) {
        Intrinsics.checkParameterIsNotNull((Object)radarPermissionsHelper, (String)"<set-?>");
        this.permissionsHelper = radarPermissionsHelper;
    }

    public RadarLocationManager(@NotNull Context context, @NotNull RadarApiClient apiClient, @NotNull RadarLogger logger, @NotNull RadarPermissionsHelper permissionsHelper) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)apiClient, (String)"apiClient");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)permissionsHelper, (String)"permissionsHelper");
        this.context = context;
        this.apiClient = apiClient;
        this.logger = logger;
        this.permissionsHelper = permissionsHelper;
        this.locationClient = new FusedLocationProviderClient(this.context);
        this.geofencingClient = new GeofencingClient(this.context);
        this.startedDesiredAccuracy = RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy.NONE;
        this.callbacks = new ArrayList();
    }

    public /* synthetic */ RadarLocationManager(Context context, RadarApiClient radarApiClient, RadarLogger radarLogger, RadarPermissionsHelper radarPermissionsHelper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            radarPermissionsHelper = new RadarPermissionsHelper();
        }
        this(context, radarApiClient, radarLogger, radarPermissionsHelper);
    }

    public static final /* synthetic */ ArrayList access$getCallbacks$p(RadarLocationManager $this) {
        return $this.callbacks;
    }

    public static final /* synthetic */ void access$sendLocation(RadarLocationManager $this, Location location, boolean stopped, Radar.RadarLocationSource source, boolean replayed) {
        $this.sendLocation(location, stopped, source, replayed);
    }

    public static final /* synthetic */ Context access$getContext$p(RadarLocationManager $this) {
        return $this.context;
    }

    public static final /* synthetic */ void access$replaceSyncedGeofences(RadarLocationManager $this, RadarGeofence[] radarGeofences) {
        $this.replaceSyncedGeofences(radarGeofences);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/radar/sdk/RadarLocationManager$Companion;", "", "()V", "BUBBLE_MOVING_GEOFENCE_REQUEST_ID", "", "BUBBLE_STOPPED_GEOFENCE_REQUEST_ID", "SYNCED_GEOFENCES_REQUEST_ID_PREFIX", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

